/*
 * Decompiled with CFR 0.152.
 */
package xni;

import java.io.PrintWriter;
import org.apache.xerces.parsers.XMLDocumentParser;
import org.apache.xerces.parsers.XMLParser;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;

public class Counter
extends XMLDocumentParser
implements XMLErrorHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DEFAULT_PARSER_CONFIG = "org.apache.xerces.parsers.XML11Configuration";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_MEMORY_USAGE = false;
    protected static final boolean DEFAULT_TAGGINESS = false;
    protected long fElements;
    protected long fAttributes;
    protected long fCharacters;
    protected long fIgnorableWhitespace;
    protected long fTagCharacters;
    protected long fOtherCharacters;

    public Counter(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        ((XMLParser)this).fConfiguration.setErrorHandler((XMLErrorHandler)this);
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, boolean bl, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print(l / (long)n);
        }
        printWriter.print(" ms");
        if (l2 != Long.MIN_VALUE) {
            printWriter.print(", ");
            printWriter.print(l2);
            printWriter.print(" bytes");
        }
        printWriter.print(" (");
        printWriter.print(this.fElements);
        printWriter.print(" elems, ");
        printWriter.print(this.fAttributes);
        printWriter.print(" attrs, ");
        printWriter.print(this.fIgnorableWhitespace);
        printWriter.print(" spaces, ");
        printWriter.print(this.fCharacters);
        printWriter.print(" chars)");
        if (bl) {
            printWriter.print(' ');
            long l3 = this.fTagCharacters + this.fOtherCharacters + this.fCharacters + this.fIgnorableWhitespace;
            long l4 = this.fTagCharacters * 100L / l3;
            printWriter.print(l4);
            printWriter.print("% tagginess");
        }
        printWriter.println();
        printWriter.flush();
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fElements = 0L;
        this.fAttributes = 0L;
        this.fCharacters = 0L;
        this.fIgnorableWhitespace = 0L;
        this.fTagCharacters = 0L;
        this.fOtherCharacters = 0L;
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        ++this.fElements;
        ++this.fTagCharacters;
        this.fTagCharacters += (long)qName.rawname.length();
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            this.fAttributes += (long)n;
            int n2 = 0;
            while (n2 < n) {
                ++this.fTagCharacters;
                this.fTagCharacters += (long)xMLAttributes.getQName(n2).length();
                ++this.fTagCharacters;
                ++this.fTagCharacters;
                this.fOtherCharacters += (long)xMLAttributes.getValue(n2).length();
                ++this.fTagCharacters;
                ++n2;
            }
        }
        ++this.fTagCharacters;
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        ++this.fElements;
        ++this.fTagCharacters;
        this.fTagCharacters += (long)qName.rawname.length();
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            this.fAttributes += (long)n;
            int n2 = 0;
            while (n2 < n) {
                ++this.fTagCharacters;
                this.fTagCharacters += (long)xMLAttributes.getQName(n2).length();
                ++this.fTagCharacters;
                ++this.fTagCharacters;
                this.fOtherCharacters += (long)xMLAttributes.getValue(n2).length();
                ++this.fTagCharacters;
                ++n2;
            }
        }
        ++this.fTagCharacters;
        ++this.fTagCharacters;
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fCharacters += (long)xMLString.length;
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fIgnorableWhitespace += (long)xMLString.length;
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fTagCharacters += 2L;
        this.fTagCharacters += (long)string.length();
        if (xMLString.length > 0) {
            ++this.fTagCharacters;
            this.fOtherCharacters += (long)xMLString.length;
        }
        this.fTagCharacters += 2L;
    }

    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Warning", xMLParseException);
    }

    public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Error", xMLParseException);
    }

    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Fatal Error", xMLParseException);
        throw xMLParseException;
    }

    protected void printError(String string, XMLParseException xMLParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = xMLParseException.getExpandedSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(xMLParseException.getLineNumber());
        System.err.print(':');
        System.err.print(xMLParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(xMLParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Counter.printUsage();
            System.exit(1);
        }
        PrintWriter printWriter = new PrintWriter(System.out);
        Counter counter = null;
        XMLParserConfiguration xMLParserConfiguration = null;
        int n = 1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            block56: {
                Object object;
                String string = stringArray[n2];
                if (string.startsWith("-")) {
                    String string2 = string.substring(1);
                    if (string2.equals("p")) {
                        if (++n2 == stringArray.length) {
                            System.err.println("error: Missing argument to -p option.");
                        } else {
                            object = stringArray[n2];
                            try {
                                xMLParserConfiguration = (XMLParserConfiguration)ObjectFactory.newInstance((String)object, (ClassLoader)ObjectFactory.findClassLoader(), (boolean)true);
                                xMLParserConfiguration.addRecognizedFeatures(new String[]{NAMESPACE_PREFIXES_FEATURE_ID});
                                counter = null;
                            }
                            catch (Exception exception) {
                                xMLParserConfiguration = null;
                                System.err.println("error: Unable to instantiate parser configuration (" + (String)object + ")");
                            }
                        }
                    } else if (string2.equals("x")) {
                        if (++n2 == stringArray.length) {
                            System.err.println("error: Missing argument to -x option.");
                        } else {
                            object = stringArray[n2];
                            try {
                                int n3 = Integer.parseInt((String)object);
                                if (n3 < 1) {
                                    System.err.println("error: Repetition must be at least 1.");
                                    break block56;
                                }
                                n = n3;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println("error: invalid number (" + (String)object + ").");
                            }
                        }
                    } else if (string2.equalsIgnoreCase("n")) {
                        bl = string2.equals("n");
                    } else if (string2.equalsIgnoreCase("np")) {
                        bl2 = string2.equals("np");
                    } else if (string2.equalsIgnoreCase("v")) {
                        bl3 = string2.equals("v");
                    } else if (string2.equalsIgnoreCase("s")) {
                        bl4 = string2.equals("s");
                    } else if (string2.equalsIgnoreCase("f")) {
                        bl5 = string2.equals("f");
                    } else if (string2.equalsIgnoreCase("m")) {
                        bl6 = string2.equals("m");
                    } else if (string2.equalsIgnoreCase("t")) {
                        bl7 = string2.equals("t");
                    } else if (string2.equals("-rem")) {
                        if (++n2 == stringArray.length) {
                            System.err.println("error: Missing argument to -# option.");
                        } else {
                            System.out.print("# ");
                            System.out.println(stringArray[n2]);
                        }
                    } else if (string2.equals("h")) {
                        Counter.printUsage();
                    } else {
                        System.err.println("error: unknown option (" + string2 + ").");
                    }
                } else {
                    block58: {
                        block57: {
                            if (xMLParserConfiguration == null) {
                                try {
                                    xMLParserConfiguration = (XMLParserConfiguration)ObjectFactory.newInstance((String)DEFAULT_PARSER_CONFIG, (ClassLoader)ObjectFactory.findClassLoader(), (boolean)true);
                                    xMLParserConfiguration.addRecognizedFeatures(new String[]{NAMESPACE_PREFIXES_FEATURE_ID});
                                }
                                catch (Exception exception) {
                                    System.err.println("error: Unable to instantiate parser configuration (org.apache.xerces.parsers.XML11Configuration)");
                                    break block56;
                                }
                            }
                            if (counter == null) {
                                counter = new Counter(xMLParserConfiguration);
                            }
                            try {
                                xMLParserConfiguration.setFeature(NAMESPACES_FEATURE_ID, bl);
                            }
                            catch (XMLConfigurationException xMLConfigurationException) {
                                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                            }
                            try {
                                xMLParserConfiguration.setFeature(VALIDATION_FEATURE_ID, bl3);
                            }
                            catch (XMLConfigurationException xMLConfigurationException) {
                                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                            }
                            try {
                                xMLParserConfiguration.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl4);
                            }
                            catch (XMLConfigurationException xMLConfigurationException) {
                                if (xMLConfigurationException.getType() != 1) break block57;
                                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                            }
                        }
                        try {
                            xMLParserConfiguration.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl5);
                        }
                        catch (XMLConfigurationException xMLConfigurationException) {
                            if (xMLConfigurationException.getType() != 1) break block58;
                            System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                        }
                    }
                    try {
                        long l;
                        long l2 = System.currentTimeMillis();
                        long l3 = 0L;
                        if (bl6) {
                            System.gc();
                            l3 = Runtime.getRuntime().freeMemory();
                        }
                        int n4 = 0;
                        while (n4 < n) {
                            counter.parse(new XMLInputSource(null, string, null));
                            ++n4;
                        }
                        long l4 = Long.MIN_VALUE;
                        if (bl6) {
                            l = Runtime.getRuntime().freeMemory();
                            l4 = l3 - l;
                        }
                        l = System.currentTimeMillis();
                        long l5 = l - l2;
                        counter.printResults(printWriter, string, l5, l4, bl7, n);
                    }
                    catch (XMLParseException xMLParseException) {
                    }
                    catch (Exception exception) {
                        System.err.println("error: Parse error occurred - " + exception.getMessage());
                        if (exception instanceof XNIException) {
                            object = ((XNIException)exception).getException();
                        }
                        ((Throwable)object).printStackTrace(System.err);
                    }
                }
            }
            ++n2;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java xni.Counter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser configuration by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parser configurations.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -m  | -M    Turn on/off memory usage report.");
        System.err.println("  -t  | -T    Turn on/off \"tagginess\" report.");
        System.err.println("  --rem text  Output user defined comment before next parse.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Config:     org.apache.xerces.parsers.XML11Configuration");
        System.err.println("  Repetition: 1");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Memory:     ");
        System.err.println("off");
        System.err.print("  Tagginess:  ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The speed and memory results from this program should NOT be used as the");
        System.err.println("  basis of parser performance comparison! Real analytical methods should be");
        System.err.println("  used. For better results, perform multiple document parses within the same");
        System.err.println("  virtual machine to remove class loading from parse time and memory usage.");
        System.err.println();
        System.err.println("  The \"tagginess\" measurement gives a rough estimate of the percentage of");
        System.err.println("  markup versus content in the XML document. The percent tagginess of a ");
        System.err.println("  document is equal to the minimum amount of tag characters required for ");
        System.err.println("  elements, attributes, and processing instructions divided by the total");
        System.err.println("  amount of characters (characters, ignorable whitespace, and tag characters)");
        System.err.println("  in the document.");
        System.err.println();
        System.err.println("  Not all features are supported by different parser configurations.");
    }
}

