/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class DocumentTracer
extends DefaultHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler,
DocumentHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected PrintWriter fOut;
    protected int fIndent;

    public DocumentTracer() {
        this.setOutput(new PrintWriter(System.out));
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setDocumentLocator(Locator locator) {
        this.printIndent();
        this.fOut.print("setDocumentLocator(");
        this.fOut.print("locator=");
        this.fOut.print(locator);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startDocument() throws SAXException {
        this.fIndent = 0;
        this.printIndent();
        this.fOut.println("startDocument()");
        this.fOut.flush();
        ++this.fIndent;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("processingInstruction(");
        this.fOut.print("target=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("data=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("characters(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("ignorableWhitespace(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endDocument() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endDocument()");
        this.fOut.flush();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("startPrefixMapping(");
        this.fOut.print("prefix=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("uri=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.printIndent();
        this.fOut.print("startElement(");
        this.fOut.print("uri=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("localName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("qname=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (attributes == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    this.fOut.print(',');
                }
                String string4 = attributes.getLocalName(n2);
                String string5 = attributes.getQName(n2);
                String string6 = attributes.getURI(n2);
                String string7 = attributes.getType(n2);
                String string8 = attributes.getValue(n2);
                this.fOut.print('{');
                this.fOut.print("uri=");
                this.printQuotedString(string6);
                this.fOut.print(',');
                this.fOut.print("localName=");
                this.printQuotedString(string4);
                this.fOut.print(',');
                this.fOut.print("qname=");
                this.printQuotedString(string5);
                this.fOut.print(',');
                this.fOut.print("type=");
                this.printQuotedString(string7);
                this.fOut.print(',');
                this.fOut.print("value=");
                this.printQuotedString(string8);
                this.fOut.print('}');
                ++n2;
            }
            this.fOut.print('}');
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("uri=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("localName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("qname=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("endPrefixMapping(");
        this.fOut.print("prefix=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void skippedEntity(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("skippedEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.printIndent();
        this.fOut.print("startElement(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (attributeList == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = attributeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    System.out.print(',');
                }
                String string2 = attributeList.getName(n2);
                String string3 = attributeList.getType(n2);
                String string4 = attributeList.getValue(n2);
                this.fOut.print('{');
                this.fOut.print("name=");
                this.printQuotedString(string2);
                this.fOut.print(',');
                this.fOut.print("type=");
                this.printQuotedString(string3);
                this.fOut.print(',');
                this.fOut.print("value=");
                this.printQuotedString(string4);
                this.fOut.print('}');
                ++n2;
            }
            this.fOut.print('}');
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endElement(String string) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("notationDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.printIndent();
        this.fOut.print("unparsedEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("notationName=");
        this.printQuotedString(string4);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("startDTD(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void startEntity(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("startEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void startCDATA() throws SAXException {
        this.printIndent();
        this.fOut.println("startCDATA()");
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endCDATA() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endCDATA()");
        this.fOut.flush();
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("comment(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endEntity(String string) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
    }

    public void endDTD() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endDTD()");
        this.fOut.flush();
    }

    public void elementDecl(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("elementDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("contentModel=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.printIndent();
        this.fOut.print("attributeDecl(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("attributeName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("type=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("valueDefault=");
        this.printQuotedString(string4);
        this.fOut.print(',');
        this.fOut.print("value=");
        this.printQuotedString(string5);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("internalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("text=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("externalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    protected void printQuotedString(String string) {
        if (string == null) {
            this.fOut.print("null");
            return;
        }
        this.fOut.print('\"');
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c);
            ++n2;
        }
        this.fOut.print('\"');
    }

    protected void printQuotedString(char[] cArray, int n, int n2) {
        this.fOut.print('\"');
        int n3 = 0;
        while (n3 < n2) {
            this.normalizeAndPrint(cArray[n + n3]);
            ++n3;
        }
        this.fOut.print('\"');
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '\n': {
                this.fOut.print("\\n");
                break;
            }
            case '\r': {
                this.fOut.print("\\r");
                break;
            }
            case '\t': {
                this.fOut.print("\\t");
                break;
            }
            case '\\': {
                this.fOut.print("\\\\");
                break;
            }
            case '\"': {
                this.fOut.print("\\\"");
                break;
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void printIndent() {
        int n = 0;
        while (n < this.fIndent) {
            this.fOut.print(' ');
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Exception {
        if (var0.length == 0) {
            DocumentTracer.printUsage();
            System.exit(1);
        }
        var1_1 = new DocumentTracer();
        var2_2 = new PrintWriter(System.out);
        var3_3 = null;
        var4_4 = true;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        var8_8 = 0;
        while (var8_8 < var0.length) {
            block42: {
                var9_9 = var0[var8_8];
                if (!var9_9.startsWith("-")) ** GOTO lbl-1000
                var10_10 = var9_9.substring(1);
                if (var10_10.equals("p")) {
                    if (++var8_8 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var11_19 = var0[var8_8];
                    try {
                        var3_3 = XMLReaderFactory.createXMLReader((String)var11_19);
                    }
                    catch (Exception var12_24) {
                        try {
                            var13_25 = ParserFactory.makeParser((String)var11_19);
                            var3_3 = new ParserAdapter(var13_25);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception var13_26) {
                            var3_3 = null;
                            System.err.println("error: Unable to instantiate parser (" + (String)var11_19 + ")");
                        }
                    }
                } else if (var10_10.equalsIgnoreCase("n")) {
                    var4_4 = var10_10.equals("n");
                } else if (var10_10.equalsIgnoreCase("v")) {
                    var5_5 = var10_10.equals("v");
                } else if (var10_10.equalsIgnoreCase("s")) {
                    var6_6 = var10_10.equals("s");
                } else if (var10_10.equalsIgnoreCase("f")) {
                    var7_7 = var10_10.equals("f");
                } else if (var10_10.equals("h")) {
                    DocumentTracer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var3_3 == null) {
                        try {
                            var3_3 = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                        }
                        catch (Exception var10_11) {
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                            break block42;
                        }
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/namespaces", var4_4);
                    }
                    catch (SAXException var10_12) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/validation", var5_5);
                    }
                    catch (SAXException var10_13) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema", var6_6);
                    }
                    catch (SAXNotRecognizedException var10_14) {
                    }
                    catch (SAXNotSupportedException var11_20) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var7_7);
                    }
                    catch (SAXNotRecognizedException var10_15) {
                    }
                    catch (SAXNotSupportedException var11_21) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    var3_3.setDTDHandler(var1_1);
                    var3_3.setErrorHandler(var1_1);
                    if (var3_3 instanceof XMLReader) {
                        var3_3.setContentHandler(var1_1);
                        try {
                            var3_3.setProperty("http://xml.org/sax/properties/declaration-handler", var1_1);
                        }
                        catch (SAXException var10_16) {
                            var10_16.printStackTrace(System.err);
                        }
                        try {
                            var3_3.setProperty("http://xml.org/sax/properties/lexical-handler", var1_1);
                        }
                        catch (SAXException var10_17) {
                            var10_17.printStackTrace(System.err);
                        }
                    } else {
                        ((Parser)var3_3).setDocumentHandler(var1_1);
                    }
                    try {
                        var3_3.parse(var9_9);
                    }
                    catch (SAXParseException var10_18) {
                    }
                    catch (Exception var11_22) {
                        System.err.println("error: Parse error occurred - " + var11_22.getMessage());
                        if (var11_22 instanceof SAXException && (var12_23 = ((SAXException)var11_22).getException()) != null) {
                            var11_19 = var12_23;
                        }
                        var11_19.printStackTrace(System.err);
                    }
                }
            }
            ++var8_8;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.DocumentTracer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Select parser by name.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
    }
}

