/*
 * Decompiled with CFR 0.152.
 */
package xni;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.xerces.parsers.XMLDocumentParser;
import org.apache.xerces.parsers.XMLParser;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;

public class DocumentTracer
extends XMLDocumentParser
implements XMLErrorHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String NOTIFY_CHAR_REFS_FEATURE_ID = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String DEFAULT_PARSER_CONFIG = "org.apache.xerces.parsers.IntegratedParserConfiguration";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_NOTIFY_CHAR_REFS = false;
    private QName fQName = new QName();
    protected PrintWriter fOut;
    protected int fIndent;

    public DocumentTracer() {
        this(null);
    }

    public DocumentTracer(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        this.setOutput(new PrintWriter(System.out));
        ((XMLParser)this).fConfiguration.setErrorHandler((XMLErrorHandler)this);
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fIndent = 0;
        this.printIndent();
        this.fOut.print("startDocument(");
        this.fOut.print("locator=");
        if (xMLLocator == null) {
            this.fOut.print("null");
        } else {
            this.fOut.print('{');
            this.fOut.print("publicId=");
            this.printQuotedString(xMLLocator.getPublicId());
            this.fOut.print(',');
            this.fOut.print("literal systemId=");
            this.printQuotedString(xMLLocator.getLiteralSystemId());
            this.fOut.print(',');
            this.fOut.print("baseSystemId=");
            this.printQuotedString(xMLLocator.getBaseSystemId());
            this.fOut.print(',');
            this.fOut.print("expanded systemId=");
            this.printQuotedString(xMLLocator.getExpandedSystemId());
            this.fOut.print(',');
            this.fOut.print("lineNumber=");
            this.fOut.print(xMLLocator.getLineNumber());
            this.fOut.print(',');
            this.fOut.print("columnNumber=");
            this.fOut.print(xMLLocator.getColumnNumber());
            this.fOut.print('}');
        }
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("xmlDecl(");
        this.fOut.print("version=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("standalone=");
        this.printQuotedString(string3);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("doctypeDecl(");
        this.fOut.print("rootElement=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.flush();
    }

    public void startPrefixMapping(String string, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startPrefixMapping(");
        this.fOut.print("prefix=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("uri=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startElement(");
        this.printElement(qName, xMLAttributes);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("emptyElement(");
        this.printElement(qName, xMLAttributes);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("characters(");
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("ignorableWhitespace(");
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("element=");
        this.fOut.print('{');
        this.fOut.print("prefix=");
        this.printQuotedString(qName.prefix);
        this.fOut.print(',');
        this.fOut.print("localpart=");
        this.printQuotedString(qName.localpart);
        this.fOut.print(',');
        this.fOut.print("rawname=");
        this.printQuotedString(qName.rawname);
        this.fOut.print(',');
        this.fOut.print("uri=");
        this.printQuotedString(qName.uri);
        this.fOut.print('}');
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("endPrefixMapping(");
        this.fOut.print("prefix=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startCDATA(");
        if (augmentations != null) {
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endCDATA(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startGeneralEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("identifier=");
        this.fOut.print(xMLResourceIdentifier);
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("textDecl(");
        this.fOut.print("version=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("comment(");
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("processingInstruction(");
        this.fOut.print("target=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("data=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endGeneralEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endDocument(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startDTD(");
        this.fOut.print("locator=");
        if (xMLLocator == null) {
            this.fOut.print("null");
        } else {
            this.fOut.print('{');
            this.fOut.print("publicId=");
            this.printQuotedString(xMLLocator.getPublicId());
            this.fOut.print(',');
            this.fOut.print("literal systemId=");
            this.printQuotedString(xMLLocator.getLiteralSystemId());
            this.fOut.print(',');
            this.fOut.print("baseSystemId=");
            this.printQuotedString(xMLLocator.getBaseSystemId());
            this.fOut.print(',');
            this.fOut.print("expanded systemId=");
            this.printQuotedString(xMLLocator.getExpandedSystemId());
            this.fOut.print(',');
            this.fOut.print("lineNumber=");
            this.fOut.print(xMLLocator.getLineNumber());
            this.fOut.print(',');
            this.fOut.print("columnNumber=");
            this.fOut.print(xMLLocator.getColumnNumber());
            this.fOut.print('}');
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startExternalSubset(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endExternalSubset(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void ignoredCharacters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("ignoredCharacters(");
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startParameterEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startParameterEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("identifier=");
        this.fOut.print(xMLResourceIdentifier);
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endParameterEntity(String string, Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endParameterEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void elementDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("elementDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("contentModel=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startAttlist(String string, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startAttlist(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("attributeDecl(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("attributeName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("type=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("enumeration=");
        if (stringArray == null) {
            this.fOut.print("null");
        } else {
            this.fOut.print('{');
            int n = 0;
            while (n < stringArray.length) {
                this.printQuotedString(stringArray[n]);
                if (n < stringArray.length - 1) {
                    this.fOut.print(',');
                }
                ++n;
            }
            this.fOut.print('}');
        }
        this.fOut.print(',');
        this.fOut.print("defaultType=");
        this.printQuotedString(string4);
        this.fOut.print(',');
        this.fOut.print("defaultValue=");
        if (xMLString == null) {
            this.fOut.print("null");
        } else {
            this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        }
        this.fOut.print(',');
        this.fOut.print("nonNormalizedDefaultValue=");
        if (xMLString2 == null) {
            this.fOut.print("null");
        } else {
            this.printQuotedString(xMLString2.ch, xMLString2.offset, xMLString2.length);
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endAttlist(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endAttlist(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void internalEntityDecl(String string, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("internalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        this.fOut.print(',');
        this.fOut.print("nonNormalizedText=");
        this.printQuotedString(xMLString2.ch, xMLString2.offset, xMLString2.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void externalEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("externalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(xMLResourceIdentifier.getPublicId());
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(xMLResourceIdentifier.getLiteralSystemId());
        this.fOut.print(',');
        this.fOut.print("baseSystemId=");
        this.printQuotedString(xMLResourceIdentifier.getBaseSystemId());
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void unparsedEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("unparsedEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(xMLResourceIdentifier.getPublicId());
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(xMLResourceIdentifier.getLiteralSystemId());
        this.fOut.print(',');
        this.fOut.print("baseSystemId=");
        this.printQuotedString(xMLResourceIdentifier.getBaseSystemId());
        this.fOut.print(',');
        this.fOut.print("notation=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void notationDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("notationDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(xMLResourceIdentifier.getPublicId());
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(xMLResourceIdentifier.getLiteralSystemId());
        this.fOut.print(',');
        this.fOut.print("baseSystemId=");
        this.printQuotedString(xMLResourceIdentifier.getBaseSystemId());
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startConditional(short s, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startConditional(");
        this.fOut.print("type=");
        switch (s) {
            case 1: {
                this.fOut.print("CONDITIONAL_IGNORE");
                break;
            }
            case 0: {
                this.fOut.print("CONDITIONAL_INCLUDE");
                break;
            }
            default: {
                this.fOut.print("??? (" + s + ')');
            }
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endConditional(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endConditional(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endDTD(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startContentModel(String string, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startContentModel(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void any(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("any(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void empty(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("empty(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startGroup(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startGroup(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void pcdata(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("pcdata(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void element(String string, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("element(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void separator(short s, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("separator(");
        this.fOut.print("separator=");
        switch (s) {
            case 0: {
                this.fOut.print("SEPARATOR_CHOICE");
                break;
            }
            case 1: {
                this.fOut.print("SEPARATOR_SEQUENCE");
                break;
            }
            default: {
                this.fOut.print("??? (" + s + ')');
            }
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void occurrence(short s, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("occurrence(");
        this.fOut.print("occurrence=");
        switch (s) {
            case 4: {
                this.fOut.print("OCCURS_ONE_OR_MORE");
                break;
            }
            case 3: {
                this.fOut.print("OCCURS_ZERO_OR_MORE");
                break;
            }
            case 2: {
                this.fOut.print("OCCURS_ZERO_OR_ONE");
                break;
            }
            default: {
                this.fOut.print("??? (" + s + ')');
            }
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endGroup(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endGroup(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endContentModel(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endContentModel(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Warning", xMLParseException);
    }

    public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Error", xMLParseException);
    }

    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Fatal Error", xMLParseException);
        throw xMLParseException;
    }

    protected void printElement(QName qName, XMLAttributes xMLAttributes) {
        this.fOut.print("element=");
        this.fOut.print('{');
        this.fOut.print("prefix=");
        this.printQuotedString(qName.prefix);
        this.fOut.print(',');
        this.fOut.print("localpart=");
        this.printQuotedString(qName.localpart);
        this.fOut.print(',');
        this.fOut.print("rawname=");
        this.printQuotedString(qName.rawname);
        this.fOut.print(',');
        this.fOut.print("uri=");
        this.printQuotedString(qName.uri);
        this.fOut.print('}');
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (xMLAttributes == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = xMLAttributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    this.fOut.print(',');
                }
                xMLAttributes.getName(n2, this.fQName);
                String string = xMLAttributes.getType(n2);
                String string2 = xMLAttributes.getValue(n2);
                String string3 = xMLAttributes.getNonNormalizedValue(n2);
                Augmentations augmentations = xMLAttributes.getAugmentations(n2);
                this.fOut.print("name=");
                this.fOut.print('{');
                this.fOut.print("prefix=");
                this.printQuotedString(this.fQName.prefix);
                this.fOut.print(',');
                this.fOut.print("localpart=");
                this.printQuotedString(this.fQName.localpart);
                this.fOut.print(',');
                this.fOut.print("rawname=");
                this.printQuotedString(this.fQName.rawname);
                this.fOut.print(',');
                this.fOut.print("uri=");
                this.printQuotedString(this.fQName.uri);
                this.fOut.print('}');
                this.fOut.print(',');
                this.fOut.print("type=");
                this.printQuotedString(string);
                this.fOut.print(',');
                this.fOut.print("value=");
                this.printQuotedString(string2);
                this.fOut.print(',');
                this.fOut.print("nonNormalizedValue=");
                this.printQuotedString(string3);
                if (!xMLAttributes.isSpecified(n2)) {
                    this.fOut.print("(default)");
                }
                if (augmentations != null) {
                    this.fOut.print(',');
                    this.printAugmentations(augmentations);
                }
                this.fOut.print('}');
                ++n2;
            }
            this.fOut.print('}');
        }
    }

    protected void printAugmentations(Augmentations augmentations) {
        this.fOut.print("augs={");
        Enumeration enumeration = augmentations.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = augmentations.getItem(string);
            this.fOut.print(string);
            this.fOut.print('#');
            this.fOut.print(String.valueOf(object));
        }
        this.fOut.print('}');
    }

    protected void printQuotedString(String string) {
        if (string == null) {
            this.fOut.print("null");
            return;
        }
        this.fOut.print('\"');
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c);
            ++n2;
        }
        this.fOut.print('\"');
    }

    protected void printQuotedString(char[] cArray, int n, int n2) {
        this.fOut.print('\"');
        int n3 = 0;
        while (n3 < n2) {
            this.normalizeAndPrint(cArray[n + n3]);
            ++n3;
        }
        this.fOut.print('\"');
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '\n': {
                this.fOut.print("\\n");
                break;
            }
            case '\r': {
                this.fOut.print("\\r");
                break;
            }
            case '\t': {
                this.fOut.print("\\t");
                break;
            }
            case '\\': {
                this.fOut.print("\\\\");
                break;
            }
            case '\"': {
                this.fOut.print("\\\"");
                break;
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, XMLParseException xMLParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = xMLParseException.getExpandedSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(xMLParseException.getLineNumber());
        System.err.print(':');
        System.err.print(xMLParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(xMLParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void printIndent() {
        int n = 0;
        while (n < this.fIndent) {
            this.fOut.print(' ');
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Exception {
        if (var0.length == 0) {
            DocumentTracer.printUsage();
            System.exit(1);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        var8_8 = 0;
        while (var8_8 < var0.length) {
            block39: {
                var9_9 = var0[var8_8];
                if (!var9_9.startsWith("-")) ** GOTO lbl-1000
                var10_10 = var9_9.substring(1);
                if (var10_10.equals("p")) {
                    if (++var8_8 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    } else {
                        var11_18 = var0[var8_8];
                        try {
                            var2_2 = (XMLParserConfiguration)ObjectFactory.newInstance((String)var11_18, (ClassLoader)ObjectFactory.findClassLoader(), (boolean)true);
                            var1_1 = null;
                        }
                        catch (Exception var12_20) {
                            var2_2 = null;
                            System.err.println("error: Unable to instantiate parser configuration (" + (String)var11_18 + ")");
                        }
                    }
                } else if (var10_10.equalsIgnoreCase("n")) {
                    var3_3 = var10_10.equals("n");
                } else if (var10_10.equalsIgnoreCase("v")) {
                    var4_4 = var10_10.equals("v");
                } else if (var10_10.equalsIgnoreCase("s")) {
                    var5_5 = var10_10.equals("s");
                } else if (var10_10.equalsIgnoreCase("f")) {
                    var6_6 = var10_10.equals("f");
                } else if (var10_10.equalsIgnoreCase("c")) {
                    var7_7 = var10_10.equals("c");
                } else if (var10_10.equals("h")) {
                    DocumentTracer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    block41: {
                        block40: {
                            if (var2_2 == null) {
                                try {
                                    var2_2 = (XMLParserConfiguration)ObjectFactory.newInstance((String)"org.apache.xerces.parsers.IntegratedParserConfiguration", (ClassLoader)ObjectFactory.findClassLoader(), (boolean)true);
                                }
                                catch (Exception var10_11) {
                                    System.err.println("error: Unable to instantiate parser configuration (org.apache.xerces.parsers.IntegratedParserConfiguration)");
                                    break block39;
                                }
                            }
                            if (var1_1 == null) {
                                var1_1 = new DocumentTracer(var2_2);
                            }
                            try {
                                var2_2.setFeature("http://xml.org/sax/features/namespaces", var3_3);
                            }
                            catch (XMLConfigurationException var10_12) {
                                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                            }
                            try {
                                var2_2.setFeature("http://xml.org/sax/features/validation", var4_4);
                            }
                            catch (XMLConfigurationException var10_13) {
                                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                            }
                            try {
                                var2_2.setFeature("http://apache.org/xml/features/validation/schema", var5_5);
                            }
                            catch (XMLConfigurationException var10_14) {
                                if (var10_14.getType() != 1) break block40;
                                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                            }
                        }
                        try {
                            var2_2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var6_6);
                        }
                        catch (XMLConfigurationException var10_15) {
                            if (var10_15.getType() != 1) break block41;
                            System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                        }
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", var7_7);
                    }
                    catch (XMLConfigurationException var10_16) {
                        if (var10_16.getType() == 0) {
                            System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/scanner/notify-char-refs)");
                        }
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/scanner/notify-char-refs)");
                    }
                    try {
                        var1_1.parse(new XMLInputSource(null, var9_9, null));
                    }
                    catch (XMLParseException var10_17) {
                    }
                    catch (Exception var11_19) {
                        System.err.println("error: Parse error occurred - " + var11_19.getMessage());
                        if (var11_19 instanceof XNIException) {
                            var11_18 = ((XNIException)var11_19).getException();
                        }
                        var11_18.printStackTrace(System.err);
                    }
                }
            }
            ++var8_8;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java xni.DocumentTracer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.out.println("  -p name  Specify parser configuration by name.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parser configurations.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -c | -C  Turn on/off character notifications");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.out.println("  Config:     org.apache.xerces.parsers.IntegratedParserConfiguration");
        System.out.print("  Namespaces: ");
        System.err.println("on");
        System.out.print("  Validation: ");
        System.err.println("off");
        System.out.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.out.print("  Char refs:  ");
        System.err.println("off");
    }
}

