/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.Maps;
import convex.core.data.Strings;
import convex.core.data.prim.CVMBool;
import convex.core.lang.RT;
import convex.core.util.JSON;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;

public class X402
extends ABaseAPI {
    private static final String ROUTE = "/verify";
    private static final AString FIELD_MAX_AMOUNT = Strings.create((String)"maxAmountRequired");
    private static final AString FIELD_RESOURCE = Strings.create((String)"resource");
    private static final AString FIELD_DESCRIPTION = Strings.create((String)"description");
    private static final AString FIELD_PAY_TO = Strings.create((String)"payTo");
    private static final AString FIELD_ASSET = Strings.create((String)"asset");
    private static final AString FIELD_NETWORK = Strings.create((String)"network");
    private static final AString FIELD_IS_VALID = Strings.create((String)"isValid");
    private static final AString FIELD_INVALID_REASON = Strings.create((String)"invalidReason");
    private static final AString FIELD_PAYER = Strings.create((String)"payer");

    public X402(RESTServer restServer) {
        super(restServer);
    }

    @Override
    public void addRoutes(Javalin app) {
        app.post(ROUTE, this::handleVerify);
    }

    public void respondPaymentRequired(Context ctx, AMap<AString, ACell> baseFields) {
        AMap payload = baseFields == null ? Maps.empty() : baseFields;
        payload = payload.assoc((ACell)FIELD_MAX_AMOUNT, (ACell)Strings.create((String)"0.10"));
        payload = payload.assoc((ACell)FIELD_RESOURCE, (ACell)Strings.create((String)"/api/market-data"));
        payload = payload.assoc((ACell)FIELD_DESCRIPTION, (ACell)Strings.create((String)"Access to real-time market data requires payment."));
        payload = payload.assoc((ACell)FIELD_PAY_TO, (ACell)Strings.create((String)"#13"));
        payload = payload.assoc((ACell)FIELD_ASSET, (ACell)Strings.create((String)"slip44:864"));
        payload = payload.assoc((ACell)FIELD_NETWORK, (ACell)Strings.create((String)"convex"));
        ctx.status(402);
        ctx.contentType("application/json");
        ctx.result(JSON.toString((Object)payload));
    }

    private void handleVerify(Context ctx) {
        AString invalidReason;
        AMap<AString, ACell> body = this.readJSONBody(ctx);
        AString payer = RT.ensureString((ACell)body.get((ACell)FIELD_PAYER));
        if (payer == null) {
            throw new BadRequestResponse("Missing 'payer' field");
        }
        boolean isValid = true;
        ACell isValidCell = body.get((ACell)FIELD_IS_VALID);
        if (isValidCell != null) {
            isValid = RT.bool((ACell)isValidCell);
        }
        if ((invalidReason = RT.ensureString((ACell)body.get((ACell)FIELD_INVALID_REASON))) != null && invalidReason.count() > 0L) {
            isValid = false;
        }
        if (!isValid && invalidReason == null) {
            invalidReason = Strings.create((String)"insufficient_funds");
        }
        AHashMap response = Maps.of((Object[])new Object[]{FIELD_IS_VALID, isValid ? CVMBool.TRUE : CVMBool.FALSE, FIELD_PAYER, payer});
        if (!isValid && invalidReason != null) {
            response = response.assoc((ACell)FIELD_INVALID_REASON, (ACell)invalidReason);
        }
        ctx.status(200);
        ctx.contentType("application/json");
        ctx.result(JSON.toString((Object)response));
    }
}

