/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.cpos.Block;
import convex.core.cpos.Order;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.crypto.IdenticonBuilder;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.Peer;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.Symbols;
import convex.core.cvm.transactions.ATransaction;
import convex.core.cvm.transactions.Invoke;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Lists;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.exceptions.ParseException;
import convex.core.exceptions.ResultException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.util.JSON;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import convex.restapi.model.CreateAccountRequest;
import convex.restapi.model.CreateAccountResponse;
import convex.restapi.model.FaucetRequest;
import convex.restapi.model.QueryAccountResponse;
import convex.restapi.model.QueryRequest;
import convex.restapi.model.ResultResponse;
import convex.restapi.model.TransactRequest;
import convex.restapi.model.TransactionPrepareRequest;
import convex.restapi.model.TransactionPrepareResponse;
import convex.restapi.model.TransactionSubmitRequest;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.ForbiddenResponse;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.http.NotFoundResponse;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiExampleProperty;
import io.javalin.openapi.OpenApiParam;
import io.javalin.openapi.OpenApiRequestBody;
import io.javalin.openapi.OpenApiResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;

public class ChainAPI
extends ABaseAPI {
    public Convex convex;
    private static final String ROUTE = "/api/v1/";
    public static final Keyword K_FAUCET = Keyword.intern((String)"faucet");

    public ChainAPI(RESTServer restServer) {
        super(restServer);
    }

    @Override
    public void addRoutes(Javalin app) {
        String prefix = ROUTE;
        app.post(prefix + "createAccount", this::createAccount);
        app.post(prefix + "query", this::query);
        app.post(prefix + "faucet", this::faucetRequest);
        app.post(prefix + "transaction/prepare", this::transactionPrepare);
        app.post(prefix + "transaction/submit", this::transactionSubmit);
        app.post(prefix + "transact", this::transact);
        app.get(prefix + "accounts/{addr}", this::queryAccount);
        app.get(prefix + "peers/{addr}", this::queryPeer);
        app.get(prefix + "data/<hash>", this::getData);
        app.post(prefix + "data/encode", this::encodeData);
        app.post(prefix + "data/decode", this::decodeData);
        app.get(prefix + "tx", this::getTransaction);
        app.get(prefix + "blocks", this::getBlocks);
        app.get(prefix + "blocks/{blockNum}", this::getBlock);
        app.get(prefix + "status", this::getStatus);
        app.get("/identicon/{hex}", this::getIdenticon);
        this.convex = this.restServer.getConvex();
    }

    @OpenApi(path="/api/v1/data/{hash}", versions={"peer-v1"}, methods={HttpMethod.GET}, tags={"Data Lattice"}, summary="Get data from the server with the specified hash", operationId="data", pathParams={@OpenApiParam(name="hash", description="Data hash as a hex string. Leading '0x' is optional but discouraged.", required=true, type=String.class, example="0x1234567812345678123456781234567812345678123456781234567812345678")})
    public void getData(Context ctx) {
        ACell d;
        String hashParam = ctx.pathParam("hash");
        Hash h = Hash.parse((String)hashParam);
        if (h == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Invalid hash: " + hashParam));
        }
        try {
            d = (ACell)this.convex.acquire(h).get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Missing Data: " + e.getMessage()));
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Error: " + e.getMessage()));
        }
        this.setContent(ctx, d);
    }

    @OpenApi(path="/api/v1/data/encode", versions={"peer-v1"}, methods={HttpMethod.POST}, tags={"Data Lattice"}, summary="Encode data in CAD3 multi-cell format", operationId="encode", requestBody=@OpenApiRequestBody(description="Encode request", content={@OpenApiContent(from=QueryRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="data", value="12")}), @OpenApiContent(mimeType="application/cvx", from=String.class, example="[1 2 3]")}))
    public void encodeData(Context ctx) {
        ACell value;
        String type = ctx.req().getContentType();
        if ("application/json".equals(type)) {
            AMap<AString, ACell> body = this.readJSONBody(ctx);
            AString field = RT.ensureString((ACell)RT.getIn(body, (ACell[])new ACell[]{Strings.DATA}));
            if (field == null) {
                throw new BadRequestResponse("Encode requires 'data' field");
            }
            value = Reader.read((String)field.toString());
        } else if ("application/cvx".equals(type) || "text/plain".equals(type)) {
            try {
                value = Reader.read((InputStream)ctx.bodyInputStream());
            }
            catch (Exception e) {
                throw new BadRequestResponse("Could not parse CVX content: " + e.getMessage());
            }
        } else {
            throw new BadRequestResponse("Expected JSON request or plain CVX data to encode");
        }
        Blob b = Format.encodeMultiCell((ACell)value, (boolean)true);
        ctx.status(200);
        String rtype = this.calcResponseContentType(ctx);
        if ("application/cvx-raw".equals(rtype) || "application/octet-stream".equals(type)) {
            ctx.result(b.getInputStream());
        } else {
            AHashMap result = Maps.of((Object[])new Object[]{Strings.create((String)"cad3"), Strings.create((Object)b.toCVMHexString()), Strings.create((String)"hash"), Strings.create((Object)Ref.get((ACell)value).getEncoding().toCVMHexString())});
            this.setContent(ctx, (ACell)result);
        }
    }

    @OpenApi(path="/api/v1/data/decode", versions={"peer-v1"}, methods={HttpMethod.POST}, tags={"Data Lattice"}, summary="Decode CAD3 data", operationId="decode", requestBody=@OpenApiRequestBody(description="Decode request", content={@OpenApiContent(from=QueryRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="cad3", value="0x110c")})}))
    public void decodeData(Context ctx) {
        ACell r;
        ABlob value;
        String type = ctx.req().getContentType();
        if ("application/json".equals(type)) {
            AMap<AString, ACell> body = this.readJSONBody(ctx);
            AString field = RT.ensureString((ACell)RT.getIn(body, (ACell[])new ACell[]{Strings.create((String)"cad3")}));
            if (field == null) {
                throw new BadRequestResponse("Decode requires 'cad3' field");
            }
            value = Blob.parse((Object)field);
        } else if ("application/cvx".equals(type) || "application/octet-stream".equals(type)) {
            try {
                value = Blobs.fromStream((InputStream)ctx.bodyInputStream());
            }
            catch (Exception e) {
                throw new BadRequestResponse("Could not read CAD3 content: " + e.getMessage());
            }
        } else {
            throw new BadRequestResponse("Expected CAD3 data to decode");
        }
        try {
            r = Format.decodeMultiCell((Blob)value.toFlatBlob());
        }
        catch (BadFormatException e) {
            this.failBadRequest("Error decoding CAD3 data - bad format");
            return;
        }
        ctx.status(200);
        String rtype = this.calcResponseContentType(ctx);
        if ("application/cvx-raw".equals(rtype)) {
            ctx.result(RT.print((ACell)r).getInputStream());
        } else if ("application/json".equals(rtype)) {
            this.setContent(ctx, (ACell)Maps.of((Object[])new Object[]{"cvx", RT.print((ACell)r)}));
        }
    }

    @OpenApi(path="/api/v1/tx", versions={"peer-v1"}, methods={HttpMethod.GET}, tags={"Transactions"}, summary="Get transaction by hash", operationId="getTransaction", queryParams={@OpenApiParam(name="hash", description="Transaction hash as a hex string. Leading '0x' is optional.", required=true, type=String.class, example="0x1234567812345678123456781234567812345678123456781234567812345678")}, responses={@OpenApiResponse(status="200", description="Transaction found", content={@OpenApiContent(type="application/json")}), @OpenApiResponse(status="400", description="Bad request, invalid hash format"), @OpenApiResponse(status="404", description="Transaction not found")})
    public void getTransaction(Context ctx) {
        String hashParam = ctx.queryParam("hash");
        if (hashParam == null) {
            throw new BadRequestResponse("Missing required query parameter: hash");
        }
        Hash h = Hash.parse((String)hashParam);
        if (h == null) {
            throw new BadRequestResponse("Invalid hash: " + hashParam);
        }
        Peer peer = this.server.getPeer();
        SignedData transaction = peer.getTransaction(h);
        if (transaction == null) {
            throw new NotFoundResponse("Transaction not found: " + hashParam);
        }
        AVector pos = peer.getTransactionLocation(h);
        Result txResult = peer.getTransactionResult(pos);
        AHashMap result = Maps.of((Object[])new Object[]{Keywords.TX, transaction, Keywords.POSITION, pos, Keywords.RESULT, txResult});
        this.setContent(ctx, (ACell)result);
    }

    @OpenApi(path="/api/v1/blocks", versions={"peer-v1"}, methods={HttpMethod.GET}, tags={"Blocks"}, summary="Get blocks with pagination", operationId="getBlocks", queryParams={@OpenApiParam(name="offset", description="Starting index for blocks (0-based)", required=false, type=Long.class, example="0"), @OpenApiParam(name="limit", description="Maximum number of blocks to return", required=false, type=Long.class, example="100")}, responses={@OpenApiResponse(status="200", description="Blocks retrieved successfully", content={@OpenApiContent(type="application/json")}), @OpenApiResponse(status="400", description="Bad request, invalid offset or limit parameters")})
    public void getBlocks(Context ctx) {
        String offsetParam = ctx.queryParam("offset");
        String limitParam = ctx.queryParam("limit");
        long offset = 0L;
        long limit = 100L;
        try {
            if (offsetParam != null && (offset = Long.parseLong(offsetParam)) < 0L) {
                throw new BadRequestResponse("Offset must be non-negative");
            }
            if (limitParam != null && ((limit = Long.parseLong(limitParam)) <= 0L || limit > 1000L)) {
                throw new BadRequestResponse("Limit must be between 1 and 1000");
            }
        }
        catch (NumberFormatException e) {
            throw new BadRequestResponse("Invalid offset or limit parameter: must be a number");
        }
        Order peerOrder = this.server.getPeer().getPeerOrder();
        AVector blocks = peerOrder.getBlocks();
        long totalBlocks = blocks.count();
        long finalityPoint = this.server.getPeer().getFinalityPoint();
        long start = Math.min(offset, totalBlocks);
        long end = Math.min(start + limit, totalBlocks);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        response.put("count", Long.valueOf(totalBlocks));
        response.put("offset", Long.valueOf(offset));
        ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>();
        for (long i = start; i < end; ++i) {
            SignedData signedBlock = (SignedData)blocks.get(i);
            HashMap<String, Object> blockData = this.getBlockData((SignedData<Block>)signedBlock);
            blockData.put("index", i);
            blockData.put("finalised", i < finalityPoint);
            items.add(blockData);
        }
        response.put("items", items);
        ctx.result(JSON.toStringPretty(response));
    }

    private HashMap<String, Object> getBlockData(SignedData<Block> signedBlock) {
        Block block = (Block)signedBlock.getValue();
        HashMap<String, Object> blockData = new HashMap<String, Object>();
        blockData.put("timestamp", block.getTimeStamp());
        blockData.put("peer", signedBlock.getAccountKey().toString());
        blockData.put("hash", signedBlock.getHash().toString());
        blockData.put("transactionCount", block.getTransactions().count());
        return blockData;
    }

    @OpenApi(path="/api/v1/blocks/{blockNum}", versions={"peer-v1"}, methods={HttpMethod.GET}, tags={"Blocks"}, summary="Get a specific block by block number", operationId="getBlock", pathParams={@OpenApiParam(name="blockNum", description="Block number (0-based index)", required=true, type=Long.class, example="0")}, responses={@OpenApiResponse(status="200", description="Block found", content={@OpenApiContent(type="application/json")}), @OpenApiResponse(status="400", description="Bad request, invalid block number format"), @OpenApiResponse(status="404", description="Block not found")})
    public void getBlock(Context ctx) {
        long blockNum;
        String blockNumParam = ctx.pathParam("blockNum");
        try {
            blockNum = Long.parseLong(blockNumParam);
            if (blockNum < 0L) {
                throw new BadRequestResponse("Block number must be non-negative");
            }
        }
        catch (NumberFormatException e) {
            throw new BadRequestResponse("Invalid block number format: must be a number");
        }
        Peer peer = this.server.getPeer();
        Order peerOrder = peer.getPeerOrder();
        AVector blocks = peerOrder.getBlocks();
        long totalBlocks = blocks.count();
        if (blockNum >= totalBlocks) {
            throw new NotFoundResponse("Block not found: " + blockNum);
        }
        long finalityPoint = peer.getFinalityPoint();
        SignedData signedBlock = (SignedData)blocks.get(blockNum);
        HashMap<String, Object> blockData = this.getBlockData((SignedData<Block>)signedBlock);
        blockData.put("index", blockNum);
        blockData.put("finalised", blockNum < finalityPoint);
        ctx.result(JSON.toStringPretty(blockData));
    }

    @OpenApi(path="/api/v1/status", versions={"peer-v1"}, methods={HttpMethod.GET}, tags={"Peer"}, summary="Get the status map from the peer server. Can be used as a heartbeat check to ensure the peer is still running.", operationId="getStatus", responses={@OpenApiResponse(status="200", description="Status retrieved successfully", content={@OpenApiContent(type="application/json")})})
    public void getStatus(Context ctx) {
        AMap statusMap = this.server.getStatusMap();
        this.setContent(ctx, (ACell)statusMap);
    }

    @OpenApi(path="/api/v1/createAccount", versions={"peer-v1"}, methods={HttpMethod.POST}, operationId="createAccount", tags={"Account"}, summary="Create a new Convex account. Requires a peer willing to accept faucet requests.", requestBody=@OpenApiRequestBody(description="Create Account request, must provide an accountKey for the new Account", content={@OpenApiContent(from=CreateAccountRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="accountKey", value="d82e78594610f708ad47f666bbacbab1711760652cb88bf7515ed6c3ae84a08d")})}), responses={@OpenApiResponse(status="200", description="Account creation executed", content={@OpenApiContent(type="application/json", from=CreateAccountResponse.class)}), @OpenApiResponse(status="400", description="Bad request, probably a missing or invalid accountKey")})
    public void createAccount(Context ctx) throws InterruptedException {
        Address a;
        Convex faucetClient = this.restServer.getFaucet();
        if (faucetClient == null) {
            throw new ForbiddenResponse("Faucet use not authorised on this server");
        }
        AMap<AString, ACell> req = this.readJSONBody(ctx);
        AString key = (AString)req.getIn((Object)"accountKey");
        if (key == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Expected JSON body containing 'accountKey' field"));
        }
        AccountKey pk = AccountKey.parse((Object)key);
        if (pk == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Unable to parse accountKey: " + String.valueOf(key)));
        }
        ACell faucet = req.getIn((Object)"faucet");
        AInteger amt = AInteger.parse((Object)faucet);
        try {
            a = faucetClient.createAccountSync(pk);
            if (amt != null) {
                faucetClient.transferSync(a, amt.longValue());
            }
        }
        catch (ResultException e) {
            this.setContent(ctx, (ACell)e.getResult());
            return;
        }
        ctx.result("{\"address\": " + a.longValue() + "}");
    }

    @OpenApi(path="/api/v1/accounts/{address}", versions={"peer-v1"}, methods={HttpMethod.GET}, operationId="queryAccount", tags={"Account"}, summary="Get Convex account information", pathParams={@OpenApiParam(name="address", description="Address of Account", required=true, type=String.class, example="14")}, responses={@OpenApiResponse(status="200", description="Account queried sucecssfully", content={@OpenApiContent(from=QueryAccountResponse.class, type="application/json")}), @OpenApiResponse(status="400", description="Bad request, probably an invalid address parameter"), @OpenApiResponse(status="404", description="Account does not exist")})
    public void queryAccount(Context ctx) throws InterruptedException {
        Address addr = null;
        String addrParam = ctx.pathParam("addr");
        addr = Address.parse((String)addrParam);
        if (addr == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Invalid address: " + addrParam));
        }
        Result r = this.convex.querySync((ACell)Lists.of((Object[])new Object[]{Symbols.ACCOUNT, addr}));
        if (r.isError()) {
            this.setContent(ctx, (ACell)r);
            return;
        }
        AccountStatus as = (AccountStatus)r.getValue();
        if (as == null) {
            ctx.result("{\"errorCode\": \"NOBODY\",\"value\": \"The Account requested does not exist.\"}");
            ctx.contentType("application/json");
            ctx.status(404);
            return;
        }
        boolean isUser = !as.isActor();
        AccountKey publicKey = as.getAccountKey();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("address", addr.longValue());
        hm.put("key", publicKey == null ? null : publicKey.toString());
        hm.put("allowance", as.getMemory());
        hm.put("balance", as.getBalance());
        hm.put("memorySize", as.getMemorySize());
        hm.put("sequence", as.getSequence());
        hm.put("type", isUser ? "user" : "actor");
        ctx.result(JSON.toString(hm));
    }

    public void queryPeer(Context ctx) throws InterruptedException {
        AccountKey addr = null;
        String addrParam = ctx.pathParam("addr");
        addr = AccountKey.parse((String)addrParam);
        if (addr == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Invalid peer key: " + addrParam));
        }
        Result r = this.convex.querySync(Reader.read((String)("(get-in *state* [:peers " + String.valueOf(addr) + "])")));
        if (r.isError()) {
            this.setContent(ctx, (ACell)r);
            return;
        }
        PeerStatus as = (PeerStatus)r.getValue();
        if (as == null) {
            throw new NotFoundResponse("Peer does not exist: " + addrParam);
        }
        ctx.result(JSON.toString((Object)as));
    }

    @OpenApi(path="/api/v1/faucet", versions={"peer-v1"}, methods={HttpMethod.POST}, operationId="faucetRequest", tags={"Account"}, summary="Request coins from a Faucet provider. Requires a peer winning to accept faucet requests.", requestBody=@OpenApiRequestBody(description="Faucet request, must provide an address for coins to be deposited in", content={@OpenApiContent(from=FaucetRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="address", value="11"), @OpenApiExampleProperty(name="amount", value="10000000")})}), responses={@OpenApiResponse(status="200", description="Faucet request executed", content={@OpenApiContent(type="application/json", from=CreateAccountResponse.class)}), @OpenApiResponse(status="400", description="Bad request, probably e.g.  missing or invalid recipient address"), @OpenApiResponse(status="422", description="Faucet request failed", content={@OpenApiContent(type="application/json", from=ResultResponse.class)}), @OpenApiResponse(status="403", description="Faucet request forbidden, probably Server is not accepting faucet requests")})
    public void faucetRequest(Context ctx) throws InterruptedException {
        Result r;
        ACell o;
        CVMLong l;
        Convex faucetClient = this.restServer.getFaucet();
        if (faucetClient == null) {
            throw new ForbiddenResponse("Faucet use not authorised on this server");
        }
        AMap req = this.readJSONBody(ctx);
        Address addr = Address.parse((Object)req.getIn((Object)"address"));
        if (addr == null) {
            this.failBadRequest("Expected JSON body containing valid 'address' field");
        }
        if ((l = CVMLong.parse((Object)(o = req.getIn((Object)"amount")))) == null) {
            this.failBadRequest("Faucet requires an 'amount' field containing a long value.");
            return;
        }
        long amt = l.longValue();
        if (amt > 1000000000L) {
            amt = 1000000000L;
        }
        if ((r = faucetClient.transactSync("(transfer " + String.valueOf(addr) + " " + amt + ")")).isError()) {
            this.setContent(ctx, (ACell)r);
            ctx.status(422);
        } else {
            req = req.assoc((ACell)Strings.ADDRESS, (ACell)RT.castLong((ACell)addr));
            req = req.assoc((ACell)Strings.AMOUNT, r.getValue());
            this.setContent(ctx, (ACell)req);
        }
    }

    protected void failBadRequest(String message) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("errorCode", "FAILED");
        hm.put("value", "message");
        this.failBadRequest(hm);
    }

    protected void failBadRequest(HashMap<String, Object> result) {
        throw new BadRequestResponse(JSON.toString(result));
    }

    @OpenApi(path="/api/v1/transaction/prepare", versions={"peer-v1"}, methods={HttpMethod.POST}, operationId="transactionPrepare", tags={"Transactions"}, summary="Prepare a Convex transaction. If sucessful, will return an encoding to be signed.", requestBody=@OpenApiRequestBody(description="Transaction preparation request", content={@OpenApiContent(from=TransactionPrepareRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="address", value="12"), @OpenApiExampleProperty(name="source", value="(* 2 3)")})}), responses={@OpenApiResponse(status="200", description="Transaction prepared", content={@OpenApiContent(from=TransactionPrepareResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="sequence", value="14"), @OpenApiExampleProperty(name="address", value="12"), @OpenApiExampleProperty(name="source", value="(* 2 3)"), @OpenApiExampleProperty(name="hash", value="d00c0e81031103110232012a"), @OpenApiExampleProperty(name="data", value="d00c0e81031103110232012a")})}), @OpenApiResponse(status="503", description="Transaction service unavailable")})
    public void transactionPrepare(Context ctx) throws InterruptedException, IOException {
        long sequence;
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse("Transaction prepare requires a valid 'address' field.");
        }
        Object srcValue = req.get("source");
        ACell code = ChainAPI.readCode(srcValue);
        Object maybeSeq = req.get("sequence");
        try {
            if (maybeSeq != null) {
                CVMLong lv = CVMLong.parse((Object)maybeSeq);
                if (lv == null) {
                    throw new BadRequestResponse("sequence (if provided) must be an integer");
                }
                sequence = lv.longValue();
            } else {
                sequence = this.convex.getSequence(addr) + 1L;
            }
        }
        catch (ResultException e) {
            this.setContent(ctx, (ACell)e.getResult());
            return;
        }
        Invoke trans = Invoke.create((Address)addr, (long)sequence, (ACell)code);
        trans = (ATransaction)Cells.persist((ACell)trans);
        Ref ref = ((ATransaction)Cells.persist((ACell)trans)).getRef();
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        rmap.put("source", srcValue);
        rmap.put("address", JSON.json((ACell)addr));
        rmap.put("hash", SignedData.getMessageForRef((Ref)ref).toHexString());
        rmap.put("data", Format.encodeMultiCell((ACell)trans, (boolean)true).toHexString());
        rmap.put("sequence", sequence);
        ctx.status(200);
        ctx.result(JSON.toString(rmap));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @OpenApi(path="/api/v1/transact", versions={"peer-v1"}, methods={HttpMethod.POST}, operationId="transact", tags={"Transactions"}, summary="Execute a Convex transaction. WARNING: sends Ed25519 seed over the network for peer to complete signature. Only do this with a secure HTTPS connection to a peer that you trust.", requestBody=@OpenApiRequestBody(description="Transaction execution request", content={@OpenApiContent(from=TransactRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="address", value="12"), @OpenApiExampleProperty(name="source", value="(* 2 3)"), @OpenApiExampleProperty(name="seed", value="0x0026a11f81cd2a7df7e00e3a55c4e9817b3bb4d3ed6252117d7d22923d4be24d")}), @OpenApiContent(type="application/cvx-raw")}), responses={@OpenApiResponse(status="200", description="Transaction executed successfully", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="value", value="6"), @OpenApiExampleProperty(name="info", objects={@OpenApiExampleProperty(name="juice", value="581"), @OpenApiExampleProperty(name="tx", value="0x9e328480aef5490ca864c1c1d8881c34b51e8499b59145d3bd6e06bcc6f1ddaf"), @OpenApiExampleProperty(name="source", value="SERVER"), @OpenApiExampleProperty(name="fees", value="13810"), @OpenApiExampleProperty(name="loc", value="[0, 0]")})})}), @OpenApiResponse(status="422", description="Transaction failed", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="errorCode", value=":NOBODY"), @OpenApiExampleProperty(name="value", value="Account does not exist")})}), @OpenApiResponse(status="503", description="Transaction service unavailable")})
    public void transact(Context ctx) throws InterruptedException, IOException {
        SignedData sd;
        String type = ctx.req().getContentType();
        if ("application/cvx-raw".equals(type)) {
            Object c = this.getRawBody(ctx);
            if (!(c instanceof SignedData) || !(((SignedData)c).getValue() instanceof ATransaction)) throw new BadRequestResponse("Expected signed transaction but got: " + String.valueOf(c));
            sd = (SignedData)c;
        } else {
            long nextSeq;
            Map<String, Object> req = this.getJSONBody(ctx);
            Address addr = Address.parse((Object)req.get("address"));
            if (addr == null) {
                throw new BadRequestResponse("Transact requires a valid address.");
            }
            Object srcValue = req.get("source");
            ACell code = ChainAPI.readCode(srcValue);
            ABlob seed = Blobs.parse((Object)req.get("seed"));
            if (!(seed instanceof ABlob)) {
                throw new BadRequestResponse("Valid Ed25519 seed required for transact (hex string)");
            }
            if (seed.count() != 32L) {
                throw new BadRequestResponse("Seed must be 32 bytes");
            }
            try {
                long sequence = this.convex.getSequence(addr);
                nextSeq = sequence + 1L;
            }
            catch (ResultException e) {
                this.setContent(ctx, (ACell)e.getResult());
                return;
            }
            Invoke trans = Invoke.create((Address)addr, (long)nextSeq, (ACell)code);
            AKeyPair kp = AKeyPair.create((Blob)seed.toFlatBlob());
            sd = kp.signData((ACell)trans);
        }
        Result r = this.convex.transactSync(sd);
        this.setContent(ctx, (ACell)r);
    }

    private static ACell readCode(Object srcValue) {
        return Reader.read((String)((String)srcValue));
    }

    @OpenApi(path="/api/v1/transaction/submit", versions={"peer-v1"}, methods={HttpMethod.POST}, operationId="transactionSubmit", tags={"Transactions"}, summary="Submit a pre-prepared Convex transaction. If successful, will return transaction result.", requestBody=@OpenApiRequestBody(description="Transaction preparation request", content={@OpenApiContent(from=TransactionSubmitRequest.class, type="application/json")}), responses={@OpenApiResponse(status="200", description="Transaction executed", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="value", value="6"), @OpenApiExampleProperty(name="info", objects={@OpenApiExampleProperty(name="juice", value="581"), @OpenApiExampleProperty(name="tx", value="0x9e328480aef5490ca864c1c1d8881c34b51e8499b59145d3bd6e06bcc6f1ddaf"), @OpenApiExampleProperty(name="source", value="SERVER"), @OpenApiExampleProperty(name="fees", value="13810"), @OpenApiExampleProperty(name="loc", value="[0, 0]")})})}), @OpenApiResponse(status="503", description="Transaction service unavailable")})
    public void transactionSubmit(Context ctx) throws InterruptedException {
        Map<String, Object> req = this.getJSONBody(ctx);
        Object hashValue = req.get("hash");
        if (!(hashValue instanceof String)) {
            throw new BadRequestResponse("Parameter 'hash' must be provided as a String");
        }
        Blob h = Blob.parse((String)((String)hashValue));
        if (h == null) {
            throw new BadRequestResponse("Parameter 'hash' did not parse correctly, must be a hex string.");
        }
        ATransaction trans = null;
        try {
            Ref ref = Format.readRef((Blob)h, (int)0);
            ACell maybeTrans = ref.getValue();
            if (!(maybeTrans instanceof ATransaction)) {
                throw new BadFormatException("Value with hash " + String.valueOf(h) + " is not a transaction: can't submit it!");
            }
            trans = (ATransaction)maybeTrans;
        }
        catch (MissingDataException e) {
            this.setContent(ctx, (ACell)Result.error((Keyword)ErrorCodes.MISSING, (String)"Missing data for transaction. Possible need to prepare first?"));
            ctx.status(404);
            return;
        }
        catch (BadFormatException e) {
            this.setContent(ctx, (ACell)Result.error((Keyword)ErrorCodes.FORMAT, (String)("Bad format: " + String.valueOf((Object)e))));
            ctx.status(400);
            return;
        }
        Object keyValue = req.get("accountKey");
        if (!(keyValue instanceof String)) {
            throw new BadRequestResponse("Expected JSON body containing 'accountKey' field");
        }
        AccountKey key = AccountKey.parse((Object)keyValue);
        if (key == null) {
            throw new BadRequestResponse("Parameter 'accountKey' did not parse correctly, must be 64 hex characters (32 bytes).");
        }
        Object sigValue = req.get("sig");
        if (!(sigValue instanceof String)) {
            throw new BadRequestResponse("Parameter 'sig' must be provided as a String");
        }
        ABlob sigData = Blobs.parse((Object)sigValue);
        if (sigData == null || sigData.count() != 64L) {
            throw new BadRequestResponse("Parameter 'sig' must be a 64 byte hex String (128 hex chars)");
        }
        ASignature sig = Ed25519Signature.fromBlob((ABlob)sigData);
        SignedData sd = SignedData.create((AccountKey)key, (ASignature)sig, (Ref)trans.getRef());
        Result r = this.convex.transactSync(sd);
        this.setContent(ctx, (ACell)r);
    }

    @OpenApi(path="/api/v1/query", versions={"peer-v1"}, methods={HttpMethod.POST}, operationId="query", tags={"Transactions"}, summary="Query as Convex account", requestBody=@OpenApiRequestBody(description="Query request", content={@OpenApiContent(from=QueryRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="address", value="12"), @OpenApiExampleProperty(name="source", value="(* 2 3)")}), @OpenApiContent(mimeType="application/cvx", from=String.class, example="{\n  :address #12 \n  :source (* 2 3)\n}")}), responses={@OpenApiResponse(status="200", description="Query executed. Result could be a CVM error, but query itself was valid", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="result", value="6")})}), @OpenApiResponse(status="422", description="Query failed due to bad input", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="error", value="SYNTAX"), @OpenApiExampleProperty(name="result", value="Bad syntax")})}), @OpenApiResponse(status="503", description="Query service unavailable")})
    public void query(Context ctx) throws InterruptedException {
        try {
            ACell form;
            Address addr;
            String type = ctx.req().getContentType();
            if ("application/cvx".equals(type)) {
                Object rbody = this.getCVXBody(ctx);
                if (!(rbody instanceof AMap)) {
                    throw new BadRequestResponse("query body is not a map.");
                }
                AMap req = (AMap)rbody;
                addr = Address.parse((Object)RT.get((ADataStructure)req, (ACell)Keywords.ADDRESS));
                form = RT.get((ADataStructure)req, (ACell)Keywords.SOURCE);
            } else {
                Map<String, Object> req = this.getJSONBody(ctx);
                addr = Address.parse((Object)req.get("address"));
                Object srcValue = req.get("source");
                form = ChainAPI.readCode(srcValue);
            }
            Result r = this.convex.querySync(form, addr);
            this.setContent(ctx, (ACell)r);
        }
        catch (ParseException e) {
            throw new BadRequestResponse(e.getMessage());
        }
    }

    @OpenApi(path="/identicon/{hex}", versions={"peer-v1"}, methods={HttpMethod.GET}, tags={"Utility"}, summary="Get the identicon for a hash / public key", operationId="getIdenticon", pathParams={@OpenApiParam(name="hex", description="Hex string. Leading '0x' is optional but discouraged.", required=true, type=String.class, example="0x1234567812345678123456781234567812345678123456781234567812345678")}, responses={@OpenApiResponse(status="200", description="Transaction found", content={@OpenApiContent(type="image/png")}), @OpenApiResponse(status="400", description="Bad request, invalid hash format")})
    public void getIdenticon(Context ctx) {
        String hexParam = ctx.pathParam("hex");
        Blob data = Blob.parse((String)hexParam);
        if (data == null) {
            throw new BadRequestResponse("Invalid hex string for identicon: " + hexParam);
        }
        try {
            int[] identiconData = IdenticonBuilder.build((AArrayBlob)data);
            BufferedImage image = new BufferedImage(7, 7, 1);
            image.setRGB(0, 0, 7, 7, identiconData, 0, 7);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", baos);
            byte[] pngBytes = baos.toByteArray();
            ctx.header("Content-Type", "image/png");
            ctx.header("Cache-Control", "public, max-age=31536000");
            ctx.header("ETag", "\"" + data.toHexString() + "\"");
            ctx.result(pngBytes);
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse("Failed to generate identicon: " + e.getMessage());
        }
    }
}

