/*
 * Decompiled with CFR 0.152.
 */
package convex.java.asset;

import convex.core.cvm.Address;
import convex.java.ConvexJSON;
import convex.java.asset.BaseAsset;
import java.util.Map;

public class Fungible
extends BaseAsset<Long> {
    private final Address tokenAddress;

    protected Fungible(ConvexJSON convex, Address address) {
        super(convex);
        this.tokenAddress = address;
    }

    public static Fungible create(ConvexJSON convex, Address tokenAddress) {
        return new Fungible(convex, tokenAddress);
    }

    @Override
    public Long getBalance() {
        return this.getBalance(this.convex.getAddress());
    }

    @Override
    public Long getBalance(Address holder) {
        String code = "(do (import convex.fungible :as fungible) (fungible/balance " + this.tokenAddress.toString() + " " + holder.toString() + "))";
        Map<String, Object> result = this.convex.query(code);
        if (result.containsKey("errorCode")) {
            throw new Error("Token balance query failed" + String.valueOf(result));
        }
        Object value = result.get("value");
        if (value instanceof Long) {
            Long aNum = (Long)value;
            return aNum;
        }
        throw new Error("Unexpected return value: " + String.valueOf(value));
    }

    public String toString() {
        return "Fungible token with address: " + this.tokenAddress.toString();
    }
}

