/*
 * Decompiled with CFR 0.152.
 */
package convex.java;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Keyword;
import convex.core.util.JSON;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class ARESTClient {
    private final URI host;
    private final URI baseURI;
    private final HttpClient httpClient;

    public ARESTClient(URI host, String basePath) {
        this.host = host;
        this.baseURI = host.resolve(basePath);
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).build();
    }

    public URI getHost() {
        return this.host;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    protected CompletableFuture<Result> doRequest(HttpRequest request) {
        try {
            CompletableFuture<HttpResponse<String>> future = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            return future.thenApply(response -> {
                String rbody = null;
                try {
                    rbody = (String)response.body();
                    return Result.create(null, (ACell)JSON.parseJSON5((String)rbody));
                }
                catch (Exception e) {
                    if (rbody == null) {
                        rbody = "<Body not readable as String>";
                    }
                    Result res = Result.error((Keyword)ErrorCodes.FORMAT, (String)("Can't parse JSON body: " + rbody));
                    return res;
                }
            });
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(Result.fromException((Throwable)e));
        }
    }
}

