/*
 * Decompiled with CFR 0.152.
 */
package convex.java;

import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Maps;
import convex.core.data.SignedData;
import convex.core.exceptions.MissingDataException;
import convex.core.exceptions.ParseException;
import convex.core.exceptions.TODOException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.message.Message;
import convex.core.store.AStore;
import convex.core.util.Utils;
import convex.java.HTTPClients;
import convex.java.JSON;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.core5.http.ContentType;

public class ConvexHTTP
extends Convex {
    private final URI uri;

    protected ConvexHTTP(Address address, AKeyPair keyPair, URI uri) {
        super(address, keyPair);
        this.uri = uri;
    }

    public static ConvexHTTP connect(URI uri, Address address, AKeyPair keyPair) {
        return new ConvexHTTP(address, keyPair, uri);
    }

    private String getAPIPath() {
        int port = this.uri.getPort();
        Object ps = port == -1 ? "" : ":" + port;
        return this.uri.getScheme() + "://" + this.uri.getHost() + (String)ps + "/api/v1";
    }

    public boolean isConnected() {
        return true;
    }

    public CompletableFuture<Result> transact(SignedData<ATransaction> signedTransaction) {
        String transactPath = this.getAPIPath() + "/transact";
        SimpleHttpRequest request = SimpleRequestBuilder.post((String)transactPath).addHeader("Accept", "application/cvx-raw").setBody(Format.encodeMultiCell(signedTransaction, (boolean)true).getBytes(), ContentType.create((String)"application/cvx-raw")).build();
        CompletableFuture<SimpleHttpResponse> future = HTTPClients.execute(request);
        CompletionStage result = future.thenApply(response -> this.extractResult((SimpleHttpResponse)response));
        return result;
    }

    private Result extractResult(SimpleHttpResponse response) {
        String type = response.getContentType().getMimeType();
        try {
            if ("application/cvx".equals(type)) {
                String body = response.getBodyText();
                ACell data = Reader.read((String)body);
                return Result.fromData((ACell)data);
            }
            if ("application/cvx-raw".equals(type)) {
                byte[] body = response.getBodyBytes();
                try {
                    ACell v = Format.decodeMultiCell((Blob)Blob.wrap((byte[])body));
                    if (v instanceof Result) {
                        return (Result)v;
                    }
                    return Result.error((Keyword)ErrorCodes.FORMAT, (String)("cvx-raw data not a result but was : " + Utils.getClassName((Object)v)));
                }
                catch (MissingDataException e) {
                    return Result.error((Keyword)ErrorCodes.MISSING, (String)("Missing data in Result : " + String.valueOf(e.getMissingHash()) + " with encoding " + String.valueOf(Blob.wrap((byte[])body))));
                }
            }
            Object m = JSON.parse(response.getBodyText());
            return Result.fromJSON(m);
        }
        catch (ParseException e) {
            return Result.error((Keyword)ErrorCodes.FORMAT, (String)("Can't read response of type " + type + " : " + e.getMessage()));
        }
        catch (Exception e) {
            return Result.fromException((Throwable)e);
        }
    }

    public <T extends ACell> CompletableFuture<T> acquire(Hash hash, AStore store) {
        return null;
    }

    public CompletableFuture<Result> requestStatus() {
        return null;
    }

    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Result> query(ACell form, Address address) {
        String queryPath = this.getAPIPath() + "/query";
        AHashMap query = Maps.of((Object[])new Object[]{Keywords.SOURCE, form, Keywords.ADDRESS, address});
        SimpleHttpRequest request = SimpleRequestBuilder.post((String)queryPath).addHeader("Accept", "application/cvx").setBody(RT.toString((ACell)query), ContentType.create((String)"application/cvx")).build();
        CompletableFuture<SimpleHttpResponse> future = HTTPClients.execute(request);
        CompletionStage result = future.handle((response, ex) -> {
            if (ex != null) {
                return Result.fromException((Throwable)ex).withSource(SourceCodes.NET);
            }
            String body = response.getBodyText();
            try {
                ACell data = Reader.read((String)body);
                return Result.fromData((ACell)data);
            }
            catch (ParseException e) {
                return Result.error((Keyword)ErrorCodes.FORMAT, (String)("Can't read CVX response: " + body));
            }
            catch (Exception e) {
                return Result.fromException((Throwable)e).withSource(SourceCodes.NET);
            }
        });
        return result;
    }

    public CompletableFuture<Result> messageRaw(Blob message) {
        throw new TODOException();
    }

    public CompletableFuture<Result> message(Message message) {
        throw new TODOException();
    }

    public void close() {
    }

    public String toString() {
        return "Convex HTTP connection to peer " + String.valueOf(this.uri);
    }

    public InetSocketAddress getHostAddress() {
        Integer port = this.uri.getPort();
        if (port == -1) {
            port = "https".equals(this.uri.getScheme()) ? Integer.valueOf(443) : Integer.valueOf(8080);
        }
        return new InetSocketAddress(this.uri.getHost(), (int)port);
    }

    public void reconnect() throws IOException, TimeoutException, InterruptedException {
    }
}

