/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.cli.ACommand;
import convex.cli.Main;
import convex.cli.mixins.EtchMixin;
import convex.cli.mixins.KeyMixin;
import convex.cli.mixins.KeyStoreMixin;
import convex.cli.mixins.PeerKeyMixin;
import convex.core.crypto.AKeyPair;
import convex.etch.EtchStore;
import picocli.CommandLine;

public abstract class APeerCommand
extends ACommand {
    @CommandLine.Mixin
    protected EtchMixin etchMixin;
    @CommandLine.Mixin
    protected KeyMixin keyMixin;
    @CommandLine.Mixin
    protected PeerKeyMixin peerKeyMixin;
    @CommandLine.Mixin
    protected KeyStoreMixin storeMixin;
    @CommandLine.ParentCommand
    private ACommand parent;

    @Override
    public Main cli() {
        return this.parent.cli();
    }

    public EtchStore getEtchStore() {
        return this.etchMixin.getEtchStore();
    }

    protected AKeyPair specifiedPeerKey() {
        String peerPublicKey = this.peerKeyMixin.getPublicKey();
        if (peerPublicKey == null) {
            this.paranoia("You must specify a --peer-key for the peer");
            return null;
        }
        AKeyPair result = this.storeMixin.loadKeyFromStore(peerPublicKey, () -> this.peerKeyMixin.getKeyPassword());
        return result;
    }

    protected AKeyPair ensureControllerKey() {
        String controllerKey = this.keyMixin.getPublicKey();
        if (controllerKey == null) {
            this.paranoia("You must specify a --key for the peer controller");
            return null;
        }
        AKeyPair result = this.storeMixin.loadKeyFromStore(controllerKey, () -> this.keyMixin.getKeyPassword());
        return result;
    }
}

