/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.util.ArrayList;
import java.util.List;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestWatcher
implements TestRule {
    @Override
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors2 = new ArrayList<Throwable>();
                TestWatcher.this.startingQuietly(description, errors2);
                try {
                    base.evaluate();
                    TestWatcher.this.succeededQuietly(description, errors2);
                }
                catch (org.junit.internal.AssumptionViolatedException e) {
                    errors2.add(e);
                    TestWatcher.this.skippedQuietly(e, description, errors2);
                }
                catch (Throwable e) {
                    errors2.add(e);
                    TestWatcher.this.failedQuietly(e, description, errors2);
                }
                finally {
                    TestWatcher.this.finishedQuietly(description, errors2);
                }
                MultipleFailureException.assertEmpty(errors2);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors2) {
        try {
            this.succeeded(description);
        }
        catch (Throwable e) {
            errors2.add(e);
        }
    }

    private void failedQuietly(Throwable e, Description description, List<Throwable> errors2) {
        try {
            this.failed(e, description);
        }
        catch (Throwable e1) {
            errors2.add(e1);
        }
    }

    private void skippedQuietly(org.junit.internal.AssumptionViolatedException e, Description description, List<Throwable> errors2) {
        try {
            if (e instanceof AssumptionViolatedException) {
                this.skipped((AssumptionViolatedException)e, description);
            } else {
                this.skipped(e, description);
            }
        }
        catch (Throwable e1) {
            errors2.add(e1);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors2) {
        try {
            this.starting(description);
        }
        catch (Throwable e) {
            errors2.add(e);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors2) {
        try {
            this.finished(description);
        }
        catch (Throwable e) {
            errors2.add(e);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
        AssumptionViolatedException asInternalException = e;
        this.skipped((org.junit.internal.AssumptionViolatedException)asInternalException, description);
    }

    @Deprecated
    protected void skipped(org.junit.internal.AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
    }

    protected void finished(Description description) {
    }
}

