/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.api.ConvexRemote;
import convex.cli.Helpers;
import convex.cli.peer.Session;
import convex.core.Belief;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.SignedData;
import convex.core.init.Init;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.util.Shutdown;
import convex.core.util.Utils;
import convex.peer.API;
import convex.peer.IServerEvent;
import convex.peer.Server;
import convex.peer.ServerEvent;
import convex.peer.ServerInformation;
import convex.restapi.RESTServer;
import etch.EtchStore;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerManager
implements IServerEvent {
    private static final Logger log = LoggerFactory.getLogger(PeerManager.class.getName());
    private static final long TRANSACTION_TIMEOUT_MILLIS = 50000L;
    private static final int FRIENDLY_HEX_STRING_SIZE = 6;
    protected List<Server> peerServerList = new ArrayList<Server>();
    protected Session session = new Session();
    protected String sessionFilename;
    protected AKeyPair keyPair;
    protected Address address;
    protected AStore store;
    protected BlockingQueue<ServerEvent> serverEventQueue = new ArrayBlockingQueue<ServerEvent>(1024);

    private PeerManager(String sessionFilename, AKeyPair keyPair, Address address, AStore store) {
        this.sessionFilename = sessionFilename;
        this.keyPair = keyPair;
        this.address = address;
        this.store = store;
    }

    public static PeerManager create(String sessionFilename) {
        return new PeerManager(sessionFilename, null, null, null);
    }

    public static PeerManager create(String sessionFilename, AKeyPair keyPair, Address address, AStore store) {
        return new PeerManager(sessionFilename, keyPair, address, store);
    }

    public void launchLocalPeers(List<AKeyPair> keyPairList, int[] peerPorts) {
        List<AccountKey> keyList = keyPairList.stream().map(kp -> kp.getAccountKey()).collect(Collectors.toList());
        this.keyPair = keyPairList.get(0);
        State genesisState = Init.createState(keyList);
        this.peerServerList = API.launchLocalPeers(keyPairList, genesisState, peerPorts, this);
    }

    public List<Hash> getNetworkHashList(String remotePeerHostname) {
        InetSocketAddress remotePeerAddress = Utils.toInetSocketAddress(remotePeerHostname);
        int retryCount = 5;
        Convex convex = null;
        Result result = null;
        while (retryCount > 0) {
            try {
                convex = Convex.connect(remotePeerAddress, this.address, this.keyPair);
                CompletableFuture<Result> cf = convex.requestStatus();
                result = (Result)cf.get(50000L, TimeUnit.MILLISECONDS);
                retryCount = 0;
            }
            catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
                --retryCount;
            }
        }
        if (convex == null || result == null) {
            throw new Error("Failed to join network: Cannot connect to remote peer at " + remotePeerHostname);
        }
        convex.close();
        ArrayList<Hash> hashList = new ArrayList<Hash>(5);
        AVector values2 = (AVector)result.getValue();
        hashList.add(RT.ensureHash((ACell)values2.get(0)));
        hashList.add(RT.ensureHash((ACell)values2.get(1)));
        hashList.add(RT.ensureHash((ACell)values2.get(2)));
        hashList.add(RT.ensureHash((ACell)values2.get(4)));
        return hashList;
    }

    public State aquireState(String remotePeerHostname, Hash stateHash) {
        InetSocketAddress remotePeerAddress = Utils.toInetSocketAddress(remotePeerHostname);
        ConvexRemote convex = null;
        State state = null;
        try {
            convex = Convex.connect(remotePeerAddress, this.address, this.keyPair);
            CompletableFuture bf = ((Convex)convex).acquire(stateHash, this.store);
            state = (State)bf.get(50000L, TimeUnit.MILLISECONDS);
            ((Convex)convex).close();
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new Error("cannot aquire network state: " + e);
        }
        return state;
    }

    public SignedData<Belief> aquireBelief(String remotePeerHostname, Hash beliefHash) {
        ConvexRemote convex = null;
        SignedData signedBelief = null;
        InetSocketAddress remotePeerAddress = Utils.toInetSocketAddress(remotePeerHostname);
        try {
            convex = Convex.connect(remotePeerAddress, this.address, this.keyPair);
            CompletableFuture cf = ((Convex)convex).acquire(beliefHash, this.store);
            signedBelief = (SignedData)cf.get(50000L, TimeUnit.MILLISECONDS);
            ((Convex)convex).close();
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new Error("cannot acquire belief: " + e);
        }
        return signedBelief;
    }

    public void launchPeer(int port, String remotePeerHostname, String url2, String bindAddress) {
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        if (port > 0) {
            config.put(Keywords.PORT, port);
        }
        config.put(Keywords.STORE, this.store);
        config.put(Keywords.SOURCE, remotePeerHostname);
        config.put(Keywords.KEYPAIR, this.keyPair);
        config.put(Keywords.URL, url2);
        config.put(Keywords.BIND_ADDRESS, bindAddress);
        config.put(Keywords.EVENT_HOOK, this);
        Server server = API.launchPeer(config);
        if (!config.containsKey(Keywords.URL)) {
            server.setHostname("localhost:" + server.getPort());
        }
        this.peerServerList.add(server);
    }

    protected void loadSession() {
        File sessionFile = new File(this.sessionFilename);
        try {
            this.session.load(sessionFile);
        }
        catch (IOException e) {
            log.error("Cannot load the session control file");
        }
    }

    protected void addToSession(Server peerServer) {
        EtchStore store = (EtchStore)peerServer.getStore();
        this.session.addPeer(peerServer.getPeerKey(), peerServer.getHostname(), store.getFileName());
    }

    protected void addAllToSession() {
        for (Server peerServer : this.peerServerList) {
            this.addToSession(peerServer);
        }
    }

    protected void removeAllFromSession() {
        for (Server peerServer : this.peerServerList) {
            this.session.removePeer(peerServer.getPeerKey());
        }
    }

    protected void storeSession() {
        File sessionFile = new File(this.sessionFilename);
        try {
            Helpers.createPath(sessionFile);
            if (this.session.getSize() > 0) {
                this.session.store(sessionFile);
            } else {
                sessionFile.delete();
            }
        }
        catch (IOException e) {
            log.error("Cannot store the session control data");
        }
    }

    public void showPeerEvents() {
        this.loadSession();
        this.addAllToSession();
        this.storeSession();
        Shutdown.addHook(120, new Runnable(){

            @Override
            public void run() {
                PeerManager.this.loadSession();
                PeerManager.this.removeAllFromSession();
                PeerManager.this.storeSession();
            }
        });
        Server firstServer = this.peerServerList.get(0);
        System.out.println("Starting network Id: " + firstServer.getPeer().getNetworkID().toString());
        try {
            while (true) {
                ServerEvent event;
                ServerInformation information;
                int index;
                if ((index = this.getServerIndex((information = (event = this.serverEventQueue.take()).getInformation()).getPeerKey())) < 0) {
                    continue;
                }
                String item = this.toServerInformationText(information);
                System.out.println(String.format("#%d: %s Msg: %s", index + 1, item, event.getReason()));
            }
        }
        catch (InterruptedException e) {
            System.out.println("Peer manager interrupted!");
            return;
        }
    }

    protected String toServerInformationText(ServerInformation serverInformation) {
        String shortName = Utils.toFriendlyHexString(serverInformation.getPeerKey().toHexString(), 6);
        String hostname = serverInformation.getHostname();
        String joined = "NJ";
        String synced = "NS";
        if (serverInformation.isJoined()) {
            joined = " J";
        }
        if (serverInformation.isSynced()) {
            synced = " S";
        }
        String stateHash = Utils.toFriendlyHexString(serverInformation.getStateHash().toHexString(), 6);
        String beliefHash = Utils.toFriendlyHexString(serverInformation.getBeliefHash().toHexString(), 6);
        int connectionCount = serverInformation.getConnectionCount();
        int trustedConnectionCount = serverInformation.getTrustedConnectionCount();
        long consensusPoint = serverInformation.getConsensusPoint();
        String item = String.format("Peer:%s URL: %s Status:%s %s Connections:%2d/%2d Consensus:%4d State:%s Belief:%s", shortName, hostname, joined, synced, connectionCount, trustedConnectionCount, consensusPoint, stateHash, beliefHash);
        return item;
    }

    protected int getServerIndex(AccountKey peerKey) {
        for (int index = 0; index < this.peerServerList.size(); ++index) {
            Server server = this.peerServerList.get(index);
            if (!server.getPeer().getPeerKey().equals(peerKey)) continue;
            return index;
        }
        return -1;
    }

    public void launchRestAPI(int port) {
        Server peerServer = this.peerServerList.get(0);
        ConvexLocal convex = Convex.connect(peerServer, peerServer.getPeerController(), this.keyPair);
        RESTServer server = RESTServer.create(convex);
        server.start(port);
    }

    @Override
    public void onServerChange(ServerEvent serverEvent) {
        this.serverEventQueue.offer(serverEvent);
    }
}

