/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.Main;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.data.ABlob;
import convex.core.data.Address;
import convex.core.lang.Reader;
import convex.core.transactions.Invoke;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="transact", mixinStandardHelpOptions=true, description={"Execute a user transaction on the network via a peer."})
public class Transaction
implements Runnable {
    @CommandLine.ParentCommand
    protected Main mainParent;
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"Hex string of the public key in the Keystore to use to run the transaction.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String keystorePublicKey;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect or create a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-a", "--address"}, description={"Account address to use for the transaction request."})
    private long addressNumber;
    @CommandLine.Option(names={"-t", "--timeout"}, description={"Timeout in miliseconds."})
    private long timeout = 5000L;
    @CommandLine.Parameters(paramLabel="transactionCommand", description={"Transaction Command"})
    private String transactionCode;

    @Override
    public void run() {
        AKeyPair keyPair = null;
        keyPair = this.mainParent.loadKeyFromStore(this.keystorePublicKey);
        if (this.addressNumber == 0L) {
            log.warn("--address. You need to provide a valid address number");
            return;
        }
        Address address = Address.create(this.addressNumber);
        try (Convex convex = null;){
            convex = this.mainParent.connectToSessionPeer(this.hostname, this.port, address, keyPair);
            if (keyPair == null) {
                Result ar = convex.query("*key*").get(1000L, TimeUnit.MILLISECONDS);
                if (ar.isError()) {
                    throw new CLIError("Unable to get *key* for Address " + address + " : " + ar);
                }
                Object v = ar.getValue();
                if (v instanceof ABlob) {
                    String pk = ((ABlob)v).toHexString();
                    keyPair = this.mainParent.loadKeyFromStore(pk);
                    if (keyPair == null) {
                        throw new CLIError("Unable to get keypair " + pk + " for Address " + address + " : " + ar);
                    }
                    convex.setKeyPair(keyPair);
                }
            }
            log.info("Executing transaction: '{}'\n", (Object)this.transactionCode);
            Object message = Reader.read(this.transactionCode);
            Invoke transaction = Invoke.create(address, -1L, message);
            Result result = convex.transactSync(transaction, this.timeout);
            this.mainParent.printResult(result);
        }
    }
}

