/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.Account;
import convex.cli.CLIError;
import convex.cli.Main;
import convex.core.crypto.AKeyPair;
import convex.core.data.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="fund", aliases={"fu"}, mixinStandardHelpOptions=true, description={"Transfers funds to account using a public/private key from the keystore.%nYou must provide a valid keystore password to the keystore and a valid address.%nIf the keystore is not at the default location also the keystore filename."})
public class AccountFund
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AccountFund.class);
    @CommandLine.ParentCommand
    private Account accountParent;
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"Hex string of the public key in the Keystore to use to create an account.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String keystorePublicKey;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect to a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-a", "--address"}, description={"Account address to use to request funds."})
    private long addressNumber;
    @CommandLine.Parameters(paramLabel="amount", defaultValue="100000000", description={"Amount to fund the account"})
    private long amount;

    @Override
    public void run() {
        Main mainParent = this.accountParent.mainParent;
        AKeyPair keyPair = null;
        keyPair = mainParent.loadKeyFromStore(this.keystorePublicKey);
        if (this.addressNumber == 0L) {
            log.warn("--address. You need to provide a valid address number");
            return;
        }
        Convex convex = null;
        Address address = Address.create(this.addressNumber);
        try {
            convex = mainParent.connectAsPeer(0);
            convex.transferSync(address, this.amount);
            convex = mainParent.connectToSessionPeer(this.hostname, this.port, address, keyPair);
            Long balance = convex.getBalance(address);
            mainParent.println(balance);
        }
        catch (Throwable t) {
            throw new CLIError("Error funding account", t);
        }
    }
}

