/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACountable;
import convex.core.data.Ref;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.prim.CVMChar;
import convex.core.data.type.AType;
import convex.core.data.type.Types;

public abstract class AString
extends ACountable<CVMChar>
implements CharSequence,
Comparable<AString> {
    protected int length;

    protected AString(int length) {
        this.length = length;
    }

    @Override
    public AType getType() {
        return Types.STRING;
    }

    @Override
    public void print(StringBuilder sb) {
        sb.append('\"');
        sb.append(this);
        sb.append('\"');
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public long count() {
        return this.length;
    }

    public StringShort empty() {
        return Strings.EMPTY;
    }

    protected abstract AString append(char var1);

    @Override
    public CVMChar get(long i) {
        return CVMChar.create(this.charAt((int)i));
    }

    @Override
    public Ref<CVMChar> getElementRef(long i) {
        return this.get(i).getRef();
    }

    @Override
    public int compareTo(AString o) {
        return CharSequence.compare(this, o);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.length);
        this.appendToStringBuffer(sb, 0, this.length());
        return sb.toString();
    }

    protected abstract void appendToStringBuffer(StringBuilder var1, int var2, int var3);

    @Override
    public abstract AString subSequence(int var1, int var2);

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 48;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public final byte getTag() {
        return 48;
    }
}

