/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.Peer;
import convex.core.State;
import convex.gui.components.BaseListComponent;
import convex.gui.components.BlockViewComponent;
import convex.gui.components.DropdownMenu;
import convex.gui.components.PeerView;
import convex.gui.components.models.StateModel;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.windows.etch.EtchWindow;
import convex.gui.manager.windows.peer.PeerWindow;
import convex.gui.manager.windows.state.StateWindow;
import convex.gui.utils.Toolkit;
import convex.peer.Server;
import etch.EtchStore;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class PeerComponent
extends BaseListComponent {
    public PeerView peer;
    JTextArea description;
    private PeerGUI manager;

    public void launchPeerWindow(PeerView peer) {
        PeerWindow pw = new PeerWindow(this.manager, peer);
        pw.launch();
    }

    public void launchEtchWindow(PeerView peer) {
        EtchWindow ew = new EtchWindow(this.manager, peer);
        ew.launch();
    }

    public void launchExploreWindow(PeerView peer) {
        Server s = peer.peerServer;
        State p = s.getPeer().getConsensusState();
        StateWindow pw = new StateWindow(this.manager, p);
        pw.launch();
    }

    public PeerComponent(PeerGUI manager, PeerView value) {
        StateModel<Peer> model;
        JMenuItem closeButton;
        this.manager = manager;
        this.peer = value;
        this.setLayout(new BorderLayout(0, 0));
        JButton button = new JButton("");
        button.setBorder(null);
        this.add((Component)button, "West");
        button.setIcon(Toolkit.CONVEX);
        button.addActionListener(e -> this.launchPeerWindow(this.peer));
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        this.description = new JTextArea(this.peer == null ? "No peer" : this.peer.toString());
        this.description.setFont(Toolkit.SMALL_MONO_FONT);
        this.description.setEditable(false);
        this.description.setBorder(null);
        this.description.setBackground(null);
        panel.add((Component)this.description, "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        if (this.peer.isLocal()) {
            closeButton = new JMenuItem("Shutdown Peer");
            closeButton.addActionListener(e -> this.peer.close());
            popupMenu.add(closeButton);
            JMenuItem exploreButton = new JMenuItem("Explore state");
            exploreButton.addActionListener(e -> this.launchExploreWindow(this.peer));
            popupMenu.add(exploreButton);
            if (this.peer.peerServer.getStore() instanceof EtchStore) {
                JMenuItem storeButton = new JMenuItem("Explore Etch store");
                storeButton.addActionListener(e -> this.launchEtchWindow(this.peer));
                popupMenu.add(storeButton);
            }
            JMenuItem killConn = new JMenuItem("Kill Connections");
            killConn.addActionListener(e -> this.peer.peerServer.getConnectionManager().closeAllConnections());
            popupMenu.add(killConn);
        } else {
            closeButton = new JMenuItem("Close connection");
            closeButton.addActionListener(e -> this.peer.close());
            popupMenu.add(closeButton);
        }
        JMenuItem replButton = new JMenuItem("Launch REPL");
        replButton.addActionListener(e -> this.launchPeerWindow(this.peer));
        popupMenu.add(replButton);
        BlockViewComponent blockView = new BlockViewComponent(this.peer);
        this.add((Component)blockView, "South");
        DropdownMenu dm = new DropdownMenu(popupMenu);
        this.add((Component)dm, "East");
        if (this.peer != null && (model = this.peer.peerModel) != null) {
            model.addPropertyChangeListener(e -> {
                blockView.repaint();
                this.description.setText(this.peer.toString());
            });
        }
        PeerGUI.tickState.addPropertyChangeListener(e -> this.description.setText(this.peer.toString()));
    }
}

