/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.etch;

import convex.cli.etch.AEtchCommand;
import convex.core.data.ACell;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.text.Text;
import convex.core.util.Utils;
import convex.etch.Etch;
import convex.etch.EtchStore;
import picocli.CommandLine;

@CommandLine.Command(name="info", mixinStandardHelpOptions=true, description={"Outputs summary data about the Etch database."})
public class EtchInfo
extends AEtchCommand {
    @CommandLine.Option(names={"-o", "--output-file"}, description={"Output file for the the Etch info."})
    private String outputFilename;

    @Override
    public void execute() {
        this.cli().setOut(this.outputFilename);
        try (EtchStore store = this.store();){
            Etch etch = store.getEtch();
            this.println("Etch file:          " + store.getFile().getCanonicalPath());
            this.println("Etch version:       0x" + Utils.toHexString((short)etch.getVersion()));
            this.println("Data length:        " + Text.toFriendlyNumber((long)etch.getDataLength()));
            this.println("Data root:          " + String.valueOf(etch.getRootHash()));
            try {
                ACell root = store.getRootData();
                this.println("Root memory size:   " + Text.toFriendlyNumber((long)ACell.getMemorySize((ACell)root)));
                this.println("Root data type:     " + String.valueOf(RT.getType((ACell)root)));
                Long n = RT.count((ACell)root);
                if (n != null) {
                    this.println("Root element count: " + n);
                }
            }
            catch (MissingDataException e) {
                this.println("Root data missing");
            }
        }
    }
}

