/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.CLIError;
import convex.cli.Main;
import convex.cli.output.Coloured;
import convex.cli.output.RecordOutput;
import convex.core.Result;
import convex.core.util.Utils;
import java.io.Console;
import picocli.CommandLine;

public abstract class ACommand
implements Runnable {
    public abstract Main cli();

    public void showUsage() {
        CommandLine cl = new CommandLine((Object)this);
        cl.setUsageHelpAutoWidth(true);
        cl.setUsageHelpWidth(100);
        cl.setUsageHelpLongOptionsMaxWidth(40);
        cl.usage(this.cli().commandLine().getOut(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
    }

    public CommandLine commandLine() {
        return this.cli().commandLine;
    }

    @Override
    public final void run() {
        try {
            this.execute();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CLIError(75, "Command interrupted");
        }
    }

    protected abstract void execute() throws InterruptedException;

    public boolean isParanoid() {
        return this.cli().isParanoid();
    }

    public void paranoia(String message) {
        if (this.isParanoid()) {
            throw new CLIError("STRICT SECURITY: " + message);
        }
    }

    protected void inform(int level, String formattedMessage) {
        if (this.verbose() < level) {
            return;
        }
        this.commandLine().getErr().println(formattedMessage);
    }

    protected int verbose() {
        return this.cli().verbose();
    }

    public void println(String s) {
        if (s == null) {
            s = "null";
        }
        this.commandLine().getOut().println(s);
    }

    public void printResult(Result result) {
        this.commandLine().getOut().println(result.toString());
    }

    public void printRecord(RecordOutput output) {
        output.writeToStream(this.commandLine().getOut());
    }

    public void println(Object value) {
        this.println(Utils.toString((Object)value));
    }

    public boolean isInteractive() {
        return this.cli().isInteractive();
    }

    public String prompt(String message) {
        if (!this.isInteractive()) {
            throw new CLIError("Can't prompt for user input in non-interactive mode: " + message);
        }
        if (this.isColoured()) {
            message = Coloured.blue(message);
        }
        this.inform(0, message);
        return System.console().readLine();
    }

    public char[] readPassword(String prompt) {
        Console c = System.console();
        if (c == null) {
            if (this.verbose() >= 3) {
                this.informError("Can't give user prompt: " + prompt);
            }
            throw new CLIError(64, "Unable to request password because console is unavailable. Consider passing a password parameter, or running in interactive mode.");
        }
        if (this.isColoured()) {
            prompt = Coloured.blue(prompt);
        }
        return c.readPassword(prompt, new Object[0]);
    }

    protected boolean isColoured() {
        return this.cli().isColoured();
    }

    public void informSuccess(String message) {
        if (this.isColoured()) {
            message = Coloured.green(message);
        }
        this.inform(1, message);
    }

    public void informError(String message) {
        if (this.isColoured()) {
            message = Coloured.red(message);
        }
        this.inform(1, message);
    }

    public void inform(String message) {
        if (this.isColoured()) {
            message = Coloured.yellow(message);
        }
        this.inform(1, message);
    }

    public void informWarning(String message) {
        if (this.isColoured()) {
            message = Coloured.orange(message);
        }
        this.inform(1, message);
    }
}

