/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.Main;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.lang.Reader;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="transaction", aliases={"transact", "tr"}, mixinStandardHelpOptions=true, description={"Execute a transaction on the network via a peer."})
public class Transaction
implements Runnable {
    @CommandLine.ParentCommand
    protected Main mainParent;
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    @CommandLine.Option(names={"-i", "--index-key"}, defaultValue="0", description={"Keystore index of the public/private key to use to run the transaction."})
    private int keystoreIndex;
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"Hex string of the public key in the Keystore to use to run the transaction.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String keystorePublicKey;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect or create a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-a", "--address"}, description={"Account address to use for the transaction request."})
    private long addressNumber;
    @CommandLine.Option(names={"-t", "--timeout"}, description={"Timeout in miliseconds."})
    private long timeout = 5000L;
    @CommandLine.Parameters(paramLabel="transactionCommand", description={"Transaction Command"})
    private String transactionCommand;

    @Override
    public void run() {
        AKeyPair keyPair = null;
        try {
            keyPair = this.mainParent.loadKeyFromStore(this.keystorePublicKey, this.keystoreIndex);
        }
        catch (Error e) {
            this.mainParent.showError(e);
            return;
        }
        if (keyPair == null) {
            log.warn("cannot load a valid key pair to perform this transaction");
            return;
        }
        if (this.addressNumber == 0L) {
            log.warn("--address. You need to provide a valid address number");
            return;
        }
        Address address = Address.create((long)this.addressNumber);
        Convex convex = null;
        try {
            convex = this.mainParent.connectToSessionPeer(this.hostname, this.port, address, keyPair);
            log.info("Executing transaction: %s\n", (Object)this.transactionCommand);
            ACell message = Reader.read((String)this.transactionCommand);
            Invoke transaction = Invoke.create((Address)address, (long)-1L, (ACell)message);
            Result result = convex.transactSync((ATransaction)transaction, this.timeout);
            this.mainParent.output.setResult(result);
        }
        catch (Throwable t) {
            this.mainParent.showError(t);
        }
    }
}

