/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.Main;
import convex.cli.Peer;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.lang.Reader;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import java.io.File;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="create", aliases={"cr"}, mixinStandardHelpOptions=true, description={"Creates a keypair, new account and a funding stake: to run a local peer."})
public class PeerCreate
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PeerCreate.class);
    @CommandLine.ParentCommand
    private Peer peerParent;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-i", "--index-key"}, defaultValue="0", description={"Keystore index of the public/private key to use for the peer."})
    private int keystoreIndex;
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"Hex string of the public key in the Keystore to use for the peer.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String keystorePublicKey;
    @CommandLine.Option(names={"--port"}, description={"Port number of nearest peer to connect too."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-t", "--timeout"}, description={"Timeout in miliseconds."})
    private long timeout = 5000L;

    @Override
    public void run() {
        KeyStore keyStore;
        Main mainParent = this.peerParent.mainParent;
        int port = 0;
        long peerStake = 10000000000L;
        AKeyPair keyPair = null;
        try {
            keyStore = mainParent.loadKeyStore(true);
        }
        catch (Error e) {
            log.info(e.getMessage());
            return;
        }
        try {
            keyPair = AKeyPair.generate();
            PFXTools.saveKey((KeyStore)keyStore, (AKeyPair)keyPair, (String)mainParent.getPassword());
            File keyFile = new File(mainParent.getKeyStoreFilename());
            PFXTools.saveStore((KeyStore)keyStore, (File)keyFile, (String)mainParent.getPassword());
            Convex convex = mainParent.connectAsPeer(0);
            Address address = convex.createAccountSync(keyPair.getAccountKey());
            convex.transferSync(address, peerStake);
            convex = mainParent.connectToSessionPeer(this.hostname, port, address, keyPair);
            long stakeBalance = convex.getBalance(address);
            String accountKeyString = keyPair.getAccountKey().toHexString();
            long stakeAmount = (long)((double)stakeBalance * 0.98);
            String transactionCommand = String.format("(create-peer 0x%s %d)", accountKeyString, stakeAmount);
            ACell message = Reader.read((String)transactionCommand);
            Invoke transaction = Invoke.create((Address)address, (long)-1L, (ACell)message);
            Result result = convex.transactSync((ATransaction)transaction, this.timeout);
            if (result.isError()) {
                mainParent.output.setResult(result);
                return;
            }
            long currentBalance = convex.getBalance(address);
            mainParent.output.setField("Public Peer Key", keyPair.getAccountKey().toString());
            mainParent.output.setField("Address", address.longValue());
            mainParent.output.setField("Balance", currentBalance);
            mainParent.output.setField("Inital stake amount", stakeAmount);
            String shortAccountKey = accountKeyString.substring(0, 6);
            mainParent.output.setField("Peer start line", String.format("./convex peer start --password=%s --address=%d --public-key=%s", mainParent.getPassword(), address.toLong(), shortAccountKey));
        }
        catch (Throwable t) {
            mainParent.showError(t);
        }
    }
}

