/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.packet;

import eu.thesimplecloud.clientserverapi.lib.ByteBufStringHelper;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.ICommunicationBootstrap;
import eu.thesimplecloud.clientserverapi.lib.debug.DebugMessage;
import eu.thesimplecloud.clientserverapi.lib.packet.PacketData;
import eu.thesimplecloud.clientserverapi.lib.packet.WrappedPacket;
import eu.thesimplecloud.jsonlib.JsonLib;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Leu/thesimplecloud/clientserverapi/lib/packet/PacketEncoder;", "Lio/netty/handler/codec/MessageToByteEncoder;", "Leu/thesimplecloud/clientserverapi/lib/packet/WrappedPacket;", "communicationBootstrap", "Leu/thesimplecloud/clientserverapi/lib/bootstrap/ICommunicationBootstrap;", "(Leu/thesimplecloud/clientserverapi/lib/bootstrap/ICommunicationBootstrap;)V", "encode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "wrappedPacket", "byteBuf", "Lio/netty/buffer/ByteBuf;", "clientserverapi"})
public final class PacketEncoder
extends MessageToByteEncoder<WrappedPacket> {
    @NotNull
    private final ICommunicationBootstrap communicationBootstrap;

    public PacketEncoder(@NotNull ICommunicationBootstrap communicationBootstrap) {
        Intrinsics.checkNotNullParameter((Object)communicationBootstrap, (String)"communicationBootstrap");
        this.communicationBootstrap = communicationBootstrap;
    }

    protected synchronized void encode(@NotNull ChannelHandlerContext ctx, @NotNull WrappedPacket wrappedPacket, @NotNull ByteBuf byteBuf) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)wrappedPacket, (String)"wrappedPacket");
        Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
        JsonLib jsoLib = JsonLib.Companion.empty();
        UUID uUID = wrappedPacket.getPacketData().getUniqueId();
        String string = wrappedPacket.getPacket().getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        PacketData packetData = new PacketData(uUID, string, wrappedPacket.getPacketData().isResponse());
        jsoLib.append("data", (Object)packetData);
        ByteBufStringHelper.Companion.writeString(byteBuf, jsoLib.getAsJsonString());
        wrappedPacket.getPacket().write(byteBuf, this.communicationBootstrap);
        if (this.communicationBootstrap.getDebugMessageManager().isActive(DebugMessage.PACKET_SENT)) {
            System.out.println((Object)("Sent packet " + wrappedPacket.getPacket().getClass().getSimpleName() + " (" + packetData.getUniqueId() + ")"));
        }
    }
}

