/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.connection;

import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.handler.packet.IncomingPacketHandler;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.PacketData;
import eu.thesimplecloud.clientserverapi.lib.packet.WrappedPacket;
import eu.thesimplecloud.clientserverapi.lib.packetresponse.IPacketResponseManager;
import eu.thesimplecloud.clientserverapi.lib.packetresponse.WrappedResponseHandler;
import eu.thesimplecloud.clientserverapi.lib.packetresponse.responsehandler.ObjectPacketResponseHandler;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H&J6\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0016\"\b\b\u0000\u0010\u0019*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u0011J\b\u0010!\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Leu/thesimplecloud/clientserverapi/lib/connection/AbstractConnection;", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "()V", "BYTES_PER_FILEPACKET", "", "incomingPacketHandler", "Leu/thesimplecloud/clientserverapi/lib/handler/packet/IncomingPacketHandler;", "packetResponseManager", "Leu/thesimplecloud/clientserverapi/lib/packetresponse/IPacketResponseManager;", "getPacketResponseManager", "()Leu/thesimplecloud/clientserverapi/lib/packetresponse/IPacketResponseManager;", "packetResponseManager$delegate", "Lkotlin/Lazy;", "sendingFile", "", "wasCloseIntended", "incomingPacket", "", "wrappedPacket", "Leu/thesimplecloud/clientserverapi/lib/packet/WrappedPacket;", "sendPacket", "promise", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "sendQuery", "T", "packet", "Leu/thesimplecloud/clientserverapi/lib/packet/IPacket;", "expectedResponseClass", "Ljava/lang/Class;", "timeout", "", "setConnectionCloseIntended", "wasConnectionCloseIntended", "clientserverapi"})
public abstract class AbstractConnection
implements IConnection {
    private final int BYTES_PER_FILEPACKET;
    private volatile boolean wasCloseIntended;
    private volatile boolean sendingFile;
    @NotNull
    private final Lazy packetResponseManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IPacketResponseManager>(this){
        final /* synthetic */ AbstractConnection this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final IPacketResponseManager invoke() {
            return this.this$0.getCommunicationBootstrap().getPacketResponseManager();
        }
    }));
    @NotNull
    private final IncomingPacketHandler incomingPacketHandler = new IncomingPacketHandler(this);

    public AbstractConnection() {
        this.BYTES_PER_FILEPACKET = 50000;
    }

    private final IPacketResponseManager getPacketResponseManager() {
        Lazy lazy = this.packetResponseManager$delegate;
        return (IPacketResponseManager)lazy.getValue();
    }

    @Override
    @NotNull
    public synchronized <T> ICommunicationPromise<T> sendQuery(@NotNull IPacket packet, @NotNull Class<T> expectedResponseClass, long timeout) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter(expectedResponseClass, (String)"expectedResponseClass");
        ObjectPacketResponseHandler<T> packetResponseHandler = new ObjectPacketResponseHandler<T>(expectedResponseClass);
        UUID uniqueId = UUID.randomUUID();
        CommunicationPromise packetPromise = new CommunicationPromise(timeout, false, 2, null);
        IPacketResponseManager iPacketResponseManager = this.getPacketResponseManager();
        Intrinsics.checkNotNull((Object)uniqueId);
        iPacketResponseManager.registerResponseHandler(uniqueId, new WrappedResponseHandler(packetResponseHandler, packetPromise));
        String string = packet.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.sendPacket(new WrappedPacket(new PacketData(uniqueId, string, false), packet), packetPromise);
        return packetPromise;
    }

    public final void incomingPacket(@NotNull WrappedPacket wrappedPacket) {
        Intrinsics.checkNotNullParameter((Object)wrappedPacket, (String)"wrappedPacket");
        this.incomingPacketHandler.handleIncomingPacket(wrappedPacket);
    }

    public abstract void sendPacket(@NotNull WrappedPacket var1, @NotNull ICommunicationPromise<? extends Object> var2);

    public final void setConnectionCloseIntended() {
        this.wasCloseIntended = true;
    }

    @Override
    public boolean wasConnectionCloseIntended() {
        return !this.isOpen() && this.wasCloseIntended;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendUnitQuery(@NotNull IPacket packet, long timeout) {
        return IConnection.DefaultImpls.sendUnitQuery(this, packet, timeout);
    }
}

