/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.common.jsresource;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import works.lmz.common.Flags;
import works.lmz.common.jackson.JacksonHelperApi;
import works.lmz.common.jsresource.ApplicationResource;
import works.lmz.common.jsresource.ResourceNamespace;
import works.lmz.common.jsresource.ResourceScope;

public class ResourceServlet
extends HttpServlet {
    protected String namespace = "js";
    @Inject
    protected ResourceNamespace resourceNamespace;
    @Inject
    protected JacksonHelperApi jacksonHelperApi;
    @Autowired(required=false)
    protected List<ApplicationResource> applicationResources;
    protected String globalResults = null;

    public void init(ServletConfig config) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)((Object)this), (ServletContext)config.getServletContext());
        this.namespace = this.resourceNamespace.getNamespace();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResourceScope scope = this.getResourceScopeForPath(request == null ? null : request.getPathInfo());
        this.setResponseHeaders(response, scope);
        Writer responseWriter = this.getResponseWriter(response);
        if (responseWriter == null) {
            throw new IllegalStateException("Cannot write without a proper writer instance");
        }
        if (this.isInDevMode() || scope == ResourceScope.Session) {
            this.writeResourcesForScope(responseWriter, scope);
        } else if (scope == ResourceScope.Global) {
            if (this.globalResults == null) {
                StringWriter stringWriter = new StringWriter();
                this.writeResourcesForScope(stringWriter, scope);
                this.globalResults = stringWriter.toString();
            }
            responseWriter.write(this.globalResults);
        } else if (scope == ResourceScope.Unknown) {
            this.writeErrorComment(responseWriter);
        }
    }

    protected void writeResourcesForScope(Writer writer, ResourceScope scope) throws IOException {
        ArrayList<ApplicationResource> scopeResources = new ArrayList<ApplicationResource>();
        if (this.applicationResources != null) {
            for (ApplicationResource applicationResource : this.applicationResources) {
                if (!applicationResource.getResourceScope().equals((Object)scope)) continue;
                scopeResources.add(applicationResource);
            }
        }
        this.writeHeader(writer);
        for (ApplicationResource resource : scopeResources) {
            this.writeResource(writer, resource);
        }
    }

    protected void setResponseHeaders(HttpServletResponse response, ResourceScope scope) {
        response.setHeader("Content-Type", "text/javascript; charset=utf-8");
        if (scope.equals((Object)ResourceScope.Global)) {
            response.setHeader("Cache-Control", "max-age=290304000, public");
        } else if (scope.equals((Object)ResourceScope.Session)) {
            response.setHeader("Cache-Control", "no-cache, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "Sat, 26 Jul 1997 05:00:00 GMT");
        }
    }

    protected Writer getResponseWriter(HttpServletResponse response) throws IOException {
        return response == null ? null : response.getWriter();
    }

    protected void writeErrorComment(Writer writer) throws IOException {
        writer.write("/* unable to render unknown scope */\n");
    }

    protected void writeHeader(Writer writer) throws IOException {
        writer.write(String.format("if (!window.%s) { window.%s = {}; }\n", this.namespace, this.namespace));
    }

    protected void writeResource(Writer writer, ApplicationResource resource) throws IOException {
        if (resource != null && resource.getResourceMap() != null) {
            for (Map.Entry<String, Object> item : resource.getResourceMap().entrySet()) {
                assert (this.jacksonHelperApi != null);
                writer.write(String.format("%s.%s = %s;\n", this.namespace, item.getKey(), this.jacksonHelperApi.jsonSerialize(item.getValue())));
            }
        }
    }

    protected boolean isInDevMode() {
        return Flags.DEVMODE.on();
    }

    protected ResourceScope getResourceScopeForPath(String pathInfo) {
        ResourceScope scope = ResourceScope.Unknown;
        if (pathInfo != null) {
            if (pathInfo.endsWith("/global.js")) {
                scope = ResourceScope.Global;
            }
            if (pathInfo.endsWith("/session.js")) {
                scope = ResourceScope.Session;
            }
        }
        return scope;
    }
}

