/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.util.Date;
import java.util.List;
import java.util.Map;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRpcException;

public interface BitcoindRpcClient {
    public String createRawTransaction(List<TxInput> var1, List<TxOutput> var2) throws BitcoinRpcException;

    public String dumpPrivKey(String var1) throws BitcoinRpcException;

    public String getAccount(String var1) throws BitcoinRpcException;

    public List<String> getAddressesByAccount(String var1) throws BitcoinRpcException;

    public double getBalance() throws BitcoinRpcException;

    public double getBalance(String var1) throws BitcoinRpcException;

    public double getBalance(String var1, int var2) throws BitcoinRpcException;

    public Block getBlock(int var1) throws BitcoinRpcException;

    public Block getBlock(String var1) throws BitcoinRpcException;

    public String getBlockHash(int var1) throws BitcoinRpcException;

    public BlockChainInfo getBlockChainInfo() throws BitcoinRpcException;

    public int getBlockCount() throws BitcoinRpcException;

    public String getNewAddress() throws BitcoinRpcException;

    public String getNewAddress(String var1) throws BitcoinRpcException;

    public List<String> getRawMemPool() throws BitcoinRpcException;

    public String getBestBlockHash() throws BitcoinRpcException;

    public String getRawTransactionHex(String var1) throws BitcoinRpcException;

    public RawTransaction getRawTransaction(String var1) throws BitcoinRpcException;

    public double getReceivedByAddress(String var1) throws BitcoinRpcException;

    public double getReceivedByAddress(String var1, int var2) throws BitcoinRpcException;

    public void importPrivKey(String var1) throws BitcoinRpcException;

    public void importPrivKey(String var1, String var2) throws BitcoinRpcException;

    public void importPrivKey(String var1, String var2, boolean var3) throws BitcoinRpcException;

    public Map<String, Number> listAccounts() throws BitcoinRpcException;

    public Map<String, Number> listAccounts(int var1) throws BitcoinRpcException;

    public List<ReceivedAddress> listReceivedByAddress() throws BitcoinRpcException;

    public List<ReceivedAddress> listReceivedByAddress(int var1) throws BitcoinRpcException;

    public List<ReceivedAddress> listReceivedByAddress(int var1, boolean var2) throws BitcoinRpcException;

    public TransactionsSinceBlock listSinceBlock() throws BitcoinRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1) throws BitcoinRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1, int var2) throws BitcoinRpcException;

    public List<Transaction> listTransactions() throws BitcoinRpcException;

    public List<Transaction> listTransactions(String var1) throws BitcoinRpcException;

    public List<Transaction> listTransactions(String var1, int var2) throws BitcoinRpcException;

    public List<Transaction> listTransactions(String var1, int var2, int var3) throws BitcoinRpcException;

    public List<Unspent> listUnspent() throws BitcoinRpcException;

    public List<Unspent> listUnspent(int var1) throws BitcoinRpcException;

    public List<Unspent> listUnspent(int var1, int var2) throws BitcoinRpcException;

    public List<Unspent> listUnspent(int var1, int var2, String ... var3) throws BitcoinRpcException;

    public String sendFrom(String var1, String var2, double var3) throws BitcoinRpcException;

    public String sendFrom(String var1, String var2, double var3, int var5) throws BitcoinRpcException;

    public String sendFrom(String var1, String var2, double var3, int var5, String var6) throws BitcoinRpcException;

    public String sendFrom(String var1, String var2, double var3, int var5, String var6, String var7) throws BitcoinRpcException;

    public String sendRawTransaction(String var1) throws BitcoinRpcException;

    public String sendToAddress(String var1, double var2) throws BitcoinRpcException;

    public String sendToAddress(String var1, double var2, String var4) throws BitcoinRpcException;

    public String sendToAddress(String var1, double var2, String var4, String var5) throws BitcoinRpcException;

    public String signRawTransaction(String var1) throws BitcoinRpcException;

    public void setGenerate(int var1) throws BitcoinRPCException;

    public AddressValidationResult validateAddress(String var1) throws BitcoinRpcException;

    public static interface AddressValidationResult {
        public boolean isValid();

        public String address();

        public boolean isMine();

        public boolean isScript();

        public String pubKey();

        public boolean isCompressed();

        public String account();
    }

    public static interface Unspent
    extends TxInput,
    TxOutput {
        @Override
        public String txid();

        @Override
        public int vout();

        @Override
        public String address();

        public String account();

        public String scriptPubKey();

        @Override
        public double amount();

        public int confirmations();
    }

    public static interface TransactionsSinceBlock {
        public List<Transaction> transactions();

        public String lastBlock();
    }

    public static interface Transaction {
        public String account();

        public String address();

        public String category();

        public double amount();

        public double fee();

        public int confirmations();

        public String blockHash();

        public int blockIndex();

        public Date blockTime();

        public String txId();

        public Date time();

        public Date timeReceived();

        public String comment();

        public String commentTo();

        public RawTransaction raw();
    }

    public static interface ReceivedAddress {
        public String address();

        public String account();

        public double amount();

        public int confirmations();
    }

    public static interface RawTransaction {
        public String hex();

        public String txId();

        public int version();

        public long lockTime();

        public List<In> vIn();

        public List<Out> vOut();

        public String blockHash();

        public int confirmations();

        public Date time();

        public Date blocktime();

        public static interface Out {
            public double value();

            public int n();

            public ScriptPubKey scriptPubKey();

            public TxInput toInput();

            public RawTransaction transaction();

            public static interface ScriptPubKey {
                public String asm();

                public String hex();

                public int reqSigs();

                public String type();

                public List<String> addresses();
            }
        }

        public static interface In
        extends TxInput {
            public Map<String, Object> scriptSig();

            public long sequence();

            public RawTransaction getTransaction();

            public Out getTransactionOutput();
        }
    }

    public static interface Block {
        public String hash();

        public int confirmations();

        public int size();

        public int height();

        public int version();

        public String merkleRoot();

        public List<String> tx();

        public Date time();

        public long nonce();

        public String bits();

        public double difficulty();

        public String previousHash();

        public String nextHash();

        public String chainwork();

        public Block previous() throws BitcoinRpcException;

        public Block next() throws BitcoinRpcException;
    }

    public static interface BlockChainInfo {
        public String chain();

        public int blocks();

        public String bestBlockHash();

        public double difficulty();

        public double verificationProgress();

        public String chainWork();
    }

    public static class BasicTxOutput
    implements TxOutput {
        public String address;
        public double amount;

        public BasicTxOutput(String address, double amount) {
            this.address = address;
            this.amount = amount;
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public double amount() {
            return this.amount;
        }
    }

    public static interface TxOutput {
        public String address();

        public double amount();
    }

    public static class BasicTxInput
    implements TxInput {
        public String txid;
        public int vout;

        public BasicTxInput(String txid, int vout) {
            this.txid = txid;
            this.vout = vout;
        }

        @Override
        public String txid() {
            return this.txid;
        }

        @Override
        public int vout() {
            return this.vout;
        }
    }

    public static interface TxInput {
        public String txid();

        public int vout();
    }
}

