/*
 * Decompiled with CFR 0.152.
 */
package website.magyar.mitm.standalone;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.magyar.mitm.standalone.helper.PropertiesNotAvailableException;

public class PropertyLoader {
    private final Logger logger = LoggerFactory.getLogger(PropertyLoader.class);

    public Properties loadProperties(String configFile) {
        Properties properties = new Properties();
        if (configFile != null) {
            try {
                this.checkPropertyFileArgument(configFile);
                FileInputStream inputStream = new FileInputStream(configFile);
                properties.load(inputStream);
                this.logger.debug("Properties loaded from external configuration.");
            }
            catch (IOException e) {
                throw new PropertiesNotAvailableException("Configuration file " + configFile + " cannot be loaded.", e);
            }
        }
        return properties;
    }

    private void checkPropertyFileArgument(String args) {
        if (args == null || "".equals(args)) {
            throw new PropertiesNotAvailableException("Configuration file was not specified as input argument!");
        }
        if (!args.endsWith(".properties")) {
            throw new PropertiesNotAvailableException("Configuration file must be a properties file!");
        }
    }
}

