/*
 * Decompiled with CFR 0.152.
 */
package website.magyar.mitm.standalone;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.magyar.mitm.proxy.ProxyServer;
import website.magyar.mitm.standalone.PropertyLoader;

public class Bootstrap {
    private static final int PROXY_TIMEOUT = 1200000;
    private final Logger logger = LoggerFactory.getLogger(Bootstrap.class);
    private int proxyPort = -1;
    private Properties properties;
    private ProxyServer proxyServer;

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public ProxyServer bootstrap(String[] args) {
        ProxyServer proxyServer = null;
        PropertyLoader propertyLoader = new PropertyLoader();
        String configurationFile = args != null && args.length > 0 ? args[0] : null;
        this.properties = propertyLoader.loadProperties(configurationFile);
        Integer port = this.getPort();
        Integer proxyTimeout = this.getProxyTimeout();
        Boolean keepSslAlive = this.getKeepSslAlive();
        try {
            proxyServer = this.startProxy(port, proxyTimeout, keepSslAlive);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return proxyServer;
    }

    public ProxyServer bootstrapFixed() {
        ProxyServer proxyServer = null;
        try {
            proxyServer = this.startProxy(9092, 30000, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return proxyServer;
    }

    private Boolean getKeepSslAlive() {
        return Boolean.valueOf(this.properties.getProperty("proxy.keepSslAlive"));
    }

    private Integer getProxyTimeout() {
        int timeout = 1200000;
        try {
            timeout = Integer.parseInt(this.properties.getProperty("proxy.timeout"));
        }
        catch (NumberFormatException e) {
            this.logger.warn("Invalid proxy timeout value! - Using default timeout:{}", (Object)1200000);
        }
        return timeout;
    }

    private Integer getPort() {
        int port = 0;
        try {
            port = Integer.parseInt(this.properties.getProperty("proxy.port"));
        }
        catch (NumberFormatException e) {
            this.logger.warn("Invalid proxy port value! - Using random port.");
        }
        return port;
    }

    private ProxyServer startProxy(int port, int proxyTimeout, boolean keepSslAlive) throws Exception {
        this.proxyServer = new ProxyServer(port);
        this.proxyServer.start(proxyTimeout);
        this.proxyPort = this.proxyServer.getPort();
        ProxyServer.setShouldKeepSslConnectionAlive(keepSslAlive);
        return this.proxyServer;
    }
}

