/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustingSSLSocketFactory
extends SSLConnectionSocketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustingSSLSocketFactory.class);
    private static KeyStore keyStore;
    private static String keyStorePassword;
    private final int timeout;

    public TrustingSSLSocketFactory(int timeout) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        super(SSLContexts.custom().loadKeyMaterial(keyStore, keyStorePassword.toCharArray()).loadTrustMaterial(null, (cert, authType) -> true).build(), (HostnameVerifier)new NoopHostnameVerifier());
        this.timeout = timeout;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        Socket sslSocket = super.createSocket(context);
        sslSocket.setSoTimeout(this.timeout);
        this.configureSocket(sslSocket);
        return sslSocket;
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket sslSocket = super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
        return sslSocket;
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        Socket sslSocket = super.createLayeredSocket(socket, target, port, context);
        this.configureSocket(sslSocket);
        return sslSocket;
    }

    private void configureSocket(Socket socket) {
        try {
            socket.setReuseAddress(true);
            socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            keyStorePassword = "password";
            String keyStorePath = "/sslSupport/cybervillainsCA.jks";
            if (keyStorePath != null) {
                InputStream fis = TrustingSSLSocketFactory.class.getResourceAsStream(keyStorePath);
                keyStore = KeyStore.getInstance("jks");
                keyStore.load(fis, keyStorePassword.toCharArray());
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.warn("JKS file not found continue without keyStore", (Throwable)e);
        }
    }
}

