/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lightbody.bmp.proxy.http.BadURIException;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import net.lightbody.bmp.proxy.http.RequestCallback;
import net.lightbody.bmp.proxy.jetty.http.HttpListener;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.HttpServer;
import net.lightbody.bmp.proxy.jetty.http.HttpTunnel;
import net.lightbody.bmp.proxy.jetty.http.SocketListener;
import net.lightbody.bmp.proxy.jetty.jetty.BmpServer;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import net.lightbody.bmp.proxy.jetty.util.URI;
import net.lightbody.bmp.proxy.selenium.SeleniumProxyHandler;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.magyar.mitm.proxy.http.MitmJavaProxyHttpRequest;
import website.magyar.mitm.proxy.http.MitmJavaProxyHttpResponse;

public class BrowserMobProxyHandler
extends SeleniumProxyHandler {
    protected static final Logger logger = LoggerFactory.getLogger(BrowserMobProxyHandler.class);
    private static final int HEADER_BUFFER_DEFAULT = 2;
    protected final Set<SeleniumProxyHandler.SslRelay> sslRelays = new HashSet<SeleniumProxyHandler.SslRelay>();
    private BmpServer jettyBmpServer;
    private int headerBufferMultiplier = 2;
    private BrowserMobHttpClient httpClient;

    public BrowserMobProxyHandler() {
        super(true, false, false);
        this.setShutdownLock(new Object());
        this.setTunnelTimeoutMs(300000);
    }

    private static void reportError(Exception e, URL url, HttpResponse response) {
        int status = 502;
        String shortDesc = "PROXY: Bad Gateway";
        String longDesc = "The server was acting as a gateway or proxy and received an invalid response from the upstream server.";
        if (e instanceof UnknownHostException) {
            status = 404;
            shortDesc = "PROXY: Not Found";
            longDesc = "The requested resource could not be found but may be available again in the future. Subsequent requests by the client are permissible.";
        } else if (e instanceof ConnectException) {
            status = 503;
            shortDesc = "PROXY: Service Unavailable";
            longDesc = "The server is currently unavailable (because it is overloaded or down for maintenance). Generally, this is a temporary state.";
        } else if (e instanceof ConnectTimeoutException) {
            status = 504;
            shortDesc = "PROXY: Connection timed out!";
            longDesc = "The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.";
        } else if (e instanceof SocketTimeoutException) {
            status = 504;
            shortDesc = "PROXY: Connection timed out!";
            longDesc = "The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(shortDesc).append("\n").append(longDesc);
        String text = sb.toString();
        try {
            response.setStatus(status);
            response.setContentLength(text.length());
            response.getOutputStream().write(text.getBytes());
        }
        catch (IOException e1) {
            logger.warn("IOException while trying to report an HTTP error");
        }
    }

    @Override
    public void handleConnect(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws IOException {
        String altHost;
        String original;
        URI uri = request.getURI();
        String host = original = uri.toString();
        String port = null;
        int colon = original.indexOf(58);
        if (colon != -1) {
            host = original.substring(0, colon);
            port = original.substring(colon + 1);
        }
        if ((altHost = this.httpClient.remappedHost(host)) != null) {
            if (port != null) {
                uri.setURI(altHost + ":" + port);
            } else {
                uri.setURI(altHost);
            }
        }
        super.handleConnect(pathInContext, pathParams, request, response);
    }

    @Override
    protected void wireUpSslWithCyberVilliansCA(String host, SeleniumProxyHandler.SslRelay listener) {
        List<String> originalHosts = this.httpClient.originalHosts((String)host);
        if (originalHosts != null && !originalHosts.isEmpty()) {
            if (originalHosts.size() == 1) {
                host = originalHosts.get(0);
            } else {
                String first = originalHosts.get(0);
                host = "*" + first.substring(first.indexOf(46));
            }
        }
        super.wireUpSslWithCyberVilliansCA((String)host, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SeleniumProxyHandler.SslRelay getSslRelayOrCreateNew(URI uri, InetAddrPort addrPort, HttpServer server) throws Exception {
        SeleniumProxyHandler.SslRelay relay = super.getSslRelayOrCreateNew(uri, addrPort, server);
        relay.setNukeDirOrFile(null);
        Set<SeleniumProxyHandler.SslRelay> set = this.sslRelays;
        synchronized (set) {
            this.sslRelays.add(relay);
        }
        if (!relay.isStarted()) {
            server.addListener(relay);
            this.startRelayWithPortTollerance(server, relay, 1);
        }
        return relay;
    }

    private void startRelayWithPortTollerance(HttpServer server, SeleniumProxyHandler.SslRelay relay, int tries) throws Exception {
        if (tries >= 5) {
            throw new BindException("Unable to bind to several ports, most recently " + relay.getPort() + ". Giving up");
        }
        try {
            if (!server.isStarted()) {
                throw new RuntimeException("Can't start SslRelay: server is not started (perhaps it was just shut down?)");
            }
            relay.start();
        }
        catch (BindException e) {
            relay.setPort(relay.getPort() + 1);
            this.startRelayWithPortTollerance(server, relay, tries + 1);
        }
    }

    @Override
    protected HttpTunnel newHttpTunnel(HttpRequest httpRequest, HttpResponse httpResponse, InetAddress inetAddress, int i, int i1) throws IOException {
        this.adjustListenerBuffers();
        return super.newHttpTunnel(httpRequest, httpResponse, inetAddress, i, i1);
    }

    @Override
    protected long proxyPlainTextRequest(final URL url, String pathInContext, String pathParams, HttpRequest request, final HttpResponse response) {
        try {
            String urlStr = url.toString();
            if (urlStr.contains("/selenium-server/")) {
                return super.proxyPlainTextRequest(url, pathInContext, pathParams, request, response);
            }
            if (urlStr.startsWith("https://sb-ssl.google.com:443/safebrowsing") || urlStr.startsWith("http://en-us.fxfeeds.mozilla.com/en-US/firefox/headlines.xml") || urlStr.startsWith("http://fxfeeds.mozilla.com/firefox/headlines.xml") || urlStr.startsWith("http://fxfeeds.mozilla.com/en-US/firefox/headlines.xml") || urlStr.startsWith("http://newsrss.bbc.co.uk/rss/newsonline_world_edition/front_page/rss.xml")) {
                request.setHandled(true);
                return -1L;
            }
            if (this.httpClient == null) {
                request.setHandled(true);
                return -1L;
            }
            MitmJavaProxyHttpRequest httpReq = null;
            if ("GET".equals(request.getMethod())) {
                httpReq = this.httpClient.newGet(urlStr, request);
            } else if ("POST".equals(request.getMethod())) {
                httpReq = this.httpClient.newPost(urlStr, request);
            } else if ("PUT".equals(request.getMethod())) {
                httpReq = this.httpClient.newPut(urlStr, request);
            } else if ("DELETE".equals(request.getMethod())) {
                httpReq = this.httpClient.newDelete(urlStr, request);
            } else if ("OPTIONS".equals(request.getMethod())) {
                httpReq = this.httpClient.newOptions(urlStr, request);
            } else if ("HEAD".equals(request.getMethod())) {
                httpReq = this.httpClient.newHead(urlStr, request);
            } else {
                logger.warn("Unexpected request method {}, coming from {}, giving up", (Object)request.getMethod(), (Object)request.getRemoteAddr());
                request.setHandled(true);
                return -1L;
            }
            boolean isGet = "GET".equals(request.getMethod());
            boolean hasContent = false;
            Enumeration enm = request.getFieldNames();
            long contentLength = 0L;
            while (enm.hasMoreElements()) {
                String hdr = (String)enm.nextElement();
                if (!isGet && "Content-Type".equals(hdr)) {
                    hasContent = true;
                }
                if (!isGet && "Content-Length".equals(hdr)) {
                    contentLength = Long.parseLong(request.getField(hdr));
                    continue;
                }
                Enumeration vals = request.getFieldValues(hdr);
                while (vals.hasMoreElements()) {
                    String val = (String)vals.nextElement();
                    if (val == null || this._DontProxyHeaders.containsKey(hdr)) continue;
                    httpReq.addRequestHeader(hdr, val);
                }
            }
            try {
                InputStream in = request.getInputStream();
                if (hasContent) {
                    ByteArrayOutputStream baos = this.writeOutputStream(in);
                    contentLength = baos.size();
                    httpReq.setPlayGround(new ByteArrayInputStream(baos.toByteArray()));
                    httpReq.setRequestInputStream(new ByteArrayInputStream(baos.toByteArray()), contentLength);
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            httpReq.setOutputStream(response.getOutputStream());
            httpReq.setRequestCallback(new RequestCallback(){

                @Override
                public void handleStatusLine(StatusLine statusLine) {
                    response.setStatus(statusLine.getStatusCode());
                    response.setReason(statusLine.getReasonPhrase());
                }

                @Override
                public void handleHeaders(Header[] headers) {
                    for (Header header : headers) {
                        if (!this.reportHeader(header)) continue;
                        response.addField(header.getName(), header.getValue());
                    }
                }

                @Override
                public boolean reportHeader(Header header) {
                    return !BrowserMobProxyHandler.this._DontProxyHeaders.containsKey(header.getName()) && !BrowserMobProxyHandler.this._ProxyAuthHeaders.containsKey(header.getName());
                }

                @Override
                public void reportError(Exception e) {
                    BrowserMobProxyHandler.reportError(e, url, response);
                }
            });
            MitmJavaProxyHttpResponse httpRes = httpReq.execute();
            request.setHandled(true);
            return httpRes.getEntry().getResponse().getBodySize();
        }
        catch (BadURIException e) {
            logger.info(e.getMessage());
            BrowserMobProxyHandler.reportError(e, url, response);
            return -1L;
        }
        catch (Exception e) {
            logger.info("Exception while proxying " + url, (Throwable)e);
            BrowserMobProxyHandler.reportError(e, url, response);
            return -1L;
        }
    }

    private ByteArrayOutputStream writeOutputStream(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos;
    }

    public void rewriteUrl(String match, String replace) {
        this.httpClient.rewriteUrl(match, replace);
    }

    public void remapHost(String source, String target) {
        this.httpClient.remapHost(source, target);
    }

    public void setJettyServer(BmpServer jettyBmpServer) {
        this.jettyBmpServer = jettyBmpServer;
    }

    public void adjustListenerBuffers(int headerBufferMultiplier) {
        if (headerBufferMultiplier > 10) {
            headerBufferMultiplier = 10;
        }
        this.headerBufferMultiplier = headerBufferMultiplier;
        this.adjustListenerBuffers();
    }

    public void resetListenerBuffers() {
        this.headerBufferMultiplier = 2;
        this.adjustListenerBuffers();
    }

    public void adjustListenerBuffers() {
        HttpListener[] listeners;
        for (HttpListener listener : listeners = this.jettyBmpServer.getListeners()) {
            if (!(listener instanceof SocketListener)) continue;
            SocketListener sl = (SocketListener)listener;
            if (sl.getBufferReserve() != 512 * this.headerBufferMultiplier) {
                sl.setBufferReserve(512 * this.headerBufferMultiplier);
            }
            if (sl.getBufferSize() == 8192 * this.headerBufferMultiplier) continue;
            sl.setBufferSize(8192 * this.headerBufferMultiplier);
        }
    }

    public void setHttpClient(BrowserMobHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Set<SeleniumProxyHandler.SslRelay> set = this.sslRelays;
        synchronized (set) {
            for (SeleniumProxyHandler.SslRelay relay : this.sslRelays) {
                if (relay.getHttpServer() == null || !relay.isStarted()) continue;
                relay.getHttpServer().removeListener(relay);
            }
            this.sslRelays.clear();
        }
    }
}

