/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http;

import java.io.IOException;
import java.security.Principal;
import net.lightbody.bmp.proxy.jetty.http.Authenticator;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.UserRealm;
import net.lightbody.bmp.proxy.jetty.util.B64Code;
import net.lightbody.bmp.proxy.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticator
implements Authenticator {
    private final Logger log = LoggerFactory.getLogger(BasicAuthenticator.class);

    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        Principal user = null;
        String credentials = request.getField("Authorization");
        if (credentials != null) {
            try {
                this.log.debug("Credentials: {}", (Object)credentials);
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1);
                int i = credentials.indexOf(58);
                String username = credentials.substring(0, i);
                String password = credentials.substring(i + 1);
                user = realm.authenticate(username, password, request);
                if (user == null) {
                    this.log.warn("AUTH FAILURE: user {}", (Object)username);
                } else {
                    request.setAuthType("BASIC");
                    request.setAuthUser(username);
                    request.setUserPrincipal(user);
                }
            }
            catch (Exception e) {
                this.log.warn("AUTH FAILURE: {}", (Object)e.toString());
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, response);
        }
        return user;
    }

    @Override
    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm realm, HttpResponse response) throws IOException {
        response.setField("WWW-Authenticate", "basic realm=\"" + realm.getName() + '\"');
        response.sendError(401);
    }
}

