/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.wrapper;

import com.whl.quickjs.wrapper.JSArray;
import com.whl.quickjs.wrapper.JSCallFunction;
import com.whl.quickjs.wrapper.JSFunction;
import com.whl.quickjs.wrapper.QuickJSContext;

public class JSObject {
    private final QuickJSContext context;
    private final long pointer;
    private boolean isReleased;

    public JSObject(QuickJSContext context, long pointer) {
        this.context = context;
        this.pointer = pointer;
    }

    public long getPointer() {
        return this.pointer;
    }

    public QuickJSContext getContext() {
        return this.context;
    }

    public Object getProperty(String name) {
        this.checkReleased();
        return this.context.getProperty(this, name);
    }

    public void setProperty(String name, String value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, int value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, JSObject value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, boolean value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, double value) {
        this.context.setProperty(this, name, value);
    }

    public void setProperty(String name, JSCallFunction value) {
        this.context.setProperty(this, name, value);
    }

    public String getStringProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof String ? (String)value : null;
    }

    public Integer getIntProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof Integer ? (Integer)value : null;
    }

    public Boolean getBooleanProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    public Double getDoubleProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof Double ? (Double)value : null;
    }

    public JSObject getJSObjectProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSObject ? (JSObject)value : null;
    }

    public JSFunction getJSFunctionProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSFunction ? (JSFunction)value : null;
    }

    public JSArray getJSArrayProperty(String name) {
        Object value = this.getProperty(name);
        return value instanceof JSArray ? (JSArray)value : null;
    }

    public JSArray getOwnPropertyNames() {
        JSFunction getOwnPropertyNames = (JSFunction)this.context.evaluate("Object.getOwnPropertyNames");
        return (JSArray)getOwnPropertyNames.call(this);
    }

    public void release() {
        this.checkReleased();
        this.context.freeValue(this);
        this.isReleased = true;
    }

    public void dupValue() {
        this.checkReleased();
        this.context.dupValue(this);
    }

    public void freeDupValue() {
        this.checkReleased();
        this.context.freeDupValue(this);
    }

    public void hold() {
        this.context.hold(this);
    }

    public String toString() {
        this.checkReleased();
        Object formatString = this.context.evaluate("__format_string;");
        if (formatString instanceof JSFunction) {
            return (String)((JSFunction)formatString).call(this);
        }
        return super.toString();
    }

    public String stringify() {
        return this.context.stringify(this);
    }

    final void checkReleased() {
        if (this.isReleased) {
            throw new NullPointerException("This JSObject was Released, Can not call this!");
        }
    }
}

