/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.socket;

import com.netacom.base.chat.logger.Logger;
import com.netacom.lite.define.SocketState;
import com.netacom.lite.hilt.type.SocketOkHttpClient;
import com.netacom.lite.socket.listener.SocketListener;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netacom/lite/socket/OkHttpSocket;", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "coreSocket", "Lokhttp3/WebSocket;", "isLog", "", "state", "Lcom/netacom/lite/define/SocketState;", "close", "", "connect", "listener", "Lcom/netacom/lite/socket/listener/SocketListener;", "urlSocket", "", "send", "message", "showLogSocket", "netacom-sdk-lite_NetAloProdRelease"})
public class OkHttpSocket {
    @NotNull
    private final OkHttpClient okHttpClient;
    private WebSocket coreSocket;
    @NotNull
    private SocketState state;
    private final boolean isLog;

    @Inject
    public OkHttpSocket(@SocketOkHttpClient @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        this.okHttpClient = okHttpClient;
        this.state = SocketState.START.INSTANCE;
        this.isLog = true;
    }

    private final void showLogSocket(String message) {
        if (this.isLog) {
            Logger.INSTANCE.e(message, new Object[0]);
        }
    }

    public final synchronized void connect(@Nullable SocketListener listener2, @NotNull String urlSocket) {
        Intrinsics.checkNotNullParameter((Object)urlSocket, (String)"urlSocket");
        this.showLogSocket(Intrinsics.stringPlus((String)"connect:state=", (Object)this.state.getClass().getSimpleName()));
        if (Intrinsics.areEqual((Object)this.state, (Object)SocketState.CONNECTED.INSTANCE) || Intrinsics.areEqual((Object)this.state, (Object)SocketState.CONNECTING.INSTANCE)) {
            return;
        }
        this.state = SocketState.CONNECTING.INSTANCE;
        this.okHttpClient.newWebSocket(new Request.Builder().url(urlSocket).build(), new WebSocketListener(this){
            final /* synthetic */ OkHttpSocket this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super.onClosed(webSocket, code, reason);
                OkHttpSocket.access$setState$p(this.this$0, SocketState.CLOSED.INSTANCE);
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response2) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                super.onFailure(webSocket, t, response2);
                OkHttpSocket.access$setState$p(this.this$0, SocketState.FAILURE.INSTANCE);
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                super.onMessage(webSocket, text);
                OkHttpSocket.access$showLogSocket(this.this$0, text);
            }

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response2) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                super.onOpen(webSocket, response2);
                OkHttpSocket.access$setState$p(this.this$0, SocketState.CONNECTED.INSTANCE);
                OkHttpSocket.access$setCoreSocket$p(this.this$0, webSocket);
            }
        });
    }

    public final void send(@Nullable String message) {
        CharSequence charSequence;
        if (!Intrinsics.areEqual((Object)this.state, (Object)SocketState.CONNECTED.INSTANCE) || (charSequence = (CharSequence)message) == null || charSequence.length() == 0) {
            return;
        }
        this.showLogSocket(Intrinsics.stringPlus((String)"socket:send=", (Object)message));
        WebSocket webSocket = this.coreSocket;
        if (webSocket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"coreSocket");
            webSocket = null;
        }
        webSocket.send(message);
    }

    public final void close() {
        this.showLogSocket("socket:close=");
        this.state = SocketState.CLOSED.INSTANCE;
        this.okHttpClient.dispatcher().cancelAll();
        WebSocket webSocket = this.coreSocket;
        if (webSocket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"coreSocket");
            webSocket = null;
        }
        webSocket.close(1000, "Normal");
    }

    public static final /* synthetic */ void access$setState$p(OkHttpSocket $this, SocketState socketState) {
        $this.state = socketState;
    }

    public static final /* synthetic */ void access$showLogSocket(OkHttpSocket $this, String message) {
        $this.showLogSocket(message);
    }

    public static final /* synthetic */ void access$setCoreSocket$p(OkHttpSocket $this, WebSocket webSocket) {
        $this.coreSocket = webSocket;
    }
}

