/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.repository.secretChat;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.EncodeUtils;
import com.netacom.base.chat.android_utils.StringUtils;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.logger.Logger;
import com.netacom.lite.entity.socket.Secret;
import com.netacom.lite.entity.ui.group.NeGroup;
import com.netacom.lite.entity.ui.secret.NePrivateKey;
import com.netacom.lite.entity.ui.secret.NePublicKey;
import com.netacom.lite.local.prefs.PreferencesHelperImpl;
import com.netacom.lite.repository.secretChat.PartnerSecretConfig;
import com.netacom.lite.repository.secretChat.impl.RealmStatic;
import com.netacom.lite.repository.secretChat.impl.SignalProtocolStoreImpl;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.ratchet.AliceSignalProtocolParameters;
import org.whispersystems.libsignal.ratchet.BobSignalProtocolParameters;
import org.whispersystems.libsignal.ratchet.RatchetingSession;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionState;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import org.whispersystems.libsignal.util.KeyHelper;
import org.whispersystems.libsignal.util.guava.Optional;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010(\u001a\u0004\u0018\u00010'H\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010'2\b\u0010+\u001a\u0004\u0018\u00010'J\u0012\u0010,\u001a\u0004\u0018\u00010\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004J\u0014\u0010-\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'J\u0006\u00100\u001a\u00020\u0004J\u0010\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0007J\u0006\u00104\u001a\u00020\"J&\u00105\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u00106\u001a\u00020\n2\b\b\u0002\u00107\u001a\u00020\nJ\u0016\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:2\u0006\u0010%\u001a\u00020\nJ\"\u00108\u001a\u00020\u001c2\b\u0010;\u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010<\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010=\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u0004J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR6\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011`\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/netacom/lite/repository/secretChat/ChatSecretUtils;", "", "()V", "activeSecretGroupId", "", "ecKeyPair", "Lorg/whispersystems/libsignal/ecc/ECKeyPair;", "identityKeyPair", "Lorg/whispersystems/libsignal/IdentityKeyPair;", "isShowLog", "", "onetimeKeyPair", "registrationId", "", "Ljava/lang/Integer;", "secretAcceptHashMap", "Ljava/util/HashMap;", "Lcom/netacom/lite/entity/socket/Secret;", "Lkotlin/collections/HashMap;", "getSecretAcceptHashMap", "()Ljava/util/HashMap;", "setSecretAcceptHashMap", "(Ljava/util/HashMap;)V", "sessionCipher", "Lorg/whispersystems/libsignal/SessionCipher;", "store", "Lcom/netacom/lite/repository/secretChat/impl/SignalProtocolStoreImpl;", "clearActiveSecretGroupId", "", "createKeyAndSave", "preferencesHelperImpl", "Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;", "createSessionCipher", "nePublicKey", "Lcom/netacom/lite/entity/ui/secret/NePublicKey;", "partnerAddress", "Lorg/whispersystems/libsignal/SignalProtocolAddress;", "isAlice", "decrypt", "", "byteArray", "cipherText", "decryptFileInput", "cipherByteArray", "decryptTextInput", "encrypt", "plainText", "encryptFile", "getActiveSecretGroupId", "getDeviceId", "context", "Landroid/content/Context;", "getPublicKey", "handleTextInput", "isTextType", "isEncrypt", "init", "neGroup", "Lcom/netacom/lite/entity/ui/group/NeGroup;", "groupId", "loadKeyAndInit", "setActiveSecretGroupId", "showInfoKey", "nePrivateKey", "Lcom/netacom/lite/entity/ui/secret/NePrivateKey;", "netacom-sdk-lite_NetAloProdRelease"})
public final class ChatSecretUtils {
    @NotNull
    public static final ChatSecretUtils INSTANCE = new ChatSecretUtils();
    @Nullable
    private static ECKeyPair ecKeyPair;
    @Nullable
    private static IdentityKeyPair identityKeyPair;
    @Nullable
    private static ECKeyPair onetimeKeyPair;
    @Nullable
    private static Integer registrationId;
    @Nullable
    private static SignalProtocolStoreImpl store;
    @Nullable
    private static volatile SessionCipher sessionCipher;
    @NotNull
    private static volatile String activeSecretGroupId;
    private static final boolean isShowLog = true;
    @NotNull
    private static volatile HashMap<String, Secret> secretAcceptHashMap;

    private ChatSecretUtils() {
    }

    @NotNull
    public final HashMap<String, Secret> getSecretAcceptHashMap() {
        return secretAcceptHashMap;
    }

    public final void setSecretAcceptHashMap(@NotNull HashMap<String, Secret> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        secretAcceptHashMap = hashMap;
    }

    private final void createKeyAndSave(PreferencesHelperImpl preferencesHelperImpl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        NePrivateKey nePrivateKey;
        ecKeyPair = Curve.generateKeyPair();
        identityKeyPair = KeyHelper.generateIdentityKeyPair();
        onetimeKeyPair = Curve.generateKeyPair();
        registrationId = KeyHelper.generateRegistrationId((boolean)false);
        IdentityKeyPair identityKeyPair = ChatSecretUtils.identityKeyPair;
        if (identityKeyPair == null) {
            return;
        }
        Integer n = registrationId;
        if (n == null) {
            return;
        }
        store = new SignalProtocolStoreImpl(identityKeyPair, n);
        NePrivateKey $this$createKeyAndSave_u24lambda_u2d0 = nePrivateKey = new NePrivateKey(null, null, null, null, null, 0, 63, null);
        boolean bl = false;
        ECKeyPair eCKeyPair = ecKeyPair;
        if (eCKeyPair == null) {
            object4 = null;
        } else {
            ECPublicKey eCPublicKey = eCKeyPair.getPublicKey();
            object4 = eCPublicKey == null ? null : eCPublicKey.serialize();
        }
        String string2 = Base64.encodeToString((byte[])object4, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(ecKeyPair\u2026ialize(), Base64.DEFAULT)");
        $this$createKeyAndSave_u24lambda_u2d0.setPPublic(string2);
        ECKeyPair eCKeyPair2 = ecKeyPair;
        if (eCKeyPair2 == null) {
            object3 = null;
        } else {
            ECPrivateKey eCPrivateKey = eCKeyPair2.getPrivateKey();
            object3 = eCPrivateKey == null ? null : eCPrivateKey.serialize();
        }
        string2 = Base64.encodeToString((byte[])object3, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(ecKeyPair\u2026ialize(), Base64.DEFAULT)");
        $this$createKeyAndSave_u24lambda_u2d0.setPPrivate(string2);
        IdentityKeyPair identityKeyPair2 = ChatSecretUtils.identityKeyPair;
        string2 = Base64.encodeToString((byte[])((byte[])(identityKeyPair2 == null ? null : identityKeyPair2.serialize())), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(identityK\u2026ialize(), Base64.DEFAULT)");
        $this$createKeyAndSave_u24lambda_u2d0.setPIdentity(string2);
        ECKeyPair eCKeyPair3 = onetimeKeyPair;
        if (eCKeyPair3 == null) {
            object2 = null;
        } else {
            ECPublicKey eCPublicKey = eCKeyPair3.getPublicKey();
            object2 = eCPublicKey == null ? null : eCPublicKey.serialize();
        }
        string2 = Base64.encodeToString((byte[])object2, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(onetimeKe\u2026ialize(), Base64.DEFAULT)");
        $this$createKeyAndSave_u24lambda_u2d0.setPOneTimePublic(string2);
        ECKeyPair eCKeyPair4 = onetimeKeyPair;
        if (eCKeyPair4 == null) {
            object = null;
        } else {
            ECPrivateKey eCPrivateKey = eCKeyPair4.getPrivateKey();
            object = eCPrivateKey == null ? null : eCPrivateKey.serialize();
        }
        string2 = Base64.encodeToString((byte[])object, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(onetimeKe\u2026ialize(), Base64.DEFAULT)");
        $this$createKeyAndSave_u24lambda_u2d0.setPOneTimePrivate(string2);
        Integer n2 = registrationId;
        $this$createKeyAndSave_u24lambda_u2d0.setPRegisterId(n2 == null ? 0 : n2);
        preferencesHelperImpl.setSecretKey($this$createKeyAndSave_u24lambda_u2d0);
        INSTANCE.showInfoKey($this$createKeyAndSave_u24lambda_u2d0);
    }

    public final void loadKeyAndInit(@NotNull PreferencesHelperImpl preferencesHelperImpl) {
        Intrinsics.checkNotNullParameter((Object)preferencesHelperImpl, (String)"preferencesHelperImpl");
        if (store == null) {
            try {
                if (preferencesHelperImpl.getSecretKey() == null) {
                    this.createKeyAndSave(preferencesHelperImpl);
                }
                NePrivateKey nePrivateKey = preferencesHelperImpl.getSecretKey();
                if (nePrivateKey != null) {
                    NePrivateKey nePrivateKey2;
                    NePrivateKey $this$loadKeyAndInit_u24lambda_u2d1 = nePrivateKey2 = nePrivateKey;
                    boolean bl = false;
                    byte[] byArray = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPPublic(), (int)0);
                    if (byArray != null) {
                        byte[] ekpPublic = byArray;
                        byte[] byArray2 = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPPrivate(), (int)0);
                        if (byArray2 != null) {
                            byte[] ekpPrivate = byArray2;
                            byte[] byArray3 = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPIdentity(), (int)0);
                            if (byArray3 != null) {
                                byte[] ikp = byArray3;
                                byte[] byArray4 = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPOneTimePublic(), (int)0);
                                if (byArray4 != null) {
                                    byte[] opkPublic = byArray4;
                                    byte[] byArray5 = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPOneTimePrivate(), (int)0);
                                    if (byArray5 != null) {
                                        byte[] opkPrivate = byArray5;
                                        registrationId = $this$loadKeyAndInit_u24lambda_u2d1.getPRegisterId();
                                        ecKeyPair = new ECKeyPair(Curve.decodePoint((byte[])ekpPublic, (int)0), Curve.decodePrivatePoint((byte[])ekpPrivate));
                                        identityKeyPair = new IdentityKeyPair(ikp);
                                        onetimeKeyPair = new ECKeyPair(Curve.decodePoint((byte[])opkPublic, (int)0), Curve.decodePrivatePoint((byte[])opkPrivate));
                                        IdentityKeyPair identityKeyPair = ChatSecretUtils.identityKeyPair;
                                        if (identityKeyPair != null) {
                                            Integer n = registrationId;
                                            if (n != null) {
                                                int n2 = n;
                                                IdentityKeyPair identityKeyPair2 = identityKeyPair;
                                                store = new SignalProtocolStoreImpl(identityKeyPair2, n2);
                                                INSTANCE.showInfoKey($this$loadKeyAndInit_u24lambda_u2d1);
                                                Logger.INSTANCE.d("Secret Load key success", new Object[0]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException((Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private final void showInfoKey(NePrivateKey nePrivateKey) {
        Logger.INSTANCE.d(Intrinsics.stringPlus((String)"nePrivateKey==", (Object)nePrivateKey), new Object[0]);
    }

    @NotNull
    public final NePublicKey getPublicKey() {
        String string2;
        ECPublicKey eCPublicKey;
        NePublicKey nePublicKey;
        NePublicKey $this$getPublicKey_u24lambda_u2d5 = nePublicKey = new NePublicKey(null, null, null, null, null, 31, null);
        boolean bl = false;
        ECKeyPair eCKeyPair = ecKeyPair;
        if (eCKeyPair != null) {
            ECPublicKey eCPublicKey2 = eCKeyPair.getPublicKey();
            if (eCPublicKey2 != null) {
                ECPublicKey $this$getPublicKey_u24lambda_u2d5_u24lambda_u2d2 = eCPublicKey = eCPublicKey2;
                boolean bl2 = false;
                string2 = Base64.encodeToString((byte[])$this$getPublicKey_u24lambda_u2d5_u24lambda_u2d2.serialize(), (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(serialize(), Base64.DEFAULT)");
                $this$getPublicKey_u24lambda_u2d5.setPBaseKey(((Object)StringsKt.trim((CharSequence)string2)).toString());
            }
        }
        IdentityKeyPair identityKeyPair = ChatSecretUtils.identityKeyPair;
        if (identityKeyPair != null) {
            IdentityKey identityKey = identityKeyPair.getPublicKey();
            if (identityKey != null) {
                ECPublicKey $this$getPublicKey_u24lambda_u2d5_u24lambda_u2d3 = eCPublicKey = identityKey;
                boolean bl3 = false;
                string2 = Base64.encodeToString((byte[])$this$getPublicKey_u24lambda_u2d5_u24lambda_u2d3.serialize(), (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(serialize(), Base64.DEFAULT)");
                $this$getPublicKey_u24lambda_u2d5.setPIdentityKey(((Object)StringsKt.trim((CharSequence)string2)).toString());
            }
        }
        ECKeyPair eCKeyPair2 = onetimeKeyPair;
        if (eCKeyPair2 != null) {
            ECPublicKey eCPublicKey3 = eCKeyPair2.getPublicKey();
            if (eCPublicKey3 != null) {
                ECPublicKey $this$getPublicKey_u24lambda_u2d5_u24lambda_u2d4 = eCPublicKey = eCPublicKey3;
                boolean bl4 = false;
                string2 = Base64.encodeToString((byte[])$this$getPublicKey_u24lambda_u2d5_u24lambda_u2d4.serialize(), (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(serialize(), Base64.DEFAULT)");
                $this$getPublicKey_u24lambda_u2d5.setPOneTimePreKey(((Object)StringsKt.trim((CharSequence)string2)).toString());
            }
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
        $this$getPublicKey_u24lambda_u2d5.setPDeviceId(INSTANCE.getDeviceId((Context)application));
        Logger.INSTANCE.d(Intrinsics.stringPlus((String)"getPublicKey=", (Object)$this$getPublicKey_u24lambda_u2d5), new Object[0]);
        return nePublicKey;
    }

    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(context.conten\u2026ttings.Secure.ANDROID_ID)");
        return string2;
    }

    public final void init(@NotNull NeGroup neGroup, boolean isAlice) {
        Intrinsics.checkNotNullParameter((Object)neGroup, (String)"neGroup");
        RealmStatic.INSTANCE.clear();
        String string2 = neGroup.getId();
        if (string2 == null) {
            string2 = "";
        }
        activeSecretGroupId = string2;
        NePublicKey nePublicKey = neGroup.getPartnerPublicKey();
        if (nePublicKey != null) {
            NePublicKey it = nePublicKey;
            boolean bl = false;
            sessionCipher = INSTANCE.createSessionCipher(it, new SignalProtocolAddress(Intrinsics.stringPlus((String)neGroup.getId(), (Object)it.getPUin()), 1), isAlice);
            Logger.INSTANCE.d("Secret init success: publicKey = " + it + ", partnerAddress = " + neGroup.getId() + it.getPUin(), new Object[0]);
        }
    }

    public final void init(@Nullable String groupId, @Nullable NePublicKey nePublicKey, boolean isAlice) {
        SessionCipher sessionCipher;
        Object it;
        RealmStatic.INSTANCE.clear();
        NePublicKey publicKey = null;
        publicKey = nePublicKey;
        if (publicKey == null && ((Map)secretAcceptHashMap).containsKey(groupId)) {
            Secret secret = (Secret)((Map)secretAcceptHashMap).get(groupId);
            if (secret != null) {
                NePublicKey nePublicKey2;
                it = secret;
                boolean bl = false;
                NePublicKey $this$init_u24lambda_u2d8_u24lambda_u2d7 = nePublicKey2 = new NePublicKey(null, null, null, null, null, 31, null);
                boolean bl2 = false;
                $this$init_u24lambda_u2d8_u24lambda_u2d7.setPUin(((Secret)it).getUin());
                $this$init_u24lambda_u2d8_u24lambda_u2d7.setPBaseKey(((Secret)it).getBase_key());
                $this$init_u24lambda_u2d8_u24lambda_u2d7.setPIdentityKey(((Secret)it).getIdentity_key());
                $this$init_u24lambda_u2d8_u24lambda_u2d7.setPDeviceId(((Secret)it).getDevice_id());
                $this$init_u24lambda_u2d8_u24lambda_u2d7.setPOneTimePreKey(((Secret)it).getOne_time_pre_key());
                publicKey = nePublicKey2;
            }
        }
        NePublicKey nePublicKey3 = publicKey;
        if (nePublicKey3 == null) {
            sessionCipher = null;
        } else {
            it = nePublicKey3;
            boolean bl = false;
            Logger.INSTANCE.d("fast secret init success: publicKey = " + it + ", partnerAddress = " + groupId + ((NePublicKey)it).getPUin(), new Object[0]);
            sessionCipher = INSTANCE.createSessionCipher((NePublicKey)it, new SignalProtocolAddress(Intrinsics.stringPlus((String)groupId, (Object)((NePublicKey)it).getPUin()), 1), isAlice);
        }
        ChatSecretUtils.sessionCipher = sessionCipher;
    }

    @NotNull
    public final String getActiveSecretGroupId() {
        return activeSecretGroupId;
    }

    public final void setActiveSecretGroupId(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        activeSecretGroupId = groupId;
    }

    public final void clearActiveSecretGroupId() {
        activeSecretGroupId = "";
    }

    private final SessionCipher createSessionCipher(NePublicKey nePublicKey, SignalProtocolAddress partnerAddress, boolean isAlice) {
        SessionCipher sessionCipher;
        String string2 = nePublicKey.getPBaseKey();
        if (string2 == null) {
            return null;
        }
        String pEcKeyPairString = string2;
        String string3 = nePublicKey.getPIdentityKey();
        if (string3 == null) {
            return null;
        }
        String pIdentityKeyString = string3;
        String string4 = nePublicKey.getPOneTimePreKey();
        if (string4 == null) {
            return null;
        }
        String pOneTimeKeyString = string4;
        PartnerSecretConfig partnerSecretConfig = PartnerSecretConfig.Companion.init(pEcKeyPairString, pIdentityKeyString, pOneTimeKeyString);
        if (partnerSecretConfig == null) {
            sessionCipher = null;
        } else {
            PartnerSecretConfig $this$createSessionCipher_u24lambda_u2d10 = partnerSecretConfig;
            boolean bl = false;
            SignalProtocolStoreImpl signalProtocolStoreImpl = store;
            if (signalProtocolStoreImpl == null ? false : !signalProtocolStoreImpl.containsSession(partnerAddress)) {
                SessionRecord sessionRecord = new SessionRecord();
                if (isAlice) {
                    AliceSignalProtocolParameters.Builder builder = AliceSignalProtocolParameters.newBuilder();
                    builder.setOurIdentityKey(identityKeyPair);
                    builder.setOurBaseKey(ecKeyPair);
                    builder.setTheirRatchetKey($this$createSessionCipher_u24lambda_u2d10.getPEcKeyPair());
                    builder.setTheirIdentityKey($this$createSessionCipher_u24lambda_u2d10.getPIdentityKey());
                    builder.setTheirSignedPreKey($this$createSessionCipher_u24lambda_u2d10.getPEcKeyPair());
                    builder.setTheirOneTimePreKey(Optional.of((Object)$this$createSessionCipher_u24lambda_u2d10.getPOneTimeKey()));
                    RatchetingSession.initializeSession((SessionState)sessionRecord.getSessionState(), (AliceSignalProtocolParameters)builder.create());
                } else {
                    BobSignalProtocolParameters.Builder builder = BobSignalProtocolParameters.newBuilder();
                    builder.setOurIdentityKey(identityKeyPair);
                    builder.setOurSignedPreKey(ecKeyPair);
                    builder.setOurOneTimePreKey(Optional.of((Object)onetimeKeyPair));
                    builder.setOurRatchetKey(ecKeyPair);
                    builder.setTheirIdentityKey($this$createSessionCipher_u24lambda_u2d10.getPIdentityKey());
                    builder.setTheirBaseKey($this$createSessionCipher_u24lambda_u2d10.getPEcKeyPair());
                    RatchetingSession.initializeSession((SessionState)sessionRecord.getSessionState(), (BobSignalProtocolParameters)builder.create());
                }
                SignalProtocolStoreImpl signalProtocolStoreImpl2 = store;
                if (signalProtocolStoreImpl2 != null) {
                    signalProtocolStoreImpl2.saveIdentity(partnerAddress, $this$createSessionCipher_u24lambda_u2d10.getPIdentityKey());
                }
                SignalProtocolStoreImpl signalProtocolStoreImpl3 = store;
                if (signalProtocolStoreImpl3 != null) {
                    signalProtocolStoreImpl3.storeSession(partnerAddress, sessionRecord);
                }
            }
            Log.e((String)"Secret", (String)"init success");
            sessionCipher = new SessionCipher((SignalProtocolStore)store, partnerAddress);
        }
        return sessionCipher;
    }

    private final synchronized String encrypt(String plainText) {
        String string2;
        try {
            String string3;
            CiphertextMessage message;
            CiphertextMessage ciphertextMessage;
            Logger.INSTANCE.d(Intrinsics.stringPlus((String)"encrypt==", (Object)plainText), new Object[0]);
            if (sessionCipher == null) {
                Logger.INSTANCE.e("sessionCipher==null", new Object[0]);
                return plainText;
            }
            SessionCipher sessionCipher = ChatSecretUtils.sessionCipher;
            if (sessionCipher == null) {
                ciphertextMessage = null;
            } else {
                String string4 = plainText;
                ciphertextMessage = sessionCipher.encrypt((byte[])(string4 == null ? null : StringsKt.encodeToByteArray((String)string4)));
            }
            CiphertextMessage ciphertextMessage2 = message = ciphertextMessage;
            String $this$encrypt_u24lambda_u2d11 = string3 = EncodeUtils.base64Encode2String((byte[])((byte[])(ciphertextMessage2 == null ? null : ciphertextMessage2.serialize())));
            boolean bl = false;
            Logger.INSTANCE.d("Secret encrypt: " + plainText + " -> " + $this$encrypt_u24lambda_u2d11, new Object[0]);
            string2 = string3;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    private final synchronized String decrypt(SessionCipher sessionCipher, String cipherText) {
        String string2;
        Logger.INSTANCE.d("Secret decrypt: " + cipherText + "; sessionCipher= " + sessionCipher, new Object[0]);
        try {
            SessionCipher sessionCipher2 = sessionCipher;
            String string3 = string2 = sessionCipher2 == null ? null : (String)sessionCipher2.decrypt(new SignalMessage(EncodeUtils.base64Decode((String)cipherText)));
            if (string2 == null) {
                return "";
            }
            String $this$decrypt_u24lambda_u2d12 = string2 = new String((byte[])string2, Charsets.UTF_8);
            boolean bl = false;
            Logger.INSTANCE.d("Secret decrypt: " + $this$decrypt_u24lambda_u2d12 + " -> " + cipherText, new Object[0]);
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public final synchronized byte[] encryptFile(@Nullable byte[] byteArray) {
        byte[] byArray;
        try {
            Object object;
            Logger.INSTANCE.d(Intrinsics.stringPlus((String)"encrypt==", (Object)byteArray), new Object[0]);
            if (sessionCipher == null) {
                return byteArray;
            }
            if (byteArray == null) {
                return null;
            }
            SessionCipher sessionCipher = ChatSecretUtils.sessionCipher;
            if (sessionCipher == null) {
                object = null;
            } else {
                CiphertextMessage ciphertextMessage = sessionCipher.encrypt(byteArray);
                object = ciphertextMessage == null ? null : ciphertextMessage.serialize();
            }
            byArray = object;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            byArray = null;
        }
        return byArray;
    }

    private final synchronized byte[] decrypt(SessionCipher sessionCipher, byte[] byteArray) {
        byte[] byArray;
        SessionCipher sessionCipher2 = sessionCipher;
        Logger.INSTANCE.d("Secret decrypt: " + byteArray + " with remoteRegistrationId =" + (sessionCipher2 == null ? null : Integer.valueOf(sessionCipher2.getRemoteRegistrationId())), new Object[0]);
        try {
            SessionCipher sessionCipher3 = sessionCipher;
            byArray = sessionCipher3 == null ? null : sessionCipher3.decrypt(new SignalMessage(byteArray));
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            byArray = null;
        }
        return byArray;
    }

    @Nullable
    public final String handleTextInput(@Nullable String plainText, boolean isTextType, boolean isEncrypt) {
        String string2;
        if (plainText == null) {
            return null;
        }
        try {
            String text = StringUtils.INSTANCE.handleSpecialChar(plainText, isTextType, isEncrypt);
            string2 = isEncrypt ? this.encrypt(text) : text;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    public static /* synthetic */ String handleTextInput$default(ChatSecretUtils chatSecretUtils, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return chatSecretUtils.handleTextInput(string2, bl, bl2);
    }

    @Nullable
    public final String decryptTextInput(@Nullable String cipherText) {
        return this.decrypt(sessionCipher, cipherText);
    }

    @Nullable
    public final byte[] decryptFileInput(@Nullable byte[] cipherByteArray) {
        return this.decrypt(sessionCipher, cipherByteArray);
    }

    static {
        activeSecretGroupId = "";
        secretAcceptHashMap = new HashMap();
    }
}

