/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.repository.handlefile;

import com.netacom.lite.repository.handlefile.ProgressCallback;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netacom/lite/repository/handlefile/ProgressOutputStream;", "Ljava/io/OutputStream;", "stream", "listener", "Lcom/netacom/lite/repository/handlefile/ProgressCallback;", "total", "", "(Ljava/io/OutputStream;Lcom/netacom/lite/repository/handlefile/ProgressCallback;J)V", "totalWritten", "close", "", "flush", "write", "b", "", "off", "", "len", "netacom-sdk-lite_NetAloProdRelease"})
public final class ProgressOutputStream
extends OutputStream {
    @Nullable
    private final OutputStream stream;
    @NotNull
    private final ProgressCallback listener;
    private final long total;
    private long totalWritten;

    public ProgressOutputStream(@Nullable OutputStream stream, @NotNull ProgressCallback listener2, long total) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.stream = stream;
        this.listener = listener2;
        this.total = total;
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        OutputStream outputStream = this.stream;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(b, off, len);
        if (this.total < 0L) {
            this.listener.onProgressChanged(-1L, -1L, -1.0f);
            return;
        }
        ProgressOutputStream progressOutputStream = this;
        progressOutputStream.totalWritten = progressOutputStream.totalWritten + (len < b.length ? (long)len : (long)b.length);
        this.listener.onProgressChanged(this.totalWritten, this.total, (float)this.totalWritten * 1.0f / (float)this.total);
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream outputStream = this.stream;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(b);
        if (this.total < 0L) {
            this.listener.onProgressChanged(-1L, -1L, -1.0f);
            return;
        }
        ProgressOutputStream progressOutputStream = this;
        long l = progressOutputStream.totalWritten;
        progressOutputStream.totalWritten = l + 1L;
        this.listener.onProgressChanged(this.totalWritten, this.total, (float)this.totalWritten * 1.0f / (float)this.total);
    }

    @Override
    public void close() throws IOException {
        OutputStream outputStream = this.stream;
        if (outputStream != null) {
            outputStream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        OutputStream outputStream = this.stream;
        if (outputStream != null) {
            outputStream.flush();
        }
    }
}

