/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.webRTC.util;

import android.content.Context;
import android.util.Log;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.VideoCapturer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netacom/lite/webRTC/util/WebRtcUtils;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "captureToTexture", "", "createCameraCapturer", "Lorg/webrtc/VideoCapturer;", "enumerator", "Lorg/webrtc/CameraEnumerator;", "createVideoCapture", "context", "Landroid/content/Context;", "useCamera2", "netacom-sdk-lite_NetAloProdRelease"})
public final class WebRtcUtils {
    @NotNull
    public static final WebRtcUtils INSTANCE = new WebRtcUtils();
    private static final String TAG = WebRtcUtils.class.getSimpleName();

    private WebRtcUtils() {
    }

    @Nullable
    public final VideoCapturer createVideoCapture(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0) {
            VideoCapturer videoCapturer;
            VideoCapturer videoCapturer2;
            if (this.useCamera2(context)) {
                Log.d((String)TAG, (String)"Creating capturer using camera2 API.");
                videoCapturer2 = this.createCameraCapturer((CameraEnumerator)new Camera2Enumerator(context));
            } else {
                Log.d((String)TAG, (String)"Creating capturer using camera1 API.");
                videoCapturer2 = videoCapturer = this.createCameraCapturer((CameraEnumerator)new Camera1Enumerator(this.captureToTexture()));
            }
            if (videoCapturer == null) {
                Log.e((String)TAG, (String)"Failed to open camera");
                return null;
            }
            return videoCapturer;
        }
        return null;
    }

    private final boolean useCamera2(Context context) {
        return Camera2Enumerator.isSupported((Context)context);
    }

    private final boolean captureToTexture() {
        return false;
    }

    private final VideoCapturer createCameraCapturer(CameraEnumerator enumerator) {
        VideoCapturer videoCapturer;
        String[] deviceNames = enumerator.getDeviceNames();
        Log.d((String)TAG, (String)"Looking for front facing cameras.");
        Intrinsics.checkNotNullExpressionValue((Object)deviceNames, (String)"deviceNames");
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) continue;
            Log.d((String)TAG, (String)"Creating front facing camera capturer.");
            videoCapturer = (VideoCapturer)enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        Log.d((String)TAG, (String)"Looking for other cameras.");
        for (String deviceName : deviceNames) {
            if (enumerator.isFrontFacing(deviceName)) continue;
            Log.d((String)TAG, (String)"Creating other camera capturer.");
            videoCapturer = (VideoCapturer)enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        return null;
    }
}

