/*
 * Decompiled with CFR 0.152.
 */
import com.netacom.base.chat.android_utils.ConvertUtils;
import com.netacom.lite.network.model.request.SessionRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"LAuthUtils;", "", "()V", "generateContentString", "", "appID", "", "authKey", "nonce", "timestamp", "generateGetAppSessionJson", "Lcom/netacom/lite/network/model/request/SessionRequest;", "applicationId", "generateSignature", "content", "key", "netacom-sdk-lite_NetAloDevRelease"})
public final class AuthUtils {
    @NotNull
    public static final AuthUtils INSTANCE = new AuthUtils();

    private AuthUtils() {
    }

    @NotNull
    public final SessionRequest generateGetAppSessionJson(int applicationId, @NotNull String authKey) {
        Intrinsics.checkNotNullParameter((Object)authKey, (String)"authKey");
        int timeStamp = (int)(System.currentTimeMillis() / (long)1000);
        int nonce = RangesKt.random((IntRange)new IntRange(10000, 99999), (Random)((Random)Random.Default));
        return new SessionRequest(applicationId, authKey, timeStamp, nonce, this.generateSignature(this.generateContentString(applicationId, authKey, nonce, timeStamp), authKey));
    }

    private final String generateSignature(String content, String key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object = key.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).getBytes(charset)");
            byte[] keyBytes = object;
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, mac.getAlgorithm());
            mac.init(signingKey);
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            byte[] byArray = content.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] rawHMac = mac.doFinal(byArray);
            object = ConvertUtils.bytes2HexString((byte[])rawHMac, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bytes2HexString(rawHMac, false)");
            return object;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
    }

    private final String generateContentString(int appID, String authKey, int nonce, int timestamp) {
        return "application_id=" + appID + "&auth_key=" + authKey + "&nonce=" + nonce + "&timestamp=" + timestamp;
    }
}

