/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.repository.secretChat;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.EncodeUtils;
import com.netacom.base.chat.android_utils.StringUtils;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.logger.Logger;
import com.netacom.lite.entity.socket.Secret;
import com.netacom.lite.entity.ui.group.NeGroup;
import com.netacom.lite.entity.ui.secret.NePrivateKey;
import com.netacom.lite.entity.ui.secret.NePublicKey;
import com.netacom.lite.local.prefs.PreferencesHelperImpl;
import com.netacom.lite.repository.secretChat.PartnerSecretConfig;
import com.netacom.lite.repository.secretChat.impl.RealmStatic;
import com.netacom.lite.repository.secretChat.impl.SignalProtocolStoreImpl;
import java.nio.charset.Charset;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.ratchet.AliceSignalProtocolParameters;
import org.whispersystems.libsignal.ratchet.BobSignalProtocolParameters;
import org.whispersystems.libsignal.ratchet.RatchetingSession;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionState;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import org.whispersystems.libsignal.util.KeyHelper;
import org.whispersystems.libsignal.util.guava.Optional;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010(\u001a\u0004\u0018\u00010'H\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010'2\b\u0010+\u001a\u0004\u0018\u00010'J\u0012\u0010,\u001a\u0004\u0018\u00010\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004J\u0014\u0010-\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'J\u0006\u00100\u001a\u00020\u0004J\u0010\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0007J\u0006\u00104\u001a\u00020\"J&\u00105\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u00106\u001a\u00020\n2\b\b\u0002\u00107\u001a\u00020\nJ\u0016\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:2\u0006\u0010%\u001a\u00020\nJ\"\u00108\u001a\u00020\u001c2\b\u0010;\u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010<\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010=\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u0004J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR6\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011`\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/netacom/lite/repository/secretChat/ChatSecretUtils;", "", "()V", "activeSecretGroupId", "", "ecKeyPair", "Lorg/whispersystems/libsignal/ecc/ECKeyPair;", "identityKeyPair", "Lorg/whispersystems/libsignal/IdentityKeyPair;", "isShowLog", "", "onetimeKeyPair", "registrationId", "", "Ljava/lang/Integer;", "secretAcceptHashMap", "Ljava/util/HashMap;", "Lcom/netacom/lite/entity/socket/Secret;", "Lkotlin/collections/HashMap;", "getSecretAcceptHashMap", "()Ljava/util/HashMap;", "setSecretAcceptHashMap", "(Ljava/util/HashMap;)V", "sessionCipher", "Lorg/whispersystems/libsignal/SessionCipher;", "store", "Lcom/netacom/lite/repository/secretChat/impl/SignalProtocolStoreImpl;", "clearActiveSecretGroupId", "", "createKeyAndSave", "preferencesHelperImpl", "Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;", "createSessionCipher", "nePublicKey", "Lcom/netacom/lite/entity/ui/secret/NePublicKey;", "partnerAddress", "Lorg/whispersystems/libsignal/SignalProtocolAddress;", "isAlice", "decrypt", "", "byteArray", "cipherText", "decryptFileInput", "cipherByteArray", "decryptTextInput", "encrypt", "plainText", "encryptFile", "getActiveSecretGroupId", "getDeviceId", "context", "Landroid/content/Context;", "getPublicKey", "handleTextInput", "isTextType", "isEncrypt", "init", "neGroup", "Lcom/netacom/lite/entity/ui/group/NeGroup;", "groupId", "loadKeyAndInit", "setActiveSecretGroupId", "showInfoKey", "nePrivateKey", "Lcom/netacom/lite/entity/ui/secret/NePrivateKey;", "netacom-sdk-lite_NetAloDevRelease"})
public final class ChatSecretUtils {
    private static ECKeyPair ecKeyPair;
    private static IdentityKeyPair identityKeyPair;
    private static ECKeyPair onetimeKeyPair;
    private static Integer registrationId;
    private static SignalProtocolStoreImpl store;
    private static volatile SessionCipher sessionCipher;
    private static volatile String activeSecretGroupId;
    private static final boolean isShowLog = true;
    @NotNull
    private static volatile HashMap<String, Secret> secretAcceptHashMap;
    @NotNull
    public static final ChatSecretUtils INSTANCE;

    @NotNull
    public final HashMap<String, Secret> getSecretAcceptHashMap() {
        return secretAcceptHashMap;
    }

    public final void setSecretAcceptHashMap(@NotNull HashMap<String, Secret> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        secretAcceptHashMap = hashMap;
    }

    private final void createKeyAndSave(PreferencesHelperImpl preferencesHelperImpl) {
        ecKeyPair = Curve.generateKeyPair();
        identityKeyPair = KeyHelper.generateIdentityKeyPair();
        onetimeKeyPair = Curve.generateKeyPair();
        registrationId = KeyHelper.generateRegistrationId((boolean)false);
        IdentityKeyPair identityKeyPair = ChatSecretUtils.identityKeyPair;
        if (identityKeyPair == null) {
            return;
        }
        Integer n = registrationId;
        if (n == null) {
            return;
        }
        store = new SignalProtocolStoreImpl(identityKeyPair, n);
        NePrivateKey nePrivateKey = new NePrivateKey(null, null, null, null, null, 0, 63, null);
        boolean bl = false;
        boolean bl2 = false;
        NePrivateKey $this$apply = nePrivateKey;
        boolean bl3 = false;
        ECKeyPair eCKeyPair = ecKeyPair;
        String string2 = Base64.encodeToString((byte[])(eCKeyPair != null && (eCKeyPair = eCKeyPair.getPublicKey()) != null ? eCKeyPair.serialize() : null), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Base64.encodeToString(ec\u2026ialize(), Base64.DEFAULT)");
        $this$apply.setPPublic(string2);
        ECKeyPair eCKeyPair2 = ecKeyPair;
        String string3 = Base64.encodeToString((byte[])(eCKeyPair2 != null && (eCKeyPair2 = eCKeyPair2.getPrivateKey()) != null ? eCKeyPair2.serialize() : null), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.encodeToString(ec\u2026ialize(), Base64.DEFAULT)");
        $this$apply.setPPrivate(string3);
        IdentityKeyPair identityKeyPair2 = ChatSecretUtils.identityKeyPair;
        String string4 = Base64.encodeToString((byte[])((byte[])(identityKeyPair2 != null ? identityKeyPair2.serialize() : null)), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Base64.encodeToString(id\u2026ialize(), Base64.DEFAULT)");
        $this$apply.setPIdentity(string4);
        ECKeyPair eCKeyPair3 = onetimeKeyPair;
        String string5 = Base64.encodeToString((byte[])(eCKeyPair3 != null && (eCKeyPair3 = eCKeyPair3.getPublicKey()) != null ? eCKeyPair3.serialize() : null), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"Base64.encodeToString(on\u2026ialize(), Base64.DEFAULT)");
        $this$apply.setPOneTimePublic(string5);
        ECKeyPair eCKeyPair4 = onetimeKeyPair;
        String string6 = Base64.encodeToString((byte[])(eCKeyPair4 != null && (eCKeyPair4 = eCKeyPair4.getPrivateKey()) != null ? eCKeyPair4.serialize() : null), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"Base64.encodeToString(on\u2026ialize(), Base64.DEFAULT)");
        $this$apply.setPOneTimePrivate(string6);
        Integer n2 = registrationId;
        $this$apply.setPRegisterId(n2 != null ? n2 : 0);
        preferencesHelperImpl.setSecretKey($this$apply);
        INSTANCE.showInfoKey($this$apply);
    }

    public final void loadKeyAndInit(@NotNull PreferencesHelperImpl preferencesHelperImpl) {
        Intrinsics.checkNotNullParameter((Object)preferencesHelperImpl, (String)"preferencesHelperImpl");
        if (store == null) {
            try {
                if (preferencesHelperImpl.getSecretKey() == null) {
                    this.createKeyAndSave(preferencesHelperImpl);
                }
                NePrivateKey nePrivateKey = preferencesHelperImpl.getSecretKey();
                if (nePrivateKey != null) {
                    NePrivateKey nePrivateKey2 = nePrivateKey;
                    boolean bl = false;
                    boolean bl2 = false;
                    NePrivateKey $this$apply = nePrivateKey2;
                    boolean bl3 = false;
                    byte[] byArray = Base64.decode((String)$this$apply.getPPublic(), (int)0);
                    if (byArray == null) {
                    } else {
                        byte[] ekpPublic = byArray;
                        byte[] byArray2 = Base64.decode((String)$this$apply.getPPrivate(), (int)0);
                        if (byArray2 == null) {
                        } else {
                            byte[] ekpPrivate = byArray2;
                            byte[] byArray3 = Base64.decode((String)$this$apply.getPIdentity(), (int)0);
                            if (byArray3 == null) {
                            } else {
                                byte[] ikp = byArray3;
                                byte[] byArray4 = Base64.decode((String)$this$apply.getPOneTimePublic(), (int)0);
                                if (byArray4 == null) {
                                } else {
                                    byte[] opkPublic = byArray4;
                                    byte[] byArray5 = Base64.decode((String)$this$apply.getPOneTimePrivate(), (int)0);
                                    if (byArray5 == null) {
                                    } else {
                                        byte[] opkPrivate = byArray5;
                                        registrationId = $this$apply.getPRegisterId();
                                        ecKeyPair = new ECKeyPair(Curve.decodePoint((byte[])ekpPublic, (int)0), Curve.decodePrivatePoint((byte[])ekpPrivate));
                                        identityKeyPair = new IdentityKeyPair(ikp);
                                        onetimeKeyPair = new ECKeyPair(Curve.decodePoint((byte[])opkPublic, (int)0), Curve.decodePrivatePoint((byte[])opkPrivate));
                                        IdentityKeyPair identityKeyPair = ChatSecretUtils.identityKeyPair;
                                        if (identityKeyPair == null) {
                                        } else {
                                            Integer n = registrationId;
                                            if (n == null) {
                                            } else {
                                                int n2 = n;
                                                IdentityKeyPair identityKeyPair2 = identityKeyPair;
                                                store = new SignalProtocolStoreImpl(identityKeyPair2, n2);
                                                INSTANCE.showInfoKey($this$apply);
                                                Logger.INSTANCE.d("Secret Load key success", new Object[0]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException((Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private final void showInfoKey(NePrivateKey nePrivateKey) {
        Logger.INSTANCE.d("nePrivateKey==" + nePrivateKey, new Object[0]);
    }

    @NotNull
    public final NePublicKey getPublicKey() {
        ECKeyPair eCKeyPair;
        IdentityKeyPair identityKeyPair;
        boolean bl;
        String string2;
        ECKeyPair $this$apply;
        boolean bl2;
        boolean bl3;
        ECKeyPair eCKeyPair2;
        NePublicKey nePublicKey = new NePublicKey(null, null, null, null, null, 31, null);
        boolean bl4 = false;
        boolean bl5 = false;
        NePublicKey $this$apply2 = nePublicKey;
        boolean bl6 = false;
        ECKeyPair eCKeyPair3 = ecKeyPair;
        if (eCKeyPair3 != null && (eCKeyPair3 = eCKeyPair3.getPublicKey()) != null) {
            eCKeyPair2 = eCKeyPair3;
            bl3 = false;
            bl2 = false;
            $this$apply = eCKeyPair2;
            boolean bl7 = false;
            String string3 = Base64.encodeToString((byte[])$this$apply.serialize(), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.encodeToString(serialize(), Base64.DEFAULT)");
            string2 = string3;
            bl = false;
            String string4 = string2;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            $this$apply2.setPBaseKey(((Object)StringsKt.trim((CharSequence)string4)).toString());
        }
        if ((identityKeyPair = ChatSecretUtils.identityKeyPair) != null && (identityKeyPair = identityKeyPair.getPublicKey()) != null) {
            eCKeyPair2 = identityKeyPair;
            bl3 = false;
            bl2 = false;
            $this$apply = eCKeyPair2;
            boolean bl8 = false;
            String string5 = Base64.encodeToString((byte[])$this$apply.serialize(), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"Base64.encodeToString(serialize(), Base64.DEFAULT)");
            string2 = string5;
            bl = false;
            String string6 = string2;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            $this$apply2.setPIdentityKey(((Object)StringsKt.trim((CharSequence)string6)).toString());
        }
        if ((eCKeyPair = onetimeKeyPair) != null && (eCKeyPair = eCKeyPair.getPublicKey()) != null) {
            eCKeyPair2 = eCKeyPair;
            bl3 = false;
            bl2 = false;
            $this$apply = eCKeyPair2;
            boolean bl9 = false;
            String string7 = Base64.encodeToString((byte[])$this$apply.serialize(), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"Base64.encodeToString(serialize(), Base64.DEFAULT)");
            string2 = string7;
            bl = false;
            String string8 = string2;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            $this$apply2.setPOneTimePreKey(((Object)StringsKt.trim((CharSequence)string8)).toString());
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"Utils.getApp()");
        $this$apply2.setPDeviceId(INSTANCE.getDeviceId((Context)application));
        Logger.INSTANCE.d("getPublicKey=" + $this$apply2, new Object[0]);
        return nePublicKey;
    }

    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Settings.Secure.getStrin\u2026ttings.Secure.ANDROID_ID)");
        return string2;
    }

    public final void init(@NotNull NeGroup neGroup, boolean isAlice) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)neGroup, (String)"neGroup");
            RealmStatic.INSTANCE.clear();
            String string2 = neGroup.getId();
            if (string2 == null) {
                string2 = "";
            }
            activeSecretGroupId = string2;
            NePublicKey nePublicKey = neGroup.getPartnerPublicKey();
            if (nePublicKey == null) break block1;
            NePublicKey nePublicKey2 = nePublicKey;
            boolean bl = false;
            boolean bl2 = false;
            NePublicKey it = nePublicKey2;
            boolean bl3 = false;
            sessionCipher = INSTANCE.createSessionCipher(it, new SignalProtocolAddress(neGroup.getId() + it.getPUin(), 1), isAlice);
            Logger.INSTANCE.d("Secret init success: sessionCipher = " + sessionCipher + ", partnerAddress = " + neGroup.getId() + it.getPUin(), new Object[0]);
        }
    }

    public final void init(@Nullable String groupId, @Nullable NePublicKey nePublicKey, boolean isAlice) {
        SessionCipher sessionCipher;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        RealmStatic.INSTANCE.clear();
        NePublicKey publicKey = nePublicKey;
        if (publicKey == null) {
            object = secretAcceptHashMap;
            bl2 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (object2.containsKey(groupId)) {
                object = secretAcceptHashMap;
                bl2 = false;
                Secret secret = (Secret)object.get(groupId);
                if (secret != null) {
                    object = secret;
                    bl2 = false;
                    bl = false;
                    it = object;
                    boolean bl3 = false;
                    NePublicKey nePublicKey2 = new NePublicKey(null, null, null, null, null, 31, null);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    NePublicKey $this$apply = nePublicKey2;
                    boolean bl6 = false;
                    $this$apply.setPUin(((Secret)it).getUin());
                    $this$apply.setPBaseKey(((Secret)it).getBase_key());
                    $this$apply.setPIdentityKey(((Secret)it).getIdentity_key());
                    $this$apply.setPDeviceId(((Secret)it).getDevice_id());
                    $this$apply.setPOneTimePreKey(((Secret)it).getOne_time_pre_key());
                    Unit unit = Unit.INSTANCE;
                    publicKey = nePublicKey2;
                }
            }
        }
        NePublicKey nePublicKey3 = publicKey;
        if (nePublicKey3 != null) {
            object = nePublicKey3;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl7 = false;
            Logger.INSTANCE.d("fast secret init success: sessionCipher = " + ChatSecretUtils.sessionCipher + ", partnerAddress = " + groupId + ((NePublicKey)it).getPUin(), new Object[0]);
            sessionCipher = INSTANCE.createSessionCipher((NePublicKey)it, new SignalProtocolAddress(groupId + ((NePublicKey)it).getPUin(), 1), isAlice);
        } else {
            sessionCipher = null;
        }
        ChatSecretUtils.sessionCipher = sessionCipher;
    }

    @NotNull
    public final String getActiveSecretGroupId() {
        return activeSecretGroupId;
    }

    public final void setActiveSecretGroupId(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        activeSecretGroupId = groupId;
    }

    public final void clearActiveSecretGroupId() {
        activeSecretGroupId = "";
    }

    private final SessionCipher createSessionCipher(NePublicKey nePublicKey, SignalProtocolAddress partnerAddress, boolean isAlice) {
        SessionCipher sessionCipher;
        String string2 = nePublicKey.getPBaseKey();
        if (string2 == null) {
            return null;
        }
        String pEcKeyPairString = string2;
        String string3 = nePublicKey.getPIdentityKey();
        if (string3 == null) {
            return null;
        }
        String pIdentityKeyString = string3;
        String string4 = nePublicKey.getPOneTimePreKey();
        if (string4 == null) {
            return null;
        }
        String pOneTimeKeyString = string4;
        PartnerSecretConfig partnerSecretConfig = PartnerSecretConfig.Companion.init(pEcKeyPairString, pIdentityKeyString, pOneTimeKeyString);
        if (partnerSecretConfig != null) {
            PartnerSecretConfig partnerSecretConfig2 = partnerSecretConfig;
            boolean bl = false;
            boolean bl2 = false;
            PartnerSecretConfig $this$run = partnerSecretConfig2;
            boolean bl3 = false;
            SignalProtocolStoreImpl signalProtocolStoreImpl = store;
            if (signalProtocolStoreImpl != null) {
                if (!signalProtocolStoreImpl.containsSession(partnerAddress)) {
                    SessionRecord sessionRecord = new SessionRecord();
                    if (isAlice) {
                        AliceSignalProtocolParameters.Builder builder = AliceSignalProtocolParameters.newBuilder();
                        builder.setOurIdentityKey(identityKeyPair);
                        builder.setOurBaseKey(ecKeyPair);
                        builder.setTheirRatchetKey($this$run.getPEcKeyPair());
                        builder.setTheirIdentityKey($this$run.getPIdentityKey());
                        builder.setTheirSignedPreKey($this$run.getPEcKeyPair());
                        builder.setTheirOneTimePreKey(Optional.of((Object)$this$run.getPOneTimeKey()));
                        RatchetingSession.initializeSession((SessionState)sessionRecord.getSessionState(), (AliceSignalProtocolParameters)builder.create());
                    } else {
                        BobSignalProtocolParameters.Builder builder = BobSignalProtocolParameters.newBuilder();
                        builder.setOurIdentityKey(identityKeyPair);
                        builder.setOurSignedPreKey(ecKeyPair);
                        builder.setOurOneTimePreKey(Optional.of((Object)onetimeKeyPair));
                        builder.setOurRatchetKey(ecKeyPair);
                        builder.setTheirIdentityKey($this$run.getPIdentityKey());
                        builder.setTheirBaseKey($this$run.getPEcKeyPair());
                        RatchetingSession.initializeSession((SessionState)sessionRecord.getSessionState(), (BobSignalProtocolParameters)builder.create());
                    }
                    SignalProtocolStoreImpl signalProtocolStoreImpl2 = store;
                    if (signalProtocolStoreImpl2 != null) {
                        signalProtocolStoreImpl2.saveIdentity(partnerAddress, $this$run.getPIdentityKey());
                    }
                    SignalProtocolStoreImpl signalProtocolStoreImpl3 = store;
                    if (signalProtocolStoreImpl3 != null) {
                        signalProtocolStoreImpl3.storeSession(partnerAddress, sessionRecord);
                    }
                }
            }
            Log.e((String)"Secret", (String)"init success");
            sessionCipher = new SessionCipher((SignalProtocolStore)store, partnerAddress);
        } else {
            sessionCipher = null;
        }
        return sessionCipher;
    }

    private final synchronized String encrypt(String plainText) {
        String string2;
        try {
            CiphertextMessage message;
            CiphertextMessage ciphertextMessage;
            Logger.INSTANCE.d("encrypt==" + plainText, new Object[0]);
            if (sessionCipher == null) {
                Logger.INSTANCE.e("sessionCipher==null", new Object[0]);
                return plainText;
            }
            SessionCipher sessionCipher = ChatSecretUtils.sessionCipher;
            if (sessionCipher != null) {
                String string3 = plainText;
                ciphertextMessage = sessionCipher.encrypt((byte[])(string3 != null ? StringsKt.encodeToByteArray((String)string3) : null));
            } else {
                ciphertextMessage = null;
            }
            CiphertextMessage ciphertextMessage2 = message = ciphertextMessage;
            String string4 = EncodeUtils.base64Encode2String((byte[])((byte[])(ciphertextMessage2 != null ? ciphertextMessage2.serialize() : null)));
            boolean bl = false;
            boolean bl2 = false;
            String $this$apply = string4;
            boolean bl3 = false;
            Logger.INSTANCE.d("Secret encrypt: " + plainText + " -> " + $this$apply, new Object[0]);
            string2 = string4;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    private final synchronized String decrypt(SessionCipher sessionCipher, String cipherText) {
        String string2;
        Logger.INSTANCE.d("Secret decrypt: " + cipherText + "; sessionCipher= " + sessionCipher, new Object[0]);
        try {
            Object object;
            block5: {
                block4: {
                    object = sessionCipher;
                    if (object == null) break block4;
                    byte[] byArray = object.decrypt(new SignalMessage(EncodeUtils.base64Decode((String)cipherText)));
                    object = byArray;
                    if (byArray != null) break block5;
                }
                return "";
            }
            string2 = object;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            string2 = new String((byte[])string2, charset);
            boolean bl2 = false;
            bl = false;
            String $this$apply = string2;
            boolean bl3 = false;
            Logger.INSTANCE.d("Secret decrypt: " + $this$apply + " -> " + cipherText, new Object[0]);
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public final synchronized byte[] encryptFile(@Nullable byte[] byteArray) {
        byte[] byArray;
        try {
            Logger.INSTANCE.d("encrypt==" + byteArray, new Object[0]);
            if (sessionCipher == null) {
                return byteArray;
            }
            if (byteArray == null) {
                return null;
            }
            SessionCipher sessionCipher = ChatSecretUtils.sessionCipher;
            byArray = sessionCipher != null && (sessionCipher = sessionCipher.encrypt(byteArray)) != null ? sessionCipher.serialize() : null;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            byArray = null;
        }
        return byArray;
    }

    private final synchronized byte[] decrypt(SessionCipher sessionCipher, byte[] byteArray) {
        byte[] byArray;
        SessionCipher sessionCipher2 = sessionCipher;
        Logger.INSTANCE.d("Secret decrypt: " + byteArray + " with remoteRegistrationId =" + (sessionCipher2 != null ? Integer.valueOf(sessionCipher2.getRemoteRegistrationId()) : null), new Object[0]);
        try {
            SessionCipher sessionCipher3 = sessionCipher;
            byArray = sessionCipher3 != null ? sessionCipher3.decrypt(new SignalMessage(byteArray)) : null;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            byArray = null;
        }
        return byArray;
    }

    @Nullable
    public final String handleTextInput(@Nullable String plainText, boolean isTextType, boolean isEncrypt) {
        String string2;
        if (plainText == null) {
            return null;
        }
        try {
            String text = StringUtils.INSTANCE.handleSpecialChar(plainText, isTextType);
            string2 = isEncrypt ? this.encrypt(text) : text;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    public static /* synthetic */ String handleTextInput$default(ChatSecretUtils chatSecretUtils, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return chatSecretUtils.handleTextInput(string2, bl, bl2);
    }

    @Nullable
    public final String decryptTextInput(@Nullable String cipherText) {
        return this.decrypt(sessionCipher, cipherText);
    }

    @Nullable
    public final byte[] decryptFileInput(@Nullable byte[] cipherByteArray) {
        return this.decrypt(sessionCipher, cipherByteArray);
    }

    private ChatSecretUtils() {
    }

    static {
        ChatSecretUtils chatSecretUtils;
        INSTANCE = chatSecretUtils = new ChatSecretUtils();
        activeSecretGroupId = "";
        secretAcceptHashMap = new HashMap();
    }
}

