/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.method.LinkMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.swiperefreshlayout.widget.CircularProgressDrawable;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import com.netacom.base.chat.R;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.base.chat.util.MyClickableSpan;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/netacom/base/chat/util/ViewUtil;", "", "()V", "Companion", "netacom-base-chat_NetAloProdRelease"})
public final class ViewUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final CircularProgressDrawable getCircleProgressDrawable(@NotNull Context context, float strokeWidthValue, float centerRadiusValue, @ColorRes int color2) {
        return Companion.getCircleProgressDrawable(context, strokeWidthValue, centerRadiusValue, color2);
    }

    @JvmStatic
    public static final void setTextClickable(@NotNull TextView view, int textRes, int clickableTextRes, @Nullable Function0<Unit> callback2) {
        Companion.setTextClickable(view, textRes, clickableTextRes, callback2);
    }

    @JvmStatic
    public static final void setTextClickable(@NotNull TextView view, @StringRes int textRes, @StringRes int clickableTextRes, @StringRes int clickableTextRes2, @Nullable Function0<Unit> callback2, @Nullable Function0<Unit> callback22) {
        Companion.setTextClickable(view, textRes, clickableTextRes, clickableTextRes2, callback2, callback22);
    }

    @JvmStatic
    public static final void setTextClickable(@NotNull TextView view, @NotNull String text, @NotNull String clickableText, @NotNull String clickableText2, @Nullable Function0<Unit> callback2, @Nullable Function0<Unit> callback22) {
        Companion.setTextClickable(view, text, clickableText, clickableText2, callback2, callback22);
    }

    @JvmStatic
    public static final void formatTextValue(@NotNull TextView view, @StringRes int labelRes, @Nullable String value, @ColorRes int colorRes) {
        Companion.formatTextValue(view, labelRes, value, colorRes);
    }

    @JvmStatic
    public static final void disableCollapseToolbar(@NotNull CollapsingToolbarLayout ctlCollapse, boolean isDisable) {
        Companion.disableCollapseToolbar(ctlCollapse, isDisable);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J.\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\rH\u0007J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0003\u0010\u0018\u001a\u00020\rH\u0007J0\u0010\u0019\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0007JN\u0010\u0019\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u001a\u001a\u00020\r2\b\b\u0001\u0010\u001b\u001a\u00020\r2\b\b\u0001\u0010\u001e\u001a\u00020\r2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0007JH\u0010\u0019\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0007\u00a8\u0006#"}, d2={"Lcom/netacom/base/chat/util/ViewUtil$Companion;", "", "()V", "disableCollapseToolbar", "", "ctlCollapse", "Lcom/google/android/material/appbar/CollapsingToolbarLayout;", "isDisable", "", "formatTextValue", "view", "Landroid/widget/TextView;", "labelRes", "", "value", "", "colorRes", "getCircleProgressDrawable", "Landroidx/swiperefreshlayout/widget/CircularProgressDrawable;", "context", "Landroid/content/Context;", "strokeWidthValue", "", "centerRadiusValue", "color", "setTextClickable", "textRes", "clickableTextRes", "callback", "Lkotlin/Function0;", "clickableTextRes2", "callback2", "text", "clickableText", "clickableText2", "netacom-base-chat_NetAloProdRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CircularProgressDrawable getCircleProgressDrawable(@NotNull Context context, float strokeWidthValue, float centerRadiusValue, @ColorRes int color2) {
            CircularProgressDrawable circularProgressDrawable;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CircularProgressDrawable $this$getCircleProgressDrawable_u24lambda_u2d0 = circularProgressDrawable = new CircularProgressDrawable(context);
            boolean bl = false;
            $this$getCircleProgressDrawable_u24lambda_u2d0.setStrokeWidth(strokeWidthValue);
            $this$getCircleProgressDrawable_u24lambda_u2d0.setCenterRadius(centerRadiusValue);
            $this$getCircleProgressDrawable_u24lambda_u2d0.setColorFilter((ColorFilter)new PorterDuffColorFilter(ExtensionsUtilsKt.getThemeColor(color2), PorterDuff.Mode.SRC_IN));
            return circularProgressDrawable;
        }

        public static /* synthetic */ CircularProgressDrawable getCircleProgressDrawable$default(Companion companion, Context context, float f, float f2, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                f = context.getResources().getDimensionPixelOffset(R.dimen.dp_1);
            }
            if ((n2 & 4) != 0) {
                f2 = context.getResources().getDimensionPixelOffset(R.dimen.dp_10);
            }
            if ((n2 & 8) != 0) {
                n = R.color.colorPrimaryDark;
            }
            return companion.getCircleProgressDrawable(context, f, f2, n);
        }

        @JvmStatic
        public final void setTextClickable(@NotNull TextView view, int textRes, int clickableTextRes, @Nullable Function0<Unit> callback2) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            String string2 = view.getContext().getString(clickableTextRes);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.context.getString(clickableTextRes)");
            String clickableText = string2;
            SpannableString ss = new SpannableString((CharSequence)view.getContext().getString(textRes));
            view.setText((CharSequence)ss);
            int start = StringsKt.indexOf$default((CharSequence)((CharSequence)ss), (String)clickableText, (int)0, (boolean)false, (int)6, null);
            if (start < 0 || start + clickableText.length() >= ss.length()) {
                return;
            }
            ss.setSpan((Object)new MyClickableSpan(callback2){
                final /* synthetic */ Function0<Unit> $callback;
                {
                    this.$callback = $callback;
                }

                public void onClick(@NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Function0<Unit> function0 = this.$callback;
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            }, start, start + clickableText.length(), 33);
            view.setText((CharSequence)ss);
            view.setMovementMethod(LinkMovementMethod.getInstance());
        }

        @JvmStatic
        public final void setTextClickable(@NotNull TextView view, @StringRes int textRes, @StringRes int clickableTextRes, @StringRes int clickableTextRes2, @Nullable Function0<Unit> callback2, @Nullable Function0<Unit> callback22) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            String string2 = view.getContext().getString(textRes);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.context.getString(textRes)");
            String string3 = string2;
            string2 = view.getContext().getString(clickableTextRes);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.context.getString(clickableTextRes)");
            String string4 = string2;
            string2 = view.getContext().getString(clickableTextRes2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.context.getString(clickableTextRes2)");
            this.setTextClickable(view, string3, string4, string2, callback2, callback22);
        }

        @JvmStatic
        public final void setTextClickable(@NotNull TextView view, @NotNull String text, @NotNull String clickableText, @NotNull String clickableText2, @Nullable Function0<Unit> callback2, @Nullable Function0<Unit> callback22) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)clickableText, (String)"clickableText");
            Intrinsics.checkNotNullParameter((Object)clickableText2, (String)"clickableText2");
            SpannableStringBuilder spannableString = new SpannableStringBuilder((CharSequence)text);
            int length = spannableString.length();
            int start = StringsKt.indexOf$default((CharSequence)((CharSequence)spannableString), (String)clickableText, (int)0, (boolean)false, (int)6, null);
            if (start < 0 || start + clickableText.length() > length) {
                return;
            }
            spannableString.setSpan((Object)new MyClickableSpan(callback2){
                final /* synthetic */ Function0<Unit> $callback;
                {
                    this.$callback = $callback;
                }

                public void onClick(@NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Function0<Unit> function0 = this.$callback;
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            }, start, start + clickableText.length(), 33);
            int start2 = StringsKt.indexOf$default((CharSequence)((CharSequence)spannableString), (String)clickableText2, (int)0, (boolean)false, (int)6, null);
            if (start2 < 0 || start2 + clickableText2.length() > length) {
                return;
            }
            spannableString.setSpan((Object)new MyClickableSpan(callback22){
                final /* synthetic */ Function0<Unit> $callback2;
                {
                    this.$callback2 = $callback2;
                }

                public void onClick(@NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Function0<Unit> function0 = this.$callback2;
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            }, start2, start2 + clickableText2.length(), 33);
            view.setText((CharSequence)spannableString);
            view.setMovementMethod(LinkMovementMethod.getInstance());
        }

        @JvmStatic
        public final void formatTextValue(@NotNull TextView view, @StringRes int labelRes, @Nullable String value, @ColorRes int colorRes) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Object[] objectArray = (Object[])value;
            if (objectArray == null || objectArray.length() == 0) {
                objectArray = new Object[]{""};
                view.setText((CharSequence)view.getContext().getString(labelRes, objectArray));
            } else {
                Object[] objectArray2 = new Object[]{value};
                String string2 = view.getContext().getString(labelRes, objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.context.getString(labelRes, value)");
                String text = string2;
                SpannableString spannable = new SpannableString((CharSequence)text);
                int color2 = ContextCompat.getColor((Context)view.getContext(), (int)colorRes);
                int index = text.length() - value.length();
                if (index > 0) {
                    spannable.setSpan((Object)new ForegroundColorSpan(color2), index, text.length(), 33);
                    view.setText((CharSequence)spannable, TextView.BufferType.SPANNABLE);
                }
            }
        }

        @JvmStatic
        public final void disableCollapseToolbar(@NotNull CollapsingToolbarLayout ctlCollapse, boolean isDisable) {
            Intrinsics.checkNotNullParameter((Object)ctlCollapse, (String)"ctlCollapse");
            ViewGroup.LayoutParams layoutParams = ctlCollapse.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.google.android.material.appbar.AppBarLayout.LayoutParams");
            }
            AppBarLayout.LayoutParams params = (AppBarLayout.LayoutParams)layoutParams;
            if (isDisable) {
                params.setScrollFlags(0);
            } else {
                params.setScrollFlags(3);
            }
            ctlCollapse.setLayoutParams((ViewGroup.LayoutParams)params);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

