/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.logger;

import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import com.netacom.base.chat.logger.FormatStrategy;
import com.netacom.base.chat.logger.LogStrategy;
import com.netacom.base.chat.logger.Utils;
import com.orhanobut.logger.DiskLogStrategy;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0003J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\f2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netacom/base/chat/logger/CsvFormatStrategy;", "Lcom/netacom/base/chat/logger/FormatStrategy;", "builder", "Lcom/netacom/base/chat/logger/CsvFormatStrategy$Builder;", "(Lcom/netacom/base/chat/logger/CsvFormatStrategy$Builder;)V", "date", "Ljava/util/Date;", "dateFormat", "Ljava/text/SimpleDateFormat;", "logStrategy", "Lcom/netacom/base/chat/logger/LogStrategy;", "tag", "", "formatTag", "log", "", "priority", "", "onceOnlyTag", "message", "Builder", "Companion", "netacom-base-chat_NetAloProdRelease"})
public final class CsvFormatStrategy
implements FormatStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNull
    @Nullable
    private final Date date;
    @NonNull
    @Nullable
    private final SimpleDateFormat dateFormat;
    @NonNull
    @Nullable
    private final LogStrategy logStrategy;
    @androidx.annotation.Nullable
    @NotNull
    private final String tag;
    private static final String NEW_LINE = System.getProperty("line.separator");
    @NotNull
    private static final String NEW_LINE_REPLACEMENT = " <br> ";
    @NotNull
    private static final String SEPARATOR = ",";

    private CsvFormatStrategy(@NonNull Builder builder) {
        Utils.INSTANCE.checkNotNull(builder);
        this.date = builder.getDate();
        this.dateFormat = builder.getDateFormat();
        this.logStrategy = builder.getLogStrategy();
        this.tag = builder.getTag();
    }

    @Override
    public void log(int priority, @androidx.annotation.Nullable @Nullable String onceOnlyTag, @NonNull @Nullable String message) {
        if (message == null || onceOnlyTag == null) {
            return;
        }
        String message2 = message;
        Utils.INSTANCE.checkNotNull(message2);
        String tag = this.formatTag(onceOnlyTag);
        Date date = this.date;
        Intrinsics.checkNotNull((Object)date);
        date.setTime(System.currentTimeMillis());
        StringBuilder builder = new StringBuilder();
        builder.append(Long.toString(this.date.getTime()));
        builder.append(SEPARATOR);
        Object object = this.dateFormat;
        Intrinsics.checkNotNull((Object)object);
        builder.append(((DateFormat)object).format(this.date));
        builder.append(SEPARATOR);
        builder.append(Utils.INSTANCE.logLevel(priority));
        builder.append(SEPARATOR);
        builder.append(tag);
        CharSequence charSequence = message2;
        object = NEW_LINE;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NEW_LINE");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)((CharSequence)object), (boolean)false, (int)2, null)) {
            object = message2;
            String string2 = NEW_LINE;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"NEW_LINE");
            boolean bl = false;
            string2 = new Regex(string2);
            String string3 = NEW_LINE_REPLACEMENT;
            boolean bl2 = false;
            message2 = string2.replace((CharSequence)object, string3);
        }
        builder.append(SEPARATOR);
        builder.append(message2);
        builder.append(NEW_LINE);
        object = this.logStrategy;
        if (object != null) {
            object.log(priority, tag, builder.toString());
        }
    }

    @androidx.annotation.Nullable
    private final String formatTag(@androidx.annotation.Nullable String tag) {
        return !Utils.INSTANCE.isEmpty(tag) && !Utils.INSTANCE.equals(this.tag, tag) ? this.tag + '-' + tag : this.tag;
    }

    @JvmStatic
    @NonNull
    @NotNull
    public static final Builder newBuilder() {
        return Companion.newBuilder();
    }

    public /* synthetic */ CsvFormatStrategy(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\u0014\u0010\u0003\u001a\u00020\u00002\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\t\u001a\u00020\u00002\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0007J\u0014\u0010\u000f\u001a\u00020\u00002\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0015\u001a\u00020\u00002\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lcom/netacom/base/chat/logger/CsvFormatStrategy$Builder;", "", "()V", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "setDate", "(Ljava/util/Date;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "getDateFormat", "()Ljava/text/SimpleDateFormat;", "setDateFormat", "(Ljava/text/SimpleDateFormat;)V", "logStrategy", "Lcom/netacom/base/chat/logger/LogStrategy;", "getLogStrategy", "()Lcom/netacom/base/chat/logger/LogStrategy;", "setLogStrategy", "(Lcom/netacom/base/chat/logger/LogStrategy;)V", "tag", "", "getTag", "()Ljava/lang/String;", "setTag", "(Ljava/lang/String;)V", "build", "Lcom/netacom/base/chat/logger/CsvFormatStrategy;", "val", "Companion", "netacom-base-chat_NetAloProdRelease"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private Date date;
        @Nullable
        private SimpleDateFormat dateFormat;
        @Nullable
        private LogStrategy logStrategy;
        @NotNull
        private String tag = "PRETTY_LOGGER";
        private static final int MAX_BYTES = 512000;

        @Nullable
        public final Date getDate() {
            return this.date;
        }

        public final void setDate(@Nullable Date date) {
            this.date = date;
        }

        @Nullable
        public final SimpleDateFormat getDateFormat() {
            return this.dateFormat;
        }

        public final void setDateFormat(@Nullable SimpleDateFormat simpleDateFormat) {
            this.dateFormat = simpleDateFormat;
        }

        @Nullable
        public final LogStrategy getLogStrategy() {
            return this.logStrategy;
        }

        public final void setLogStrategy(@Nullable LogStrategy logStrategy) {
            this.logStrategy = logStrategy;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.tag = string2;
        }

        @NonNull
        @NotNull
        public final Builder date(@androidx.annotation.Nullable @Nullable Date val) {
            this.date = val;
            return this;
        }

        @NonNull
        @NotNull
        public final Builder dateFormat(@androidx.annotation.Nullable @Nullable SimpleDateFormat val) {
            this.dateFormat = val;
            return this;
        }

        @NonNull
        @NotNull
        public final Builder logStrategy(@androidx.annotation.Nullable @Nullable LogStrategy val) {
            this.logStrategy = val;
            return this;
        }

        @NonNull
        @NotNull
        public final Builder tag(@androidx.annotation.Nullable @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.tag = tag;
            return this;
        }

        @NonNull
        @NotNull
        public final CsvFormatStrategy build() {
            if (this.date == null) {
                this.date = new Date();
            }
            if (this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS", Locale.UK);
            }
            if (this.logStrategy == null) {
                String diskPath = Environment.getExternalStorageDirectory().getAbsolutePath();
                String folder = diskPath + File.separatorChar + "com/chat/logger";
                HandlerThread ht = new HandlerThread(Intrinsics.stringPlus((String)"AndroidFileLogger.", (Object)folder));
                ht.start();
                Handler handler = new DiskLogStrategy.WriteHandler(ht.getLooper(), folder, 512000);
                this.logStrategy = new DiskLogStrategy(handler);
            }
            return new CsvFormatStrategy(this, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netacom/base/chat/logger/CsvFormatStrategy$Builder$Companion;", "", "()V", "MAX_BYTES", "", "netacom-base-chat_NetAloProdRelease"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netacom/base/chat/logger/CsvFormatStrategy$Companion;", "", "()V", "NEW_LINE", "", "kotlin.jvm.PlatformType", "NEW_LINE_REPLACEMENT", "SEPARATOR", "newBuilder", "Lcom/netacom/base/chat/logger/CsvFormatStrategy$Builder;", "netacom-base-chat_NetAloProdRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NonNull
        @NotNull
        public final Builder newBuilder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

