/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import com.netacom.base.chat.android_utils.LanguageUtils;
import com.netacom.base.chat.type.Language;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/netacom/base/chat/util/DateTimeUtils;", "", "()V", "DATE_TIME_FORMAT_PATTERN", "", "FULL_DATE_TIME_FORMAT_PATTERN", "JUST_DATE_FORMAT_PATTERN", "JUST_TIME_FORMAT_PATTERN", "convertCountTimeToString", "count", "", "getMillisFromNano", "nanoTime", "getMillisecondFromString", "timeString", "parseCalenderFromString", "Ljava/util/Calendar;", "dateTime", "ParseDateTimeToString", "netacom-base-chat_NetAloDevRelease"})
public final class DateTimeUtils {
    @NotNull
    public static final DateTimeUtils INSTANCE = new DateTimeUtils();
    @NotNull
    public static final String JUST_TIME_FORMAT_PATTERN = "HH:mm";
    @NotNull
    public static final String JUST_DATE_FORMAT_PATTERN = "dd/MM/yyyy";
    @NotNull
    public static final String DATE_TIME_FORMAT_PATTERN = "HH:mm dd/MM/yyyy";
    @NotNull
    public static final String FULL_DATE_TIME_FORMAT_PATTERN = "EEEE, dd/MM/yyyy HH:mm";

    private DateTimeUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String convertCountTimeToString(long count) {
        String string2;
        long h = count / (long)3600;
        long m = (count - h * (long)3600) / (long)60;
        long s = count % (long)60;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string3 = "%02d:%02d";
        Object[] objectArray = new Object[]{m, s};
        boolean bl = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        String ms = string4;
        if (h > 0L) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string3 = "%02d:%s";
            objectArray = new Object[]{h, ms};
            bl = false;
            String string5 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        } else {
            string2 = ms;
        }
        return string2;
    }

    public final long getMillisFromNano(long nanoTime) {
        return String.valueOf(nanoTime).length() > 13 ? TimeUnit.NANOSECONDS.toMillis(nanoTime) : (String.valueOf(nanoTime).length() == 13 ? nanoTime : nanoTime * (long)1000);
    }

    public final long getMillisecondFromString(@NotNull String timeString) {
        Intrinsics.checkNotNullParameter((Object)timeString, (String)"timeString");
        Long l = StringsKt.toLongOrNull((String)timeString);
        return this.getMillisFromNano(l == null ? 0L : l);
    }

    @Nullable
    public final Calendar parseCalenderFromString(long dateTime) {
        if (dateTime <= 0L) {
            return null;
        }
        long milliseconds = this.getMillisFromNano(dateTime);
        if (milliseconds <= 0L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliseconds);
        return calendar;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netacom/base/chat/util/DateTimeUtils$ParseDateTimeToString;", "", "()V", "DATE_TIME_FORMAT_PATTERN", "", "FULL_DATE_TIME_FORMAT_PATTERN", "FULL_DATE_TIME_FORMAT_PATTERN_NO_GET_HOUR_MIN", "JUST_DATE_FORMAT_PATTERN", "JUST_TIME_FORMAT_PATTERN", "parse", "millis", "", "format", "parseDateTime", "parseDurationFromMilliSecond", "milliSecond", "parseDurationFromSecond", "duration", "parseJustDate", "parseJustTime", "netacom-base-chat_NetAloDevRelease"})
    public static final class ParseDateTimeToString {
        @NotNull
        public static final ParseDateTimeToString INSTANCE = new ParseDateTimeToString();
        @NotNull
        public static final String JUST_TIME_FORMAT_PATTERN = "HH:mm";
        @NotNull
        public static final String JUST_DATE_FORMAT_PATTERN = "dd/MM/yyyy";
        @NotNull
        public static final String DATE_TIME_FORMAT_PATTERN = "HH:mm dd/MM/yyyy";
        @NotNull
        public static final String FULL_DATE_TIME_FORMAT_PATTERN = "EEEE, dd/MM/yyyy HH:mm";
        @NotNull
        public static final String FULL_DATE_TIME_FORMAT_PATTERN_NO_GET_HOUR_MIN = "EEEE, dd/MM/yyyy";

        private ParseDateTimeToString() {
        }

        @NotNull
        public final String parseJustTime(long millis) {
            return this.parse(INSTANCE.getMillisFromNano(millis), "HH:mm");
        }

        @NotNull
        public final String parseJustDate(long millis) {
            return this.parse(INSTANCE.getMillisFromNano(millis), "dd/MM/yyyy");
        }

        @NotNull
        public final String parseDateTime(long millis) {
            return this.parse(INSTANCE.getMillisFromNano(millis), "HH:mm dd/MM/yyyy");
        }

        @NotNull
        public final String parse(long millis, @NotNull String format) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            if (Intrinsics.areEqual((Object)LanguageUtils.Companion.getLanguage(), (Object)Language.ENGLISH.getValue())) {
                SimpleDateFormat parser = new SimpleDateFormat(format, Locale.US);
                String string3 = parser.format(new Date(INSTANCE.getMillisFromNano(millis)));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                val pa\u2026o(millis)))\n            }");
                string2 = string3;
            } else {
                Locale locale = new Locale("vi", "VN");
                SimpleDateFormat parser = new SimpleDateFormat(format, locale);
                String string4 = parser.format(new Date(INSTANCE.getMillisFromNano(millis)));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                val lo\u2026o(millis)))\n            }");
                string2 = string4;
            }
            return string2;
        }

        @NotNull
        public final String parseDurationFromMilliSecond(long milliSecond) {
            String string2;
            if (milliSecond > 0L) {
                String string3;
                boolean bl;
                Object[] objectArray;
                String string4;
                StringCompanionObject stringCompanionObject;
                long duration = milliSecond / (long)1000;
                long hour = duration / (long)3600;
                long min = (duration - hour * (long)3600) / (long)60;
                long second = duration % (long)60;
                StringBuilder stringBuilder = new StringBuilder();
                if (hour > 0L) {
                    stringCompanionObject = StringCompanionObject.INSTANCE;
                    string4 = "%02d:";
                    objectArray = new Object[]{hour};
                    bl = false;
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                } else {
                    string3 = "";
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string3);
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string4 = "%02d";
                objectArray = new Object[]{min};
                bl = false;
                String string6 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
                StringBuilder stringBuilder3 = stringBuilder2.append(string6).append(':');
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string4 = "%02d";
                objectArray = new Object[]{second};
                bl = false;
                String string7 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
                string2 = stringBuilder3.append(string7).toString();
            } else {
                string2 = "";
            }
            return string2;
        }

        @NotNull
        public final String parseDurationFromSecond(long duration) {
            String string2;
            if (duration > 0L) {
                String string3;
                boolean bl;
                Object[] objectArray;
                String string4;
                StringCompanionObject stringCompanionObject;
                long hour = duration / (long)3600;
                long min = (duration - hour * (long)3600) / (long)60;
                long second = duration % (long)60;
                StringBuilder stringBuilder = new StringBuilder();
                if (hour > 0L) {
                    stringCompanionObject = StringCompanionObject.INSTANCE;
                    string4 = "%02d:";
                    objectArray = new Object[]{hour};
                    bl = false;
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                } else {
                    string3 = "";
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string3);
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string4 = "%02d";
                objectArray = new Object[]{min};
                bl = false;
                String string6 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
                StringBuilder stringBuilder3 = stringBuilder2.append(string6).append(':');
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string4 = "%02d";
                objectArray = new Object[]{second};
                bl = false;
                String string7 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
                string2 = stringBuilder3.append(string7).toString();
            } else {
                string2 = "";
            }
            return string2;
        }
    }
}

