/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.persistence.UserPersistService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedUserPersistServiceImpl
implements UserPersistService {
    @Autowired
    private DatabaseOperate databaseOperate;
    @Autowired
    private EmbeddedStoragePersistServiceImpl persistService;
    private static final String PATTERN_STR = "*";
    private static final String SQL_DERBY_ESCAPE_BACK_SLASH_FOR_LIKE = " ESCAPE '\\' ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createUser(String username, String password) {
        String sql = "INSERT INTO users (username, password, enabled) VALUES (?, ?, ?)";
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{username, password, true});
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void deleteUser(String username) {
        String sql = "DELETE FROM users WHERE username=?";
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{username});
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void updateUserPassword(String username, String password) {
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)"UPDATE users SET password = ? WHERE username=?", (Object[])new Object[]{password, username});
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public User findUserByUsername(String username) {
        String sql = "SELECT username,password FROM users WHERE username=? ";
        return (User)this.databaseOperate.queryOne(sql, new Object[]{username}, AuthRowMapperManager.USER_ROW_MAPPER);
    }

    @Override
    public Page<User> getUsers(int pageNo, int pageSize, String username) {
        Page pageInfo;
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM users ";
        String sqlFetchRows = "SELECT username,password FROM users ";
        StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)username)) {
            where.append(" AND username = ? ");
            params.add(username);
        }
        if ((pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, AuthRowMapperManager.USER_ROW_MAPPER)) == null) {
            pageInfo = new Page();
            pageInfo.setTotalCount(0);
            pageInfo.setPageItems(new ArrayList());
        }
        return pageInfo;
    }

    @Override
    public List<String> findUserLikeUsername(String username) {
        String sql = "SELECT username FROM users WHERE username LIKE ?  ESCAPE '\\' ";
        return this.databaseOperate.queryMany(sql, (Object[])new String[]{"%" + username + "%"}, String.class);
    }

    @Override
    public Page<User> findUsersLike4Page(String username, int pageNo, int pageSize) {
        String sqlCountRows = "SELECT count(*) FROM users ";
        String sqlFetchRows = "SELECT username,password FROM users ";
        StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)username)) {
            where.append(" AND username LIKE ? ");
            where.append(SQL_DERBY_ESCAPE_BACK_SLASH_FOR_LIKE);
            params.add(this.generateLikeArgument(username));
        }
        PaginationHelper helper = this.persistService.createPaginationHelper();
        return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, AuthRowMapperManager.USER_ROW_MAPPER);
    }

    @Override
    public String generateLikeArgument(String s) {
        String underscore = "_";
        if (s.contains(underscore)) {
            s = s.replaceAll(underscore, "\\\\_");
        }
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }
}

