/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.NacosAuthManager;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.impl.users.User;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class NacosAuthPluginService
implements AuthPluginService {
    private static final String USER_IDENTITY_PARAM_KEY = "user";
    private static final List<String> IDENTITY_NAMES = new LinkedList<String>(){
        {
            this.add("Authorization");
            this.add("accessToken");
            this.add("username");
            this.add("password");
        }
    };
    private NacosAuthManager nacosAuthManager;

    public Collection<String> identityNames() {
        return IDENTITY_NAMES;
    }

    public boolean enableAuth(ActionTypes action, String type) {
        return true;
    }

    public boolean validateIdentity(IdentityContext identityContext, Resource resource) throws AccessException {
        this.checkNacosAuthManager();
        User user = this.nacosAuthManager.login(identityContext);
        identityContext.setParameter(USER_IDENTITY_PARAM_KEY, (Object)user);
        identityContext.setParameter("identity_id", (Object)user.getUserName());
        return true;
    }

    public Boolean validateAuthority(IdentityContext identityContext, Permission permission) throws AccessException {
        NacosUser user = (NacosUser)identityContext.getParameter(USER_IDENTITY_PARAM_KEY);
        this.nacosAuthManager.auth(permission, user);
        return true;
    }

    public String getAuthServiceName() {
        return "nacos";
    }

    private void checkNacosAuthManager() {
        if (null == this.nacosAuthManager) {
            this.nacosAuthManager = (NacosAuthManager)ApplicationUtils.getBean(NacosAuthManager.class);
        }
    }
}

