/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.JwtTokenManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.impl.users.User;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class NacosAuthManager {
    @Autowired
    private JwtTokenManager tokenManager;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private NacosRoleServiceImpl roleService;

    public User login(Object request) throws AccessException {
        HttpServletRequest req = (HttpServletRequest)request;
        String token = this.resolveToken(req);
        this.validate0(token);
        NacosUser user = this.getNacosUser(token);
        req.getSession().setAttribute("nacosuser", (Object)user);
        req.getSession().setAttribute("identity_id", (Object)user.getUserName());
        return user;
    }

    User login(IdentityContext identityContext) throws AccessException {
        String token = this.resolveToken(identityContext);
        this.validate0(token);
        return this.getNacosUser(token);
    }

    public void auth(Permission permission, User user) throws AccessException {
        if (Loggers.AUTH.isDebugEnabled()) {
            Loggers.AUTH.debug("auth permission: {}, user: {}", (Object)permission, (Object)user);
        }
        if (!this.roleService.hasPermission(user.getUserName(), permission)) {
            throw new AccessException("authorization failed!");
        }
    }

    private String resolveToken(HttpServletRequest request) throws AccessException {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        bearerToken = request.getParameter("accessToken");
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            String userName = request.getParameter("username");
            String password = request.getParameter("password");
            bearerToken = this.resolveTokenFromUser(userName, password);
        }
        return bearerToken;
    }

    private String resolveToken(IdentityContext identityContext) throws AccessException {
        String bearerToken = (String)identityContext.getParameter("Authorization", (Object)"");
        if (StringUtils.isNotBlank((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        bearerToken = (String)identityContext.getParameter("accessToken", (Object)"");
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            String userName = (String)identityContext.getParameter("username");
            String password = (String)identityContext.getParameter("password");
            bearerToken = this.resolveTokenFromUser(userName, password);
        }
        return bearerToken;
    }

    private String resolveTokenFromUser(String userName, String rawPassword) throws AccessException {
        Authentication authenticate;
        try {
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)userName, (Object)rawPassword);
            authenticate = this.authenticationManager.authenticate((Authentication)authenticationToken);
        }
        catch (AuthenticationException e) {
            throw new AccessException("unknown user!");
        }
        String finalName = null == authenticate || StringUtils.isBlank((CharSequence)authenticate.getName()) ? userName : authenticate.getName();
        return this.tokenManager.createToken(finalName);
    }

    private void validate0(String token) throws AccessException {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new AccessException("user not found!");
        }
        try {
            this.tokenManager.validateToken(token);
        }
        catch (ExpiredJwtException e) {
            throw new AccessException("token expired!");
        }
        catch (Exception e) {
            throw new AccessException("token invalid!");
        }
    }

    private NacosUser getNacosUser(String token) {
        Authentication authentication = this.tokenManager.getAuthentication(token);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String username = authentication.getName();
        NacosUser user = new NacosUser();
        user.setUserName(username);
        user.setToken(token);
        List<RoleInfo> roleInfoList = this.roleService.getRoles(username);
        if (roleInfoList != null) {
            for (RoleInfo roleInfo : roleInfoList) {
                if (!roleInfo.getRole().equals("ROLE_ADMIN")) continue;
                user.setGlobalAdmin(true);
                break;
            }
        }
        return user;
    }
}

