/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.plugin.auth.impl.JwtAuthenticationEntryPoint;
import com.alibaba.nacos.plugin.auth.impl.JwtTokenManager;
import com.alibaba.nacos.plugin.auth.impl.LdapAuthenticationProvider;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthSystemTypes;
import com.alibaba.nacos.plugin.auth.impl.filter.JwtAuthenticationTokenFilter;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetailsServiceImpl;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsUtils;

@EnableGlobalMethodSecurity(prePostEnabled=true)
public class NacosAuthConfig
extends WebSecurityConfigurerAdapter {
    private static final String SECURITY_IGNORE_URLS_SPILT_CHAR = ",";
    private static final String LOGIN_ENTRY_POINT = "/v1/auth/login";
    private static final String TOKEN_BASED_AUTH_ENTRY_POINT = "/v1/auth/**";
    private static final String DEFAULT_ALL_PATH_PATTERN = "/**";
    private static final String PROPERTY_IGNORE_URLS = "nacos.security.ignore.urls";
    private final Environment env;
    private final JwtTokenManager tokenProvider;
    private final AuthConfigs authConfigs;
    private final NacosUserDetailsServiceImpl userDetailsService;
    private final LdapAuthenticationProvider ldapAuthenticationProvider;
    private final ControllerMethodsCache methodsCache;

    public NacosAuthConfig(Environment env, JwtTokenManager tokenProvider, AuthConfigs authConfigs, NacosUserDetailsServiceImpl userDetailsService, ObjectProvider<LdapAuthenticationProvider> ldapAuthenticationProvider, ControllerMethodsCache methodsCache) {
        this.env = env;
        this.tokenProvider = tokenProvider;
        this.authConfigs = authConfigs;
        this.userDetailsService = userDetailsService;
        this.ldapAuthenticationProvider = (LdapAuthenticationProvider)ldapAuthenticationProvider.getIfAvailable();
        this.methodsCache = methodsCache;
    }

    @PostConstruct
    public void init() {
        this.methodsCache.initClassMethod("com.alibaba.nacos.plugin.auth.impl.controller");
    }

    @Bean(name={"org.springframework.security.authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    public void configure(WebSecurity web) {
        String ignoreUrls = null;
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            ignoreUrls = DEFAULT_ALL_PATH_PATTERN;
        } else if (AuthSystemTypes.LDAP.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            ignoreUrls = DEFAULT_ALL_PATH_PATTERN;
        }
        if (StringUtils.isBlank((CharSequence)this.authConfigs.getNacosAuthSystemType())) {
            ignoreUrls = this.env.getProperty(PROPERTY_IGNORE_URLS, DEFAULT_ALL_PATH_PATTERN);
        }
        if (StringUtils.isNotBlank((String)ignoreUrls)) {
            for (String each : ignoreUrls.trim().split(SECURITY_IGNORE_URLS_SPILT_CHAR)) {
                web.ignoring().antMatchers(new String[]{each.trim()});
            }
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            auth.userDetailsService((UserDetailsService)this.userDetailsService).passwordEncoder(this.passwordEncoder());
        } else if (AuthSystemTypes.LDAP.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            auth.authenticationProvider((AuthenticationProvider)this.ldapAuthenticationProvider);
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.authConfigs.getNacosAuthSystemType())) {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).cors().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().antMatchers(new String[]{LOGIN_ENTRY_POINT})).permitAll().and()).authorizeRequests().antMatchers(new String[]{TOKEN_BASED_AUTH_ENTRY_POINT})).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new JwtAuthenticationEntryPoint());
            http.headers().cacheControl();
            http.addFilterBefore((Filter)new JwtAuthenticationTokenFilter(this.tokenProvider), UsernamePasswordAuthenticationFilter.class);
        }
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

