/*
 * Decompiled with CFR 0.152.
 */
package video.api.uploader.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.uploader.api.models.DeepObject;
import video.api.uploader.api.models.VideoSourceLiveStreamLink;

@ApiModel(description="This appears if the video is from a Live Record.")
public class VideoSourceLiveStream
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_LIVE_STREAM_ID = "liveStreamId";
    @SerializedName(value="liveStreamId")
    private String liveStreamId;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private List<VideoSourceLiveStreamLink> links = null;

    public VideoSourceLiveStream liveStreamId(String liveStreamId) {
        this.liveStreamId = liveStreamId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="li400mYKSgQ6xs7taUeSaEKr", value="The unique identifier for the live stream.")
    public String getLiveStreamId() {
        return this.liveStreamId;
    }

    public void setLiveStreamId(String liveStreamId) {
        this.liveStreamId = liveStreamId;
    }

    public VideoSourceLiveStream links(List<VideoSourceLiveStreamLink> links) {
        this.links = links;
        return this;
    }

    public VideoSourceLiveStream addLinksItem(VideoSourceLiveStreamLink linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<VideoSourceLiveStreamLink>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<VideoSourceLiveStreamLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<VideoSourceLiveStreamLink> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSourceLiveStream videoSourceLiveStream = (VideoSourceLiveStream)o;
        return Objects.equals(this.liveStreamId, videoSourceLiveStream.liveStreamId) && Objects.equals(this.links, videoSourceLiveStream.links);
    }

    public int hashCode() {
        return Objects.hash(this.liveStreamId, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSourceLiveStream {\n");
        sb.append("    liveStreamId: ").append(this.toIndentedString(this.liveStreamId)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

