/*
 * Decompiled with CFR 0.152.
 */
package video.api.player.analytics;

import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.player.analytics.Utils;
import video.api.player.analytics.VideoType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lvideo/api/player/analytics/VideoInfo;", "", "videoId", "", "videoType", "Lvideo/api/player/analytics/VideoType;", "collectorDomainURL", "(Ljava/lang/String;Lvideo/api/player/analytics/VideoType;Ljava/lang/String;)V", "Ljava/net/URL;", "(Ljava/lang/String;Lvideo/api/player/analytics/VideoType;Ljava/net/URL;)V", "getCollectorDomainURL", "()Ljava/net/URL;", "pingUrl", "getPingUrl", "()Ljava/lang/String;", "getVideoId", "getVideoType", "()Lvideo/api/player/analytics/VideoType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "analytics_release"})
public final class VideoInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String videoId;
    @NotNull
    private final VideoType videoType;
    @NotNull
    private final URL collectorDomainURL;
    @NotNull
    private final String pingUrl;

    public VideoInfo(@NotNull String videoId, @NotNull VideoType videoType2, @NotNull URL collectorDomainURL) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)((Object)videoType2), (String)"videoType");
        Intrinsics.checkNotNullParameter((Object)collectorDomainURL, (String)"collectorDomainURL");
        this.videoId = videoId;
        this.videoType = videoType2;
        this.collectorDomainURL = collectorDomainURL;
        this.pingUrl = this.collectorDomainURL + '/' + this.videoType.getType();
    }

    public /* synthetic */ VideoInfo(String string, VideoType videoType2, URL uRL, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            uRL = new URL("https://collector.api.video");
        }
        this(string, videoType2, uRL);
    }

    @NotNull
    public final String getVideoId() {
        return this.videoId;
    }

    @NotNull
    public final VideoType getVideoType() {
        return this.videoType;
    }

    @NotNull
    public final URL getCollectorDomainURL() {
        return this.collectorDomainURL;
    }

    public VideoInfo(@NotNull String videoId, @NotNull VideoType videoType2, @NotNull String collectorDomainURL) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)((Object)videoType2), (String)"videoType");
        Intrinsics.checkNotNullParameter((Object)collectorDomainURL, (String)"collectorDomainURL");
        this(videoId, videoType2, new URL(collectorDomainURL));
    }

    @NotNull
    public final String getPingUrl() {
        return this.pingUrl;
    }

    @NotNull
    public final String component1() {
        return this.videoId;
    }

    @NotNull
    public final VideoType component2() {
        return this.videoType;
    }

    @NotNull
    public final URL component3() {
        return this.collectorDomainURL;
    }

    @NotNull
    public final VideoInfo copy(@NotNull String videoId, @NotNull VideoType videoType2, @NotNull URL collectorDomainURL) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)((Object)videoType2), (String)"videoType");
        Intrinsics.checkNotNullParameter((Object)collectorDomainURL, (String)"collectorDomainURL");
        return new VideoInfo(videoId, videoType2, collectorDomainURL);
    }

    public static /* synthetic */ VideoInfo copy$default(VideoInfo videoInfo, String string, VideoType videoType2, URL uRL, int n, Object object) {
        if ((n & 1) != 0) {
            string = videoInfo.videoId;
        }
        if ((n & 2) != 0) {
            videoType2 = videoInfo.videoType;
        }
        if ((n & 4) != 0) {
            uRL = videoInfo.collectorDomainURL;
        }
        return videoInfo.copy(string, videoType2, uRL);
    }

    @NotNull
    public String toString() {
        return "VideoInfo(videoId=" + this.videoId + ", videoType=" + (Object)((Object)this.videoType) + ", collectorDomainURL=" + this.collectorDomainURL + ')';
    }

    public int hashCode() {
        int result = this.videoId.hashCode();
        result = result * 31 + this.videoType.hashCode();
        result = result * 31 + this.collectorDomainURL.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VideoInfo)) {
            return false;
        }
        VideoInfo videoInfo = (VideoInfo)other;
        if (!Intrinsics.areEqual((Object)this.videoId, (Object)videoInfo.videoId)) {
            return false;
        }
        if (this.videoType != videoInfo.videoType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.collectorDomainURL, (Object)videoInfo.collectorDomainURL);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0006J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\n2\b\b\u0002\u0010\b\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lvideo/api/player/analytics/VideoInfo$Companion;", "", "()V", "fromMediaURL", "Lvideo/api/player/analytics/VideoInfo;", "mediaUrl", "Ljava/net/URL;", "collectorDomainURL", "vodDomainURL", "liveDomainURL", "", "analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VideoInfo fromMediaURL(@NotNull URL mediaUrl, @NotNull URL collectorDomainURL, @NotNull URL vodDomainURL, @NotNull URL liveDomainURL) {
            List list;
            Intrinsics.checkNotNullParameter((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkNotNullParameter((Object)collectorDomainURL, (String)"collectorDomainURL");
            Intrinsics.checkNotNullParameter((Object)vodDomainURL, (String)"vodDomainURL");
            Intrinsics.checkNotNullParameter((Object)liveDomainURL, (String)"liveDomainURL");
            if (Intrinsics.areEqual((Object)vodDomainURL.toString(), (Object)"https://vod.api.video/vod")) {
                Object[] objectArray = new URL[]{vodDomainURL, new URL("https://cdn.api.video/vod")};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)vodDomainURL);
            }
            List vodDomainURLs = list;
            return Utils.INSTANCE.parseMediaUrl(mediaUrl, collectorDomainURL, vodDomainURLs, liveDomainURL);
        }

        public static /* synthetic */ VideoInfo fromMediaURL$default(Companion companion, URL uRL, URL uRL2, URL uRL3, URL uRL4, int n, Object object) {
            if ((n & 2) != 0) {
                uRL2 = new URL("https://collector.api.video");
            }
            if ((n & 4) != 0) {
                uRL3 = new URL("https://vod.api.video/vod");
            }
            if ((n & 8) != 0) {
                uRL4 = new URL("https://live.api.video");
            }
            return companion.fromMediaURL(uRL, uRL2, uRL3, uRL4);
        }

        @NotNull
        public final VideoInfo fromMediaURL(@NotNull String mediaUrl, @NotNull String collectorDomainURL, @NotNull String vodDomainURL, @NotNull String liveDomainURL) {
            Intrinsics.checkNotNullParameter((Object)mediaUrl, (String)"mediaUrl");
            Intrinsics.checkNotNullParameter((Object)collectorDomainURL, (String)"collectorDomainURL");
            Intrinsics.checkNotNullParameter((Object)vodDomainURL, (String)"vodDomainURL");
            Intrinsics.checkNotNullParameter((Object)liveDomainURL, (String)"liveDomainURL");
            return this.fromMediaURL(new URL(mediaUrl), new URL(collectorDomainURL), new URL(vodDomainURL), new URL(liveDomainURL));
        }

        public static /* synthetic */ VideoInfo fromMediaURL$default(Companion companion, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "https://collector.api.video";
            }
            if ((n & 4) != 0) {
                string3 = "https://vod.api.video/vod";
            }
            if ((n & 8) != 0) {
                string4 = "https://live.api.video";
            }
            return companion.fromMediaURL(string, string2, string3, string4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

