/*
 * Decompiled with CFR 0.152.
 */
package video.api.player.analytics;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import video.api.player.analytics.Utils;
import video.api.player.analytics.VideoInfo;
import video.api.player.analytics.VideoType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lvideo/api/player/analytics/Utils;", "", "()V", "nowUtcToIso", "", "parseMediaUrl", "Lvideo/api/player/analytics/VideoInfo;", "mediaUrl", "Ljava/net/URL;", "collectorDomainURL", "vodDomainURLs", "", "liveDomainURL", "analytics_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final String nowUtcToIso() {
        ZonedDateTime zdt = ZonedDateTime.now((ZoneId)ZoneId.of((String)"UTC"));
        String string = zdt.format(DateTimeFormatter.ISO_INSTANT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdt.format(DateTimeFormatter.ISO_INSTANT)");
        return string;
    }

    @NotNull
    public final VideoInfo parseMediaUrl(@NotNull URL mediaUrl, @NotNull URL collectorDomainURL, @NotNull List<URL> vodDomainURLs, @NotNull URL liveDomainURL) {
        Intrinsics.checkNotNullParameter((Object)mediaUrl, (String)"mediaUrl");
        Intrinsics.checkNotNullParameter((Object)collectorDomainURL, (String)"collectorDomainURL");
        Intrinsics.checkNotNullParameter(vodDomainURLs, (String)"vodDomainURLs");
        Intrinsics.checkNotNullParameter((Object)liveDomainURL, (String)"liveDomainURL");
        String regex = "https:/.*[/].*/(?<id>(vi|li)[^/^.]*)[/.].*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(mediaUrl.toString());
        if (matcher.groupCount() < 2) {
            throw new IOException("The media url doesn't look like an api.video URL.");
        }
        try {
            VideoType videoType2;
            boolean bl;
            Object $this$any$iv;
            block11: {
                matcher.find();
                $this$any$iv = vodDomainURLs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        URL it = (URL)element$iv;
                        boolean bl2 = false;
                        String string = mediaUrl.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mediaUrl.toString()");
                        String string2 = string;
                        string = it.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                        if (!StringsKt.startsWith$default((String)string2, (String)string, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                videoType2 = VideoType.VOD;
            } else {
                $this$any$iv = mediaUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"mediaUrl.toString()");
                Object object = $this$any$iv;
                $this$any$iv = liveDomainURL.toString();
                Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"liveDomainURL.toString()");
                if (StringsKt.startsWith$default((String)object, (String)$this$any$iv, (boolean)false, (int)2, null)) {
                    videoType2 = VideoType.LIVE;
                } else {
                    throw new IOException("The media url must start with " + CollectionsKt.joinToString$default((Iterable)vodDomainURLs, null, null, null, (int)0, null, (Function1)parseMediaUrl.videoType.2.INSTANCE, (int)31, null) + " or " + liveDomainURL);
                }
            }
            VideoType videoType3 = videoType2;
            String string = matcher.group(1);
            if (string == null) {
                throw new IOException("Failed to get videoId");
            }
            String videoId = string;
            return new VideoInfo(videoId, videoType3, collectorDomainURL);
        }
        catch (Exception e) {
            throw new IOException("The media url doesn't look like an api.video URL", e);
        }
    }
}

