/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream;

import android.content.Context;
import android.util.Log;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresPermission;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtplibrary.rtmp.RtmpCamera2;
import com.pedro.rtplibrary.view.OpenGlView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.livestream.ApiVideoLiveStream;
import video.api.livestream.ExtensionsKt;
import video.api.livestream.R;
import video.api.livestream.enums.CameraFacingDirection;
import video.api.livestream.interfaces.IConnectionChecker;
import video.api.livestream.models.AudioConfig;
import video.api.livestream.models.VideoConfig;
import video.api.livestream.views.ApiVideoView;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0002\u001b&\u0018\u00002\u00020\u0001B=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000204H\u0002J\b\u00106\u001a\u000204H\u0002J\u0018\u00107\u001a\u0002042\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u000209J\u0006\u0010;\u001a\u000204R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R$\u0010)\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010.\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006<"}, d2={"Lvideo/api/livestream/ApiVideoLiveStream;", "", "context", "Landroid/content/Context;", "connectionChecker", "Lvideo/api/livestream/interfaces/IConnectionChecker;", "initialAudioConfig", "Lvideo/api/livestream/models/AudioConfig;", "initialVideoConfig", "Lvideo/api/livestream/models/VideoConfig;", "initialCamera", "Lvideo/api/livestream/enums/CameraFacingDirection;", "apiVideoView", "Lvideo/api/livestream/views/ApiVideoView;", "(Landroid/content/Context;Lvideo/api/livestream/interfaces/IConnectionChecker;Lvideo/api/livestream/models/AudioConfig;Lvideo/api/livestream/models/VideoConfig;Lvideo/api/livestream/enums/CameraFacingDirection;Lvideo/api/livestream/views/ApiVideoView;)V", "audioConfig", "getAudioConfig", "()Lvideo/api/livestream/models/AudioConfig;", "setAudioConfig", "(Lvideo/api/livestream/models/AudioConfig;)V", "value", "camera", "getCamera", "()Lvideo/api/livestream/enums/CameraFacingDirection;", "setCamera", "(Lvideo/api/livestream/enums/CameraFacingDirection;)V", "connectCheckerRtmp", "video/api/livestream/ApiVideoLiveStream$connectCheckerRtmp$1", "Lvideo/api/livestream/ApiVideoLiveStream$connectCheckerRtmp$1;", "", "isMuted", "()Z", "setMuted", "(Z)V", "isStreaming", "rtmpCamera2", "Lcom/pedro/rtplibrary/rtmp/RtmpCamera2;", "surfaceCallback", "video/api/livestream/ApiVideoLiveStream$surfaceCallback$1", "Lvideo/api/livestream/ApiVideoLiveStream$surfaceCallback$1;", "", "videoBitrate", "getVideoBitrate", "()I", "setVideoBitrate", "(I)V", "videoConfig", "getVideoConfig", "()Lvideo/api/livestream/models/VideoConfig;", "setVideoConfig", "(Lvideo/api/livestream/models/VideoConfig;)V", "prepareAudioEncoders", "", "prepareEncoders", "prepareVideoEncoders", "startStreaming", "streamKey", "", "url", "stopStreaming", "livestream_release"})
public final class ApiVideoLiveStream {
    @NotNull
    private final Context context;
    @NotNull
    private final IConnectionChecker connectionChecker;
    @NotNull
    private final AudioConfig initialAudioConfig;
    @NotNull
    private final VideoConfig initialVideoConfig;
    @NotNull
    private final CameraFacingDirection initialCamera;
    @Nullable
    private final ApiVideoView apiVideoView;
    @NotNull
    private AudioConfig audioConfig;
    @NotNull
    private VideoConfig videoConfig;
    @NotNull
    private final connectCheckerRtmp.1 connectCheckerRtmp;
    @NotNull
    private final surfaceCallback.1 surfaceCallback;
    @NotNull
    private final RtmpCamera2 rtmpCamera2;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(allOf={"android.permission.RECORD_AUDIO", "android.permission.CAMERA"})
    public ApiVideoLiveStream(@NotNull Context context, @NotNull IConnectionChecker connectionChecker, @NotNull AudioConfig initialAudioConfig, @NotNull VideoConfig initialVideoConfig, @NotNull CameraFacingDirection initialCamera, @Nullable ApiVideoView apiVideoView) {
        RtmpCamera2 rtmpCamera2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectionChecker, (String)"connectionChecker");
        Intrinsics.checkNotNullParameter((Object)initialAudioConfig, (String)"initialAudioConfig");
        Intrinsics.checkNotNullParameter((Object)initialVideoConfig, (String)"initialVideoConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)initialCamera), (String)"initialCamera");
        this.context = context;
        this.connectionChecker = connectionChecker;
        this.initialAudioConfig = initialAudioConfig;
        this.initialVideoConfig = initialVideoConfig;
        this.initialCamera = initialCamera;
        this.apiVideoView = apiVideoView;
        this.audioConfig = this.initialAudioConfig;
        this.videoConfig = this.initialVideoConfig;
        this.connectCheckerRtmp = new ConnectCheckerRtmp(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAuthErrorRtmp() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onAuthError();
            }

            public void onAuthSuccessRtmp() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onAuthSuccess();
            }

            public void onConnectionFailedRtmp(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onConnectionFailed(reason);
            }

            public void onConnectionStartedRtmp(@NotNull String rtmpUrl) {
                Intrinsics.checkNotNullParameter((Object)rtmpUrl, (String)"rtmpUrl");
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onConnectionStarted(rtmpUrl);
            }

            public void onConnectionSuccessRtmp() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onConnectionSuccess();
            }

            public void onDisconnectRtmp() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onDisconnect();
            }

            public void onNewBitrateRtmp(long bitrate) {
            }
        };
        this.surfaceCallback = new SurfaceHolder.Callback(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void surfaceCreated(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }

            public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                ApiVideoLiveStream.access$getRtmpCamera2$p(this.this$0).startPreview(ApiVideoLiveStream.access$getInitialCamera$p(this.this$0).getFacing());
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                if (ApiVideoLiveStream.access$getRtmpCamera2$p(this.this$0).isStreaming()) {
                    ApiVideoLiveStream.access$getRtmpCamera2$p(this.this$0).stopStream();
                }
                ApiVideoLiveStream.access$getRtmpCamera2$p(this.this$0).stopPreview();
            }
        };
        ApiVideoLiveStream apiVideoLiveStream = this;
        if (this.apiVideoView != null) {
            this.apiVideoView.getHolder().addCallback((SurfaceHolder.Callback)this.surfaceCallback);
            rtmpCamera2 = new RtmpCamera2((OpenGlView)this.apiVideoView, (ConnectCheckerRtmp)this.connectCheckerRtmp);
        } else {
            void $this$rtmpCamera2_u24lambda_u2d0;
            RtmpCamera2 rtmpCamera22 = new RtmpCamera2(this.context, true, (ConnectCheckerRtmp)this.connectCheckerRtmp);
            boolean bl = false;
            boolean bl2 = false;
            RtmpCamera2 rtmpCamera23 = rtmpCamera22;
            ApiVideoLiveStream apiVideoLiveStream2 = apiVideoLiveStream;
            boolean bl3 = false;
            $this$rtmpCamera2_u24lambda_u2d0.startPreview(this.initialCamera.getFacing());
            Unit unit = Unit.INSTANCE;
            apiVideoLiveStream = apiVideoLiveStream2;
            rtmpCamera2 = rtmpCamera22;
        }
        apiVideoLiveStream.rtmpCamera2 = rtmpCamera2;
        this.prepareAudioEncoders();
        this.prepareVideoEncoders();
        this.rtmpCamera2.setLogs(false);
    }

    public /* synthetic */ ApiVideoLiveStream(Context context, IConnectionChecker iConnectionChecker, AudioConfig audioConfig, VideoConfig videoConfig, CameraFacingDirection cameraFacingDirection, ApiVideoView apiVideoView, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            cameraFacingDirection = CameraFacingDirection.BACK;
        }
        if ((n & 0x20) != 0) {
            apiVideoView = null;
        }
        this(context, iConnectionChecker, audioConfig, videoConfig, cameraFacingDirection, apiVideoView);
    }

    @NotNull
    public final AudioConfig getAudioConfig() {
        return this.audioConfig;
    }

    public final void setAudioConfig(@NotNull AudioConfig audioConfig) {
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"<set-?>");
        this.audioConfig = audioConfig;
    }

    @NotNull
    public final VideoConfig getVideoConfig() {
        return this.videoConfig;
    }

    public final void setVideoConfig(@NotNull VideoConfig value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("You have to stop streaming first");
        }
        if (this.videoConfig.getResolution() != value.getResolution()) {
            Log.i((String)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName(), (String)("Resolution has been changed from " + (Object)((Object)this.videoConfig.getResolution()) + " to " + (Object)((Object)value.getResolution()) + ". Restarting preview."));
            this.rtmpCamera2.stopPreview();
            this.rtmpCamera2.startPreview(this.rtmpCamera2.getCameraFacing(), value.getResolution().getSize().getWidth(), value.getResolution().getSize().getHeight());
        }
        this.videoConfig = value;
    }

    public final int getVideoBitrate() {
        return this.rtmpCamera2.getBitrate();
    }

    public final void setVideoBitrate(int value) {
        this.rtmpCamera2.setVideoBitrateOnFly(value);
    }

    @NotNull
    public final CameraFacingDirection getCamera() {
        return this.rtmpCamera2.getCameraFacing() == CameraHelper.Facing.FRONT ? CameraFacingDirection.FRONT : CameraFacingDirection.BACK;
    }

    public final void setCamera(@NotNull CameraFacingDirection value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (value == CameraFacingDirection.BACK && this.rtmpCamera2.getCameraFacing() == CameraHelper.Facing.FRONT || value == CameraFacingDirection.FRONT && this.rtmpCamera2.getCameraFacing() == CameraHelper.Facing.BACK) {
            this.rtmpCamera2.switchCamera();
        }
    }

    public final boolean isMuted() {
        return this.rtmpCamera2.isAudioMuted();
    }

    public final void setMuted(boolean value) {
        if (value) {
            this.rtmpCamera2.disableAudio();
        } else {
            this.rtmpCamera2.enableAudio();
        }
    }

    private final void prepareAudioEncoders() {
        this.rtmpCamera2.prepareAudio(this.audioConfig.getBitrate(), this.audioConfig.getSampleRate(), this.audioConfig.getStereo(), this.audioConfig.getEchoCanceler(), this.audioConfig.getNoiseSuppressor());
    }

    private final void prepareVideoEncoders() {
        this.rtmpCamera2.prepareVideo(this.videoConfig.getResolution().getSize().getWidth(), this.videoConfig.getResolution().getSize().getHeight(), this.videoConfig.getFps(), this.videoConfig.getBitrate(), CameraHelper.getCameraOrientation((Context)this.context));
    }

    private final void prepareEncoders() {
        this.prepareVideoEncoders();
        this.prepareAudioEncoders();
    }

    public final void startStreaming(@NotNull String streamKey, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)streamKey, (String)"streamKey");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.rtmpCamera2.isStreaming()) {
            throw new UnsupportedOperationException("Stream is already started");
        }
        this.prepareEncoders();
        this.rtmpCamera2.startStream(Intrinsics.stringPlus((String)ExtensionsKt.addTrailingSlashIfNeeded(url), (Object)streamKey));
    }

    public static /* synthetic */ void startStreaming$default(ApiVideoLiveStream apiVideoLiveStream, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            String string4 = apiVideoLiveStream.context.getString(R.string.default_rtmp_url);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fun startStreaming(\n    \u2026eded() + streamKey)\n    }");
            string3 = string4;
        }
        apiVideoLiveStream.startStreaming(string2, string3);
    }

    public final void stopStreaming() {
        this.rtmpCamera2.stopStream();
    }

    public final boolean isStreaming() {
        return this.rtmpCamera2.isStreaming();
    }

    public static final /* synthetic */ IConnectionChecker access$getConnectionChecker$p(ApiVideoLiveStream $this) {
        return $this.connectionChecker;
    }

    public static final /* synthetic */ RtmpCamera2 access$getRtmpCamera2$p(ApiVideoLiveStream $this) {
        return $this.rtmpCamera2;
    }

    public static final /* synthetic */ CameraFacingDirection access$getInitialCamera$p(ApiVideoLiveStream $this) {
        return $this.initialCamera;
    }
}

