/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import video.api.client.api.models.DeepObject;
import video.api.client.api.models.Metadata;
import video.api.client.api.models.Nullable;

public class VideoUpdatePayload
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private Nullable<String> playerId;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public;
    public static final String SERIALIZED_NAME_PANORAMIC = "panoramic";
    @SerializedName(value="panoramic")
    private Boolean panoramic;
    public static final String SERIALIZED_NAME_MP4_SUPPORT = "mp4Support";
    @SerializedName(value="mp4Support")
    private Boolean mp4Support;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private List<Metadata> metadata = null;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private LanguageEnum language;
    public static final String SERIALIZED_NAME_TRANSCRIPT = "transcript";
    @SerializedName(value="transcript")
    private Boolean transcript;
    public static final String SERIALIZED_NAME_TRANSCRIPT_SUMMARY = "transcriptSummary";
    @SerializedName(value="transcriptSummary")
    private Boolean transcriptSummary;
    public static final String SERIALIZED_NAME_TRANSCRIPT_SUMMARY_ATTRIBUTES = "transcriptSummaryAttributes";
    @SerializedName(value="transcriptSummaryAttributes")
    private List<TranscriptSummaryAttributesEnum> transcriptSummaryAttributes = null;

    public VideoUpdatePayload playerId(String playerId) {
        this.playerId = new Nullable<String>(playerId);
        return this;
    }

    public VideoUpdatePayload unsetPlayerId() {
        this.playerId = null;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="pl4k0jvEUuaTdRAEjQ4Jfrgz", value="The unique ID for the player you want to associate with your video.")
    public String getPlayerId() {
        return this.playerId == null ? null : this.playerId.getValue();
    }

    public void setPlayerId(String playerId) {
        this.playerId = new Nullable<String>(playerId);
    }

    public VideoUpdatePayload title(String title) {
        this.title = title;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(value="The title you want to use for your video.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public VideoUpdatePayload description(String description) {
        this.description = description;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="A film about good books.", value="A brief description of the video.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VideoUpdatePayload _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="true", value="Whether the video is publicly available or not. False means it is set to private. Default is true. Tutorials on [private videos](https://api.video/blog/endpoints/private-videos/).")
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public VideoUpdatePayload panoramic(Boolean panoramic) {
        this.panoramic = panoramic;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="false", value="Whether the video is a 360 degree or immersive video.")
    public Boolean getPanoramic() {
        return this.panoramic;
    }

    public void setPanoramic(Boolean panoramic) {
        this.panoramic = panoramic;
    }

    public VideoUpdatePayload mp4Support(Boolean mp4Support) {
        this.mp4Support = mp4Support;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="true", value="Whether the player supports the mp4 format.")
    public Boolean getMp4Support() {
        return this.mp4Support;
    }

    public void setMp4Support(Boolean mp4Support) {
        this.mp4Support = mp4Support;
    }

    public VideoUpdatePayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public VideoUpdatePayload addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="[\"maths\", \"string theory\", \"video\"]", value="A list of terms or words you want to tag the video with. Make sure the list includes all the tags you want as whatever you send in this list will overwrite the existing list for the video.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public VideoUpdatePayload metadata(List<Metadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public VideoUpdatePayload addMetadataItem(Metadata metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<Metadata>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(value="A list (array) of dictionaries where each dictionary contains a key value pair that describes the video. As with tags, you must send the complete list of metadata you want as whatever you send here will overwrite the existing metadata for the video.")
    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Metadata> metadata) {
        this.metadata = metadata;
    }

    public VideoUpdatePayload language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="fr", value="Use this parameter to set the language of the video. When this parameter is set, the API creates a transcript of the video using the language you specify. You must use the [IETF language tag](https://en.wikipedia.org/wiki/IETF_language_tag) format.  `language` is a permanent attribute of the video. You can update it to another language using the [`PATCH /videos/{videoId}`](https://docs.api.video/reference/api/Videos#update-a-video-object) operation. This triggers the API to generate a new transcript using a different language.")
    public LanguageEnum getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public VideoUpdatePayload transcript(Boolean transcript) {
        this.transcript = transcript;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(value="Use this parameter to enable transcription.   - When `true`, the API generates a transcript for the video. - The default value is `false`. - If you define a video language using the `language` parameter, the API uses that language to transcribe the video. If you do not define a language, the API detects it based on the video.  - When the API generates a transcript, it will be available as a caption for the video.")
    public Boolean getTranscript() {
        return this.transcript;
    }

    public void setTranscript(Boolean transcript) {
        this.transcript = transcript;
    }

    public VideoUpdatePayload transcriptSummary(Boolean transcriptSummary) {
        this.transcriptSummary = transcriptSummary;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(value="Use this parameter to enable summarization.   - When `true`, the API generates a summary for the video, based on the transcription. - The default value is `false`. - If you define a video language using the `language` parameter, the API uses that language to summarize the video. If you do not define a language, the API detects it based on the video.")
    public Boolean getTranscriptSummary() {
        return this.transcriptSummary;
    }

    public void setTranscriptSummary(Boolean transcriptSummary) {
        this.transcriptSummary = transcriptSummary;
    }

    public VideoUpdatePayload transcriptSummaryAttributes(List<TranscriptSummaryAttributesEnum> transcriptSummaryAttributes) {
        this.transcriptSummaryAttributes = transcriptSummaryAttributes;
        return this;
    }

    public VideoUpdatePayload addTranscriptSummaryAttributesItem(TranscriptSummaryAttributesEnum transcriptSummaryAttributesItem) {
        if (this.transcriptSummaryAttributes == null) {
            this.transcriptSummaryAttributes = new ArrayList<TranscriptSummaryAttributesEnum>();
        }
        this.transcriptSummaryAttributes.add(transcriptSummaryAttributesItem);
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(value="Use this parameter to define the elements of a summary that you want to generate. If you do not define this parameter, the API generates a full summary with all attributes.")
    public List<TranscriptSummaryAttributesEnum> getTranscriptSummaryAttributes() {
        return this.transcriptSummaryAttributes;
    }

    public void setTranscriptSummaryAttributes(List<TranscriptSummaryAttributesEnum> transcriptSummaryAttributes) {
        this.transcriptSummaryAttributes = transcriptSummaryAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoUpdatePayload videoUpdatePayload = (VideoUpdatePayload)o;
        return Objects.equals(this.playerId, videoUpdatePayload.playerId) && Objects.equals(this.title, videoUpdatePayload.title) && Objects.equals(this.description, videoUpdatePayload.description) && Objects.equals(this._public, videoUpdatePayload._public) && Objects.equals(this.panoramic, videoUpdatePayload.panoramic) && Objects.equals(this.mp4Support, videoUpdatePayload.mp4Support) && Objects.equals(this.tags, videoUpdatePayload.tags) && Objects.equals(this.metadata, videoUpdatePayload.metadata) && Objects.equals((Object)this.language, (Object)videoUpdatePayload.language) && Objects.equals(this.transcript, videoUpdatePayload.transcript) && Objects.equals(this.transcriptSummary, videoUpdatePayload.transcriptSummary) && Objects.equals(this.transcriptSummaryAttributes, videoUpdatePayload.transcriptSummaryAttributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.playerId, this.title, this.description, this._public, this.panoramic, this.mp4Support, this.tags, this.metadata, this.language, this.transcript, this.transcriptSummary, this.transcriptSummaryAttributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoUpdatePayload {\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    panoramic: ").append(this.toIndentedString(this.panoramic)).append("\n");
        sb.append("    mp4Support: ").append(this.toIndentedString(this.mp4Support)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    transcript: ").append(this.toIndentedString(this.transcript)).append("\n");
        sb.append("    transcriptSummary: ").append(this.toIndentedString(this.transcriptSummary)).append("\n");
        sb.append("    transcriptSummaryAttributes: ").append(this.toIndentedString(this.transcriptSummaryAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LanguageEnum {
        AR("ar"),
        CA("ca"),
        CS("cs"),
        DA("da"),
        DE("de"),
        EL("el"),
        EN("en"),
        ES("es"),
        FA("fa"),
        FI("fi"),
        FR("fr"),
        HE("he"),
        HI("hi"),
        HR("hr"),
        HU("hu"),
        IT("it"),
        JA("ja"),
        KO("ko"),
        ML("ml"),
        NL("nl"),
        NN("nn"),
        FALSE("false"),
        PL("pl"),
        PT("pt"),
        RU("ru"),
        SK("sk"),
        SL("sl"),
        TE("te"),
        TR("tr"),
        UK("uk"),
        UR("ur"),
        VI("vi"),
        ZH("zh");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LanguageEnum fromValue(String value) {
            for (LanguageEnum b : LanguageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LanguageEnum> {
            public void write(JsonWriter jsonWriter, LanguageEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LanguageEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LanguageEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TranscriptSummaryAttributesEnum {
        ABSTRACT("abstract"),
        TAKEAWAYS("takeaways");

        private String value;

        private TranscriptSummaryAttributesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TranscriptSummaryAttributesEnum fromValue(String value) {
            for (TranscriptSummaryAttributesEnum b : TranscriptSummaryAttributesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TranscriptSummaryAttributesEnum> {
            public void write(JsonWriter jsonWriter, TranscriptSummaryAttributesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TranscriptSummaryAttributesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TranscriptSummaryAttributesEnum.fromValue(value);
            }
        }
    }
}

