/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.DeepObject;
import video.api.client.api.models.RestreamsRequestObject;

public class LiveStreamUpdatePayload
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private String playerId;
    public static final String SERIALIZED_NAME_RESTREAMS = "restreams";
    @SerializedName(value="restreams")
    private List<RestreamsRequestObject> restreams = null;

    public LiveStreamUpdatePayload name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My Live Stream Video", value="The name you want to use for your live stream.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LiveStreamUpdatePayload _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether your video can be viewed by everyone, or requires authentication to see it. A setting of false will require a unique token for each view. Learn more about the Private Video feature [here](https://docs.api.video/delivery/video-privacy-access-management).")
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public LiveStreamUpdatePayload playerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pl45KFKdlddgk654dspkze", value="The unique ID for the player associated with a live stream that you want to update.")
    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public LiveStreamUpdatePayload restreams(List<RestreamsRequestObject> restreams) {
        this.restreams = restreams;
        return this;
    }

    public LiveStreamUpdatePayload addRestreamsItem(RestreamsRequestObject restreamsItem) {
        if (this.restreams == null) {
            this.restreams = new ArrayList<RestreamsRequestObject>();
        }
        this.restreams.add(restreamsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use this parameter to add, edit, or remove `RTMPS` or `RTMP` services where you want to restream a live stream. The list can only contain up to 5 destinations. This operation updates all restream destinations in the same request. If you do not want to modify an existing restream destination, you need to include it in your request, otherwise it is removed.")
    public List<RestreamsRequestObject> getRestreams() {
        return this.restreams;
    }

    public void setRestreams(List<RestreamsRequestObject> restreams) {
        this.restreams = restreams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveStreamUpdatePayload liveStreamUpdatePayload = (LiveStreamUpdatePayload)o;
        return Objects.equals(this.name, liveStreamUpdatePayload.name) && Objects.equals(this._public, liveStreamUpdatePayload._public) && Objects.equals(this.playerId, liveStreamUpdatePayload.playerId) && Objects.equals(this.restreams, liveStreamUpdatePayload.restreams);
    }

    public int hashCode() {
        return Objects.hash(this.name, this._public, this.playerId, this.restreams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiveStreamUpdatePayload {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("    restreams: ").append(this.toIndentedString(this.restreams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

