/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;
import video.api.client.api.models.DeepObject;

public class Summary
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_SUMMARY_ID = "summaryId";
    @SerializedName(value="summaryId")
    private String summaryId;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_VIDEO_ID = "videoId";
    @SerializedName(value="videoId")
    private String videoId;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    private OriginEnum origin;
    public static final String SERIALIZED_NAME_SOURCE_STATUS = "sourceStatus";
    @SerializedName(value="sourceStatus")
    private SourceStatusEnum sourceStatus;

    public Summary summaryId(String summaryId) {
        this.summaryId = summaryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="summary_1CGHWuXjhxmeH4WiZ51234", value="The unique identifier of the summary object.")
    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String summaryId) {
        this.summaryId = summaryId;
    }

    public Summary createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2024-05-28T11:15:07Z", value="Returns the date and time when the summary was created in ATOM date-time format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Summary updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2024-05-28T11:15:07Z", value="Returns the date and time when the summary was last updated in ATOM date-time format.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Summary videoId(String videoId) {
        this.videoId = videoId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="vi4k0jvEUuaTdRAEjQ4Prklg", value="The unique identifier of the video object.")
    public String getVideoId() {
        return this.videoId;
    }

    public void setVideoId(String videoId) {
        this.videoId = videoId;
    }

    public Summary origin(OriginEnum origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Returns the origin of how the summary was created.  - `api` means that no summary was generated automatically. You can add summary manually using the `PATCH /summaries/{summaryId}/source` endpoint operation. Until this happens, `sourceStatus` returns `missing`. - `auto` means that the API generated the summary automatically.")
    public OriginEnum getOrigin() {
        return this.origin;
    }

    public void setOrigin(OriginEnum origin) {
        this.origin = origin;
    }

    public Summary sourceStatus(SourceStatusEnum sourceStatus) {
        this.sourceStatus = sourceStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Returns the current status of summary generation.  `missing`: the input for a summary is not present. `waiting` : the input video is being processed and a summary will be generated. `failed`: a technical issue prevented summary generation. `completed`: the summary is generated. `unprocessable`: the API rules the source video to be unsuitable for summary generation. An example for this is an input video that has no audio.")
    public SourceStatusEnum getSourceStatus() {
        return this.sourceStatus;
    }

    public void setSourceStatus(SourceStatusEnum sourceStatus) {
        this.sourceStatus = sourceStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Summary summary = (Summary)o;
        return Objects.equals(this.summaryId, summary.summaryId) && Objects.equals(this.createdAt, summary.createdAt) && Objects.equals(this.updatedAt, summary.updatedAt) && Objects.equals(this.videoId, summary.videoId) && Objects.equals((Object)this.origin, (Object)summary.origin) && Objects.equals((Object)this.sourceStatus, (Object)summary.sourceStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.summaryId, this.createdAt, this.updatedAt, this.videoId, this.origin, this.sourceStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Summary {\n");
        sb.append("    summaryId: ").append(this.toIndentedString(this.summaryId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    videoId: ").append(this.toIndentedString(this.videoId)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString((Object)this.origin)).append("\n");
        sb.append("    sourceStatus: ").append(this.toIndentedString((Object)this.sourceStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OriginEnum {
        API("api"),
        AUTO("auto");

        private String value;

        private OriginEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OriginEnum fromValue(String value) {
            for (OriginEnum b : OriginEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OriginEnum> {
            public void write(JsonWriter jsonWriter, OriginEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OriginEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OriginEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SourceStatusEnum {
        MISSING("missing"),
        WAITING("waiting"),
        FAILED("failed"),
        COMPLETED("completed"),
        UNPROCESSABLE("unprocessable");

        private String value;

        private SourceStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SourceStatusEnum fromValue(String value) {
            for (SourceStatusEnum b : SourceStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SourceStatusEnum> {
            public void write(JsonWriter jsonWriter, SourceStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SourceStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SourceStatusEnum.fromValue(value);
            }
        }
    }
}

