/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Environment;
import video.api.client.api.models.Page;
import video.api.client.api.models.Watermark;
import video.api.client.api.models.WatermarksListResponse;

public class WatermarksApi {
    private ApiClient localVarApiClient;

    public WatermarksApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public WatermarksApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public WatermarksApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public WatermarksApi(Environment environment) {
        this.localVarApiClient = new ApiClient(environment.basePath);
    }

    public WatermarksApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public WatermarksApi(String apiKey, Environment environment) {
        this.localVarApiClient = new ApiClient(apiKey, environment.basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call uploadCall(File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/watermarks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call uploadValidateBeforeCall(File file, ApiCallback _callback) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        Call localVarCall = this.uploadCall(file, _callback);
        return localVarCall;
    }

    public Watermark upload(File file) throws ApiException {
        ApiResponse<Watermark> localVarResp = this.uploadWithHttpInfo(file);
        return localVarResp.getData();
    }

    public ApiResponse<Watermark> uploadWithHttpInfo(File file) throws ApiException {
        Call localVarCall = this.uploadValidateBeforeCall(file, null);
        Type localVarReturnType = new TypeToken<Watermark>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadAsync(File file, ApiCallback<Watermark> _callback) throws ApiException {
        Call localVarCall = this.uploadValidateBeforeCall(file, _callback);
        Type localVarReturnType = new TypeToken<Watermark>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call deleteCall(String watermarkId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/watermarks/{watermarkId}".replaceAll("\\{watermarkId\\}", this.localVarApiClient.escapeString(watermarkId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call deleteValidateBeforeCall(String watermarkId, ApiCallback _callback) throws ApiException {
        if (watermarkId == null) {
            throw new ApiException("Missing the required parameter 'watermarkId' when calling delete");
        }
        Call localVarCall = this.deleteCall(watermarkId, _callback);
        return localVarCall;
    }

    public void delete(String watermarkId) throws ApiException {
        this.deleteWithHttpInfo(watermarkId);
    }

    public ApiResponse<Void> deleteWithHttpInfo(String watermarkId) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(watermarkId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAsync(String watermarkId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(watermarkId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/watermarks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call listValidateBeforeCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(sortBy, sortOrder, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<WatermarksListResponse> listWithHttpInfo(String sortBy, String sortOrder, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(sortBy, sortOrder, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<WatermarksListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAsync(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback<WatermarksListResponse> _callback) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(sortBy, sortOrder, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<WatermarksListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRequest list() {
        return new APIlistRequest();
    }

    public class APIlistRequest {
        private String sortBy;
        private String sortOrder;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest() {
        }

        public APIlistRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WatermarksApi.this.listCall(this.sortBy, this.sortOrder, this.currentPage, this.pageSize, _callback);
        }

        public Page<Watermark> execute() throws ApiException {
            ApiResponse localVarResp = WatermarksApi.this.listWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
            return new Page<Watermark>(((WatermarksListResponse)localVarResp.getData()).getData(), ((WatermarksListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest();
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<WatermarksListResponse> executeWithHttpInfo() throws ApiException {
            return WatermarksApi.this.listWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<Watermark>> _callback) throws ApiException {
            ApiCallback<WatermarksListResponse> apiCallback = new ApiCallback<WatermarksListResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(WatermarksListResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<Watermark>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIlistRequest.this.copy().currentPage((APIlistRequest.this.currentPage == null ? 1 : APIlistRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return WatermarksApi.this.listAsync(this.sortBy, this.sortOrder, this.currentPage, this.pageSize, apiCallback);
        }
    }
}

